/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.snowflake.snowpark_java.types.Geography;
import com.snowflake.snowpark_java.types.VariantTypes;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class Variant
implements Serializable {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final JsonNode value;
    private final VariantTypes type;

    private Variant(JsonNode value, VariantTypes type) {
        this.value = value;
        this.type = type;
    }

    Variant(JsonNode value, String typeStr) {
        VariantTypes dt;
        this.value = value;
        switch (typeStr) {
            case "RealNumber": {
                dt = VariantTypes.RealNumber;
                break;
            }
            case "FixedNumber": {
                dt = VariantTypes.FixedNumber;
                break;
            }
            case "Boolean": {
                dt = VariantTypes.Boolean;
                break;
            }
            case "String": {
                dt = VariantTypes.String;
                break;
            }
            case "Binary": {
                dt = VariantTypes.Binary;
                break;
            }
            case "Time": {
                dt = VariantTypes.Time;
                break;
            }
            case "Date": {
                dt = VariantTypes.Date;
                break;
            }
            case "Timestamp": {
                dt = VariantTypes.Timestamp;
                break;
            }
            default: {
                throw new IllegalArgumentException("Type: " + typeStr + " doesn't exist");
            }
        }
        this.type = dt;
    }

    public Variant(float num) {
        this((JsonNode)JsonNodeFactory.instance.numberNode(num), VariantTypes.RealNumber);
    }

    public Variant(double num) {
        this((JsonNode)JsonNodeFactory.instance.numberNode(num), VariantTypes.RealNumber);
    }

    public Variant(long num) {
        this((JsonNode)JsonNodeFactory.instance.numberNode(num), VariantTypes.FixedNumber);
    }

    public Variant(int num) {
        this((JsonNode)JsonNodeFactory.instance.numberNode(num), VariantTypes.FixedNumber);
    }

    public Variant(short num) {
        this((JsonNode)JsonNodeFactory.instance.numberNode(num), VariantTypes.FixedNumber);
    }

    public Variant(BigDecimal num) {
        this((JsonNode)JsonNodeFactory.instance.numberNode(num), VariantTypes.FixedNumber);
    }

    public Variant(BigInteger num) {
        this((JsonNode)JsonNodeFactory.instance.numberNode(num), VariantTypes.FixedNumber);
    }

    public Variant(boolean value) {
        this((JsonNode)JsonNodeFactory.instance.booleanNode(value), VariantTypes.Boolean);
    }

    public Variant(String str) {
        JsonNode node;
        try {
            node = MAPPER.readTree(str);
        }
        catch (Exception e) {
            node = JsonNodeFactory.instance.textNode(str);
        }
        this.value = node;
        this.type = VariantTypes.String;
    }

    public Variant(byte[] bytes) {
        this((JsonNode)JsonNodeFactory.instance.binaryNode(bytes), VariantTypes.Binary);
    }

    public Variant(Time time) {
        this((JsonNode)JsonNodeFactory.instance.textNode(time.toString()), VariantTypes.Time);
    }

    public Variant(Date date) {
        this((JsonNode)JsonNodeFactory.instance.textNode(date.toString()), VariantTypes.Date);
    }

    public Variant(Timestamp timestamp) {
        this((JsonNode)JsonNodeFactory.instance.textNode(timestamp.toString()), VariantTypes.Timestamp);
    }

    public Variant(List<Object> list) {
        ArrayNode arr = MAPPER.createArrayNode();
        list.forEach(obj -> arr.add(Variant.objectToJsonNode(obj)));
        this.value = arr;
        this.type = VariantTypes.Array;
    }

    public Variant(Object[] arr) {
        this(Arrays.asList(arr));
    }

    public Variant(Object obj) {
        Object node;
        if (obj instanceof Map) {
            ObjectNode result = MAPPER.createObjectNode();
            Map map = (Map)obj;
            map.keySet().forEach(key -> result.set(key.toString(), Variant.objectToJsonNode(map.get(key))));
            node = result;
            this.type = VariantTypes.Object;
        } else if (obj instanceof Object[]) {
            ArrayNode result = MAPPER.createArrayNode();
            for (Object o : (Object[])obj) {
                result.add(Variant.objectToJsonNode(o));
            }
            node = result;
            this.type = VariantTypes.Array;
        } else {
            node = MAPPER.valueToTree(obj);
            this.type = VariantTypes.String;
        }
        this.value = node;
    }

    public float asFloat() {
        this.verify(VariantTypes.RealNumber);
        return (float)this.asDouble();
    }

    public double asDouble() {
        this.verify(VariantTypes.RealNumber);
        return this.value.asDouble();
    }

    public short asShort() {
        this.verify(VariantTypes.FixedNumber);
        return (short)this.asInt();
    }

    public int asInt() {
        this.verify(VariantTypes.FixedNumber);
        return this.value.asInt();
    }

    public long asLong() {
        this.verify(VariantTypes.FixedNumber);
        return this.value.asLong();
    }

    public BigDecimal asBigDecimal() {
        this.verify(VariantTypes.RealNumber);
        if (this.value.isBoolean()) {
            return new BigDecimal(this.asInt());
        }
        return this.value.decimalValue();
    }

    public BigInteger asBigInteger() {
        this.verify(VariantTypes.FixedNumber);
        if (this.value.isBoolean()) {
            return BigInteger.valueOf(this.asInt());
        }
        return this.value.bigIntegerValue();
    }

    public String asString() {
        this.verify(VariantTypes.String);
        if (this.value.isBinary()) {
            byte[] decoded = Base64.decodeBase64((String)this.value.asText());
            return Hex.encodeHexString((byte[])decoded);
        }
        if (this.value.isValueNode()) {
            return this.value.asText();
        }
        return this.value.toString();
    }

    public String asJsonString() {
        this.verify(VariantTypes.String);
        if (this.value.isBinary()) {
            byte[] decoded = Base64.decodeBase64((String)this.value.asText());
            return "\"" + Hex.encodeHexString((byte[])decoded) + "\"";
        }
        return this.value.toString();
    }

    public byte[] asBinary() {
        this.verify(VariantTypes.Binary);
        try {
            return this.value.binaryValue();
        }
        catch (Exception e) {
            try {
                return Hex.decodeHex((char[])this.value.asText().toCharArray());
            }
            catch (Exception e1) {
                throw new UncheckedIOException(new IOException("Failed to convert " + this.value.asText() + " to Binary. Only Hex string is supported."));
            }
        }
    }

    public Time asTime() {
        this.verify(VariantTypes.Time);
        return Time.valueOf(this.value.asText());
    }

    public Date asDate() {
        this.verify(VariantTypes.Date);
        return Date.valueOf(this.value.asText());
    }

    public Timestamp asTimestamp() {
        this.verify(VariantTypes.Timestamp);
        if (this.value.isNumber()) {
            return new Timestamp(this.value.asLong());
        }
        return Timestamp.valueOf(this.value.asText());
    }

    public boolean asBoolean() {
        this.verify(VariantTypes.Boolean);
        return this.value.asBoolean();
    }

    public Variant[] asArray() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof ArrayNode) {
            ArrayNode arr = (ArrayNode)this.value;
            int size = arr.size();
            Variant[] result = new Variant[size];
            for (int i = 0; i < size; ++i) {
                result[i] = new Variant(arr.get(i).toString());
            }
            return result;
        }
        throw new UncheckedIOException(new IOException("Failed to convert " + this.value.asText() + " to Array"));
    }

    public List<Variant> asList() {
        return Arrays.asList(this.asArray());
    }

    public Map<String, Variant> asMap() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof ObjectNode) {
            ObjectNode map = (ObjectNode)this.value;
            HashMap<String, Variant> result = new HashMap<String, Variant>();
            Iterator<Map.Entry<String, JsonNode>> fields = map.fields();
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> field = fields.next();
                result.put(field.getKey(), new Variant(field.getValue().toString()));
            }
            return result;
        }
        throw new UncheckedIOException(new IOException("Failed to convert " + this.value.asText() + " to Map"));
    }

    public boolean equals(Object other) {
        if (other instanceof Variant) {
            return this.value.equals(((Variant)other).value);
        }
        return false;
    }

    public int hashCode() {
        int hash = 13;
        hash = 23 * hash + (this.value == null ? 0 : this.value.hashCode());
        hash = 23 * hash + (this.type == null ? 0 : this.type.hashCode());
        return hash;
    }

    public String toString() {
        return this.asString();
    }

    JsonNode getValue() {
        return this.value;
    }

    VariantTypes getType() {
        return this.type;
    }

    private static JsonNode objectToJsonNode(Object obj) {
        if (obj instanceof Variant) {
            return ((Variant)obj).value;
        }
        if (obj instanceof Geography) {
            return new Variant((String)((Geography)obj).asGeoJSON()).value;
        }
        return MAPPER.valueToTree(obj);
    }

    private void verify(VariantTypes target) {
        if (this.type == target) {
            return;
        }
        if (this.type == VariantTypes.String) {
            return;
        }
        if (target == VariantTypes.String) {
            return;
        }
        if (this.type == VariantTypes.RealNumber && target == VariantTypes.Timestamp) {
            return;
        }
        if (this.type == VariantTypes.FixedNumber && target == VariantTypes.Timestamp) {
            return;
        }
        if (this.type == VariantTypes.Boolean && target == VariantTypes.RealNumber) {
            return;
        }
        if (this.type == VariantTypes.Boolean && target == VariantTypes.FixedNumber) {
            return;
        }
        if (this.type == VariantTypes.FixedNumber && target == VariantTypes.RealNumber) {
            return;
        }
        if (this.type == VariantTypes.RealNumber && target == VariantTypes.FixedNumber) {
            return;
        }
        throw new UncheckedIOException(new IOException("Conversion from Variant of " + (Object)((Object)this.type) + " to " + (Object)((Object)target) + " is not supported"));
    }
}

