/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.Solclient;
import com.solacesystems.solclientj.core.event.FlowEventCallback;
import com.solacesystems.solclientj.core.event.MessageCallback;
import com.solacesystems.solclientj.core.handle.FlowHandle;
import com.solacesystems.solclientj.core.handle.NativeDestinationHandle;
import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.ClientNameImpl;
import com.solacesystems.solclientj.core.impl.DestinationStruct;
import com.solacesystems.solclientj.core.impl.FlowHandleImpl;
import com.solacesystems.solclientj.core.impl.QueueImpl;
import com.solacesystems.solclientj.core.impl.TopicEndpointImpl;
import com.solacesystems.solclientj.core.impl.util.ExceptionGuard;
import com.solacesystems.solclientj.core.impl.util.SolLogger;
import com.solacesystems.solclientj.core.resource.ClientName;
import com.solacesystems.solclientj.core.resource.Destination;
import com.solacesystems.solclientj.core.resource.Endpoint;
import com.solacesystems.solclientj.core.resource.MutableTopic;
import com.solacesystems.solclientj.core.resource.Queue;
import com.solacesystems.solclientj.core.resource.Subscription;
import com.solacesystems.solclientj.core.resource.Topic;
import com.solacesystems.solclientj.core.resource.TopicEndpoint;
import java.nio.charset.StandardCharsets;

public class ConceptConvertUtil {
    private static final SolLogger LOGGER = SolLogger.getLogger(ConceptConvertUtil.class.getName());

    public static int getDestinationType(Destination destination) {
        if (destination == null) {
            return -1;
        }
        if (destination instanceof NativeDestinationHandle) {
            throw new IllegalArgumentException("NativeDestinationHandle is not a supported type of destination for this operation");
        }
        boolean isTemporary = destination.isTemporary();
        int destinationType = isTemporary ? (destination instanceof Queue ? 3 : 2) : (destination instanceof Queue ? 1 : 0);
        return destinationType;
    }

    public static String[] computeEndPointProperties(Endpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullEndpoint"));
        }
        if (endpoint instanceof TopicEndpoint) {
            return ((TopicEndpointImpl)endpoint).getProperties();
        }
        if (endpoint instanceof Queue) {
            return ((QueueImpl)endpoint).getProperties();
        }
        if (endpoint instanceof ClientName) {
            return ((ClientNameImpl)endpoint).getProperties();
        }
        throw new IllegalArgumentException("Unsupported Endpoint Type [" + endpoint + "]");
    }

    public static String[] computeEndPointProperties(Endpoint endpoint, String[] userProvidedEndpointProperties) {
        if (endpoint == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullEndpoint"));
        }
        int additionalEndpointProperties = 0;
        int lastNotNull = 0;
        if (userProvidedEndpointProperties != null) {
            additionalEndpointProperties = userProvidedEndpointProperties.length;
            for (int i = 0; i < additionalEndpointProperties && userProvidedEndpointProperties[i] != null; ++i) {
                ++lastNotNull;
            }
        }
        String[] jniEndpointProperties = new String[4 + lastNotNull];
        int props = 0;
        if (userProvidedEndpointProperties != null && lastNotNull > 0) {
            System.arraycopy(userProvidedEndpointProperties, 0, jniEndpointProperties, props, lastNotNull);
            props = lastNotNull;
        }
        jniEndpointProperties[props++] = "ENDPOINT_ID";
        if (endpoint instanceof TopicEndpoint) {
            jniEndpointProperties[props++] = "3";
        } else if (endpoint instanceof Queue) {
            jniEndpointProperties[props++] = "2";
        } else if (endpoint instanceof ClientName) {
            jniEndpointProperties[props++] = "4";
        } else {
            throw new IllegalArgumentException("Unsupported Endpoint Type [" + endpoint + "]");
        }
        if (endpoint.getName() != null && !endpoint.getName().equals("")) {
            jniEndpointProperties[props++] = "ENDPOINT_NAME";
            jniEndpointProperties[props++] = endpoint.getName();
        }
        return jniEndpointProperties;
    }

    public static String[] validateForFlowCreate(FlowHandle in_out_flowHandle, String[] flowProperties, Endpoint endpoint, Subscription subscription, MessageCallback messageCallback, FlowEventCallback flowEventCallback, boolean allowNullMessageCallback) {
        int i;
        if (endpoint == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullEndpoint"));
        }
        ExceptionGuard.assertUsableUnboundHandle("validateForFlowCreate", in_out_flowHandle, "Common.NullFlowHandle");
        if (messageCallback == null && !allowNullMessageCallback) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullMessageCallback"));
        }
        if (flowEventCallback == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullFlowEventCallback"));
        }
        String[] jniEndpointProperties = ConceptConvertUtil.computeEndPointProperties(endpoint);
        int jniEndpointPropertiesSize = jniEndpointProperties.length;
        int flowPropertiesSize = 0;
        if (flowProperties != null) {
            flowPropertiesSize = flowProperties.length;
        }
        String[] jniFlowProperties = new String[flowPropertiesSize + jniEndpointPropertiesSize + 8];
        int jniFlowPropertiesIndex = 0;
        if (flowProperties != null) {
            for (i = 0; i < flowProperties.length; ++i) {
                if (flowProperties[i] == null) continue;
                jniFlowProperties[jniFlowPropertiesIndex++] = flowProperties[i];
            }
        }
        for (i = 0; i < jniEndpointProperties.length; ++i) {
            if (jniEndpointProperties[i] == null) continue;
            jniFlowProperties[jniFlowPropertiesIndex++] = jniEndpointProperties[i];
        }
        if (endpoint instanceof TopicEndpoint) {
            String topicName;
            if (subscription == null) {
                throw new IllegalArgumentException("subscription must be non-null when endpoint is of type TopicEndpoint");
            }
            if (!(subscription instanceof Topic)) {
                throw new IllegalArgumentException("Invalid subscription type, expecting a Topic instance instead of " + subscription.getClass().getName());
            }
            Topic topic = null;
            if (subscription instanceof MutableTopic) {
                MutableTopic mutableTopic = (MutableTopic)subscription;
                int originalPos = mutableTopic.getNameBuffer().position();
                int originalLimit = mutableTopic.getNameBuffer().limit();
                boolean isNullTerminated = false;
                byte nullByte = 0;
                while (mutableTopic.getNameBuffer().hasRemaining()) {
                    if (nullByte != mutableTopic.getNameBuffer().get()) continue;
                    int newLimit = mutableTopic.getNameBuffer().position() - 1;
                    mutableTopic.getNameBuffer().limit(newLimit).position(originalPos);
                    isNullTerminated = true;
                    break;
                }
                if (!isNullTerminated) {
                    mutableTopic.getNameBuffer().position(originalPos).limit(originalLimit);
                }
                topicName = StandardCharsets.UTF_8.decode(mutableTopic.getNameBuffer()).toString();
                mutableTopic.getNameBuffer().position(originalPos).limit(originalLimit);
            } else {
                topic = (Topic)subscription;
                topicName = topic.getName();
            }
            jniFlowProperties[jniFlowPropertiesIndex++] = "FLOW_BIND_ENTITY_ID";
            jniFlowProperties[jniFlowPropertiesIndex++] = "3";
            jniFlowProperties[jniFlowPropertiesIndex++] = "FLOW_TOPIC";
            jniFlowProperties[jniFlowPropertiesIndex++] = topicName;
            jniFlowProperties[jniFlowPropertiesIndex++] = "FLOW_BIND_ENTITY_DURABLE";
            String string = jniFlowProperties[jniFlowPropertiesIndex++] = endpoint.isDurable() ? "1" : "0";
            if (!endpoint.isDurable()) {
                if (endpoint.getName() != null && !endpoint.getName().equals("")) {
                    jniFlowProperties[jniFlowPropertiesIndex++] = "FLOW_BIND_NAME";
                    jniFlowProperties[jniFlowPropertiesIndex++] = endpoint.getName();
                }
                if (topic != null) {
                    if (topic.isTemporary()) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("About to create a Flow bound to a temporary topic '" + topic.getName() + "'" + "with non-durable endpoint '" + endpoint.getName() + "'");
                        }
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("About to create a Flow bound to a non temporary topic '" + topic.getName() + "'" + "with non-durable endpoint '" + endpoint.getName() + "'");
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("About to create a Flow bound to a non temporary mutable topic with non-durable endpoint '" + endpoint.getName() + "'");
                }
            } else {
                jniFlowProperties[jniFlowPropertiesIndex++] = "FLOW_BIND_NAME";
                jniFlowProperties[jniFlowPropertiesIndex++] = endpoint.getName();
                if (topic != null) {
                    if (topic.isTemporary()) {
                        throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.RequiredTempSubscriptionWithDurableEndpoint"));
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("About to create a Flow bound to a non temporary topic '" + topic.getName() + "'" + "with durable endpoint '" + endpoint.getName() + "'");
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("About to create a Flow bound to a non temporary mutable topic with durable endpoint '" + endpoint.getName() + "'");
                }
            }
        } else if (endpoint instanceof Queue) {
            if (subscription != null) {
                throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.InvalidSubscriptionWithQueue"));
            }
            Queue queue = (Queue)endpoint;
            jniFlowProperties[jniFlowPropertiesIndex++] = "FLOW_BIND_ENTITY_ID";
            jniFlowProperties[jniFlowPropertiesIndex++] = "2";
            if (queue.getName() != null) {
                jniFlowProperties[jniFlowPropertiesIndex++] = "FLOW_BIND_NAME";
                jniFlowProperties[jniFlowPropertiesIndex++] = queue.getName();
            }
            jniFlowProperties[jniFlowPropertiesIndex++] = "FLOW_BIND_ENTITY_DURABLE";
            String string = jniFlowProperties[jniFlowPropertiesIndex++] = queue.isTemporary() ? "0" : "1";
            if (!queue.isTemporary()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("About to create a Flow bound to a non temporary queue '" + queue.getName() + "'");
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("About to create a Flow bound to a temporary queue '" + queue.getName() + "'");
            }
        } else {
            throw new IllegalArgumentException("endpoint of type (" + endpoint.getClass().getName() + ") is not supported");
        }
        if (messageCallback != null) {
            ((FlowHandleImpl)in_out_flowHandle).registerMessageCallback(messageCallback);
        }
        if (allowNullMessageCallback && messageCallback == null) {
            ((FlowHandleImpl)in_out_flowHandle).unregisterMessageCallback();
        }
        ((FlowHandleImpl)in_out_flowHandle).registerFlowEventCallback(flowEventCallback);
        return jniFlowProperties;
    }

    public static Destination getDestination(DestinationStruct destinationStruct) {
        if (destinationStruct == null) {
            return null;
        }
        switch (destinationStruct.destinationType) {
            case -1: {
                return null;
            }
            case 3: {
                return new QueueImpl(destinationStruct.destination, true, null);
            }
            case 2: {
                return new TopicEndpointImpl(destinationStruct.destination, false, null);
            }
            case 1: {
                return Solclient.Allocator.newQueue(destinationStruct.destination, null);
            }
            case 0: {
                return Solclient.Allocator.newTopic(destinationStruct.destination);
            }
        }
        throw new IllegalArgumentException("Unable to make Determine the Destination based on  EnumDestinationType[" + destinationStruct.destinationType + "]");
    }
}

