/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.SolclientException;
import com.solacesystems.solclientj.core.event.MessageCallback;
import com.solacesystems.solclientj.core.event.SessionEventCallback;
import com.solacesystems.solclientj.core.handle.ContextHandle;
import com.solacesystems.solclientj.core.handle.SessionHandle;
import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.AbstractBaseHandleImpl;
import com.solacesystems.solclientj.core.impl.SessionHandleImpl;
import com.solacesystems.solclientj.core.impl.ccsmp.CCSMPServices;
import com.solacesystems.solclientj.core.impl.util.ExceptionGuard;

public final class ContextHandleImpl
extends AbstractBaseHandleImpl
implements ContextHandle {
    private static final CCSMPServices ccsmp_services = CCSMPServices.onlyInstance();
    private static final String createSessionForHandle = "createSessionForHandle";
    private static final String solClient_session_create = "solClient_session_create";
    private static final String solClient_context_destroy = "solClient_context_destroy";
    private static final String createSessionForHandle_ = "createSessionForHandle:";

    public ContextHandleImpl() {
    }

    public ContextHandleImpl(long value) {
        super(value);
    }

    @Override
    public int createSessionForHandle(SessionHandle in_out_sessionHandle, String[] properties, MessageCallback messageCallback, SessionEventCallback sessionEventCallback) throws SolclientException {
        ExceptionGuard.assertUsableUnboundHandle(createSessionForHandle, in_out_sessionHandle, "Common.NullSessionHandle");
        if (messageCallback == null) {
            throw new IllegalArgumentException(createSessionForHandle_ + SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullMessageCallback"));
        }
        if (sessionEventCallback == null) {
            throw new IllegalArgumentException(createSessionForHandle_ + SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullSessionEventCallback"));
        }
        int rc = ccsmp_services.getJNISession().solClient_session_create(this.getPointerValue(), properties, in_out_sessionHandle);
        ExceptionGuard.assertReturnCode(rc, solClient_session_create);
        SessionHandleImpl sessionH = (SessionHandleImpl)in_out_sessionHandle;
        sessionH.registerMessageCallback(messageCallback);
        sessionH.registerSessionEventCallback(sessionEventCallback);
        return rc;
    }

    @Override
    public void destroy() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIContext().solClient_context_destroy(this.getPointerValue()), solClient_context_destroy);
        this.setPointerValue(0L);
    }
}

