/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.impl.NativeThreadHandler;
import com.solacesystems.solclientj.core.impl.util.SolLogger;

public class NativeThreadHandlerImpl
implements NativeThreadHandler {
    private static final SolLogger LOGGER = SolLogger.getLogger(NativeThreadHandler.class.getName());
    private Thread.UncaughtExceptionHandler eh;

    public NativeThreadHandlerImpl() {
        this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.critical("a uncaught exception was encountered on Native Thread " + t.toString(), e);
            }
        });
    }

    protected Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.eh;
    }

    protected void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.eh = uncaughtExceptionHandler;
    }

    @Override
    public void onThreadAttach() {
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            Thread.setDefaultUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
        }
    }

    @Override
    public void onThreadDetach() {
    }
}

