/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core;

import com.solacesystems.solclientj.core.SolEnum;
import com.solacesystems.solclientj.core.SolclientErrorInfo;

public class SolclientException
extends RuntimeException {
    private SolclientErrorInfo m_errorInfo = null;
    private int m_returnCode = 0;
    private static final long serialVersionUID = 1L;

    public SolclientException(String message, SolclientErrorInfo errorInfo, int returnCode) {
        super(message + ":" + errorInfo.toString());
        this.m_errorInfo = errorInfo;
        this.m_returnCode = returnCode;
    }

    public SolclientException(SolclientErrorInfo errorInfo, int returnCode) {
        super(errorInfo.toString());
        this.m_errorInfo = errorInfo;
        this.m_returnCode = returnCode;
    }

    public SolclientException(String message, int returnCode) {
        super(message);
        this.m_returnCode = returnCode;
    }

    public SolclientErrorInfo getSolclientErrorInfo() {
        return this.m_errorInfo;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        sb.append(" returnCode [");
        sb.append(this.m_returnCode);
        sb.append(":");
        sb.append(SolEnum.ReturnCode.toString(this.m_returnCode));
        sb.append("]");
        return sb.toString();
    }

    public int getReturnCode() {
        return this.m_returnCode;
    }
}

