/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public class SolLogger {
    private Logger logger;

    private SolLogger() {
    }

    public void setLevel(SolLevel solLevel) {
        this.logger.setLevel(solLevel.getJavaLogLevel());
    }

    public SolLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    public static SolLogger getLogger(String name) {
        return new SolLogger(name);
    }

    public boolean isCriticalEnabled() {
        return this.logger.isLoggable(SolLevel.CRITICAL.getJavaLogLevel());
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(SolLevel.ERROR.getJavaLogLevel());
    }

    public boolean isWarningEnabled() {
        return this.logger.isLoggable(SolLevel.WARNING.getJavaLogLevel());
    }

    public boolean isNoticeEnabled() {
        return this.logger.isLoggable(SolLevel.NOTICE.getJavaLogLevel());
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(SolLevel.INFO.getJavaLogLevel());
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(SolLevel.DEBUG.getJavaLogLevel());
    }

    public boolean isLoggable(SolLevel solLevel) {
        return this.logger.isLoggable(solLevel.getJavaLogLevel());
    }

    public void debug(String msg) {
        this.logger.log(SolLevel.DEBUG.getJavaLogLevel(), msg);
    }

    public void debug(String msg, Throwable thrown) {
        this.logger.log(SolLevel.DEBUG.getJavaLogLevel(), msg, thrown);
    }

    public void info(String msg) {
        this.logger.log(SolLevel.INFO.getJavaLogLevel(), msg);
    }

    public void info(String msg, Throwable thrown) {
        this.logger.log(SolLevel.INFO.getJavaLogLevel(), msg, thrown);
    }

    public void notice(String msg) {
        this.logger.log(SolLevel.NOTICE.getJavaLogLevel(), msg);
    }

    public void notice(String msg, Throwable thrown) {
        this.logger.log(SolLevel.NOTICE.getJavaLogLevel(), msg, thrown);
    }

    public void warning(String msg) {
        this.logger.log(SolLevel.WARNING.getJavaLogLevel(), msg);
    }

    public void warning(String msg, Throwable thrown) {
        this.logger.log(SolLevel.WARNING.getJavaLogLevel(), msg, thrown);
    }

    public void error(String msg) {
        this.logger.log(SolLevel.ERROR.getJavaLogLevel(), msg);
    }

    public void error(String msg, Throwable thrown) {
        this.logger.log(SolLevel.ERROR.getJavaLogLevel(), msg, thrown);
    }

    public void critical(String msg) {
        this.logger.log(SolLevel.CRITICAL.getJavaLogLevel(), msg);
    }

    public void critical(String msg, Throwable thrown) {
        this.logger.log(SolLevel.CRITICAL.getJavaLogLevel(), msg, thrown);
    }

    public void log(SolLevel level, String msg) {
        this.logger.log(level.getJavaLogLevel(), msg);
    }

    public void log(SolLevel level, String msg, Throwable thrown) {
        this.logger.log(level.getJavaLogLevel(), msg, thrown);
    }

    public static SolLevel getSolLevelFromSolEnumLogLevel(int level) {
        switch (level) {
            case 7: {
                return SolLevel.DEBUG;
            }
            case 6: {
                return SolLevel.INFO;
            }
            case 5: {
                return SolLevel.NOTICE;
            }
            case 4: {
                return SolLevel.WARNING;
            }
            case 3: {
                return SolLevel.ERROR;
            }
            case 2: {
                return SolLevel.CRITICAL;
            }
            case 0: 
            case 1: {
                return SolLevel.EMERGENCY;
            }
        }
        return SolLevel.WARNING;
    }

    public static int getSolEnumLogLevelFromSolLevel(SolLevel level) {
        switch (level) {
            case DEBUG: {
                return 7;
            }
            case INFO: {
                return 6;
            }
            case NOTICE: {
                return 5;
            }
            case WARNING: {
                return 4;
            }
            case ERROR: {
                return 3;
            }
            case CRITICAL: {
                return 2;
            }
            case EMERGENCY: {
                return 0;
            }
        }
        return 4;
    }

    public static SolLevel getSolLevelFromJavaLevel(Level javaLevelValue) {
        for (SolLevel solLevel : SolLevel.values()) {
            if (!solLevel.getJavaLogLevel().equals(javaLevelValue)) continue;
            return solLevel;
        }
        if (javaLevelValue == Level.FINER) {
            return SolLevel.INFO;
        }
        if (javaLevelValue == Level.ALL) {
            return SolLevel.DEBUG;
        }
        if (javaLevelValue == Level.CONFIG) {
            return SolLevel.NOTICE;
        }
        if (javaLevelValue == Level.OFF) {
            return SolLevel.EMERGENCY;
        }
        return SolLevel.NOTICE;
    }

    public static enum SolLevel {
        EMERGENCY(Level.SEVERE),
        CRITICAL(Level.SEVERE),
        ERROR(Level.SEVERE),
        WARNING(Level.WARNING),
        NOTICE(Level.INFO),
        INFO(Level.FINE),
        DEBUG(Level.FINEST);

        private Level javaLogLevel;

        private SolLevel(Level javaLevelValue) {
            this.javaLogLevel = javaLevelValue;
        }

        public Level getJavaLogLevel() {
            return this.javaLogLevel;
        }
    }
}

