/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.SolclientException;
import com.solacesystems.solclientj.core.handle.MessageHandle;
import com.solacesystems.solclientj.core.handle.MutableInteger;
import com.solacesystems.solclientj.core.handle.MutableLong;
import com.solacesystems.solclientj.core.handle.NativeDestinationHandle;
import com.solacesystems.solclientj.core.handle.ReplicationGroupMessageIdHandle;
import com.solacesystems.solclientj.core.handle.SessionHandle;
import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.AbstractBaseHandleImpl;
import com.solacesystems.solclientj.core.impl.ConceptConvertUtil;
import com.solacesystems.solclientj.core.impl.DestinationStruct;
import com.solacesystems.solclientj.core.impl.MutableTopicImpl;
import com.solacesystems.solclientj.core.impl.NativeDestinationHandleImpl;
import com.solacesystems.solclientj.core.impl.ReplicationGroupMessageIdHandleImpl;
import com.solacesystems.solclientj.core.impl.SessionHandleImpl;
import com.solacesystems.solclientj.core.impl.ccsmp.CCSMPServices;
import com.solacesystems.solclientj.core.impl.util.ExceptionGuard;
import com.solacesystems.solclientj.core.impl.util.GenericPool;
import com.solacesystems.solclientj.core.impl.util.PoolUtil;
import com.solacesystems.solclientj.core.resource.Destination;
import com.solacesystems.solclientj.core.resource.MutableTopic;
import java.nio.ByteBuffer;

public final class MessageHandleImpl
extends AbstractBaseHandleImpl
implements MessageHandle {
    private static final CCSMPServices ccsmp_services = CCSMPServices.onlyInstance();

    public MessageHandleImpl() {
    }

    public MessageHandleImpl(long value) {
        super(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCorrelationId() throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getCorrelationId(this.getPointerValue(), sb), "solClient_msg_getCorrelationId");
            if (rc == 0) {
                String string = sb.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    @Override
    public void setCorrelationId(String correlationId) throws SolclientException {
        if (correlationId == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullUseDeleteInstead"));
        }
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setCorrelationId(this.getPointerValue(), correlationId), "solClient_msg_setCorrelationId");
    }

    @Override
    public void deleteCorrelationId() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_deleteCorrelationId(this.getPointerValue()), "solClient_msg_deleteCorrelationId");
    }

    @Override
    public void setQueuePartitionKey(String queuePartitionKey) throws SolclientException {
        if (queuePartitionKey == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullUseDeleteInstead"));
        }
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setQueuePartitionKey(this.getPointerValue(), queuePartitionKey), "solClient_container_addString");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getQueuePartitionKey() throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getQueuePartitionKey(this.getPointerValue(), sb), "solClient_msg_getUserPropertyMap");
            if (rc == 0) {
                String string = sb.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    @Override
    public void deleteQueuePartitionKey() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_deleteQueuePartitionKey(this.getPointerValue()), "solClient_container_deleteField");
    }

    @Override
    public void setBinaryAttachment(ByteBuffer binaryAttachment) throws SolclientException {
        if (binaryAttachment != null && binaryAttachment.hasArray()) {
            int curPosition = binaryAttachment.position();
            this.setBinaryAttachment(binaryAttachment.array(), binaryAttachment.arrayOffset() + curPosition, binaryAttachment.limit() - curPosition);
            binaryAttachment.position(binaryAttachment.limit());
        } else {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setBinaryAttachment(this.getPointerValue(), binaryAttachment), "solClient_msg_setBinaryAttachment_ByteBuffer");
        }
    }

    @Override
    public void setBinaryAttachment(byte[] content) throws SolclientException {
        this.setBinaryAttachment(content, 0, content == null ? 0 : content.length);
    }

    @Override
    public void setBinaryAttachment(byte[] content, int offset, int length) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setBinaryAttachment(this.getPointerValue(), content, offset, length), "solClient_msg_setBinaryAttachment");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBinaryAttachment(ByteBuffer binaryAttachment) throws SolclientException {
        if (binaryAttachment == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullBinaryAttachment"));
        }
        GenericPool.PoolEntry<MutableInteger> pe = PoolUtil.mutableIntegerPool.borrowFromPool();
        MutableInteger mi = pe.getEntry();
        try {
            int rc = 0;
            int curPosition = binaryAttachment.position();
            if (binaryAttachment.hasArray()) {
                rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getBinaryAttachment(this.getPointerValue(), binaryAttachment.array(), binaryAttachment.arrayOffset() + curPosition, mi), "solClient_msg_getBinaryAttachment_byteArray");
                if (rc == 0) {
                    binaryAttachment.position(mi.getValue() + curPosition);
                }
            } else {
                rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getBinaryAttachment(this.getPointerValue(), binaryAttachment, mi), "solClient_msg_getBinaryAttachment_ByteBuffer");
            }
            if (rc != 0) {
                int n = 0;
                return n;
            }
            int n = mi.getValue();
            return n;
        }
        finally {
            mi.setValue(0);
            PoolUtil.mutableIntegerPool.returnToPool(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination getDestination() throws SolclientException {
        GenericPool.PoolEntry<DestinationStruct> pe = PoolUtil.destinationStructPool.borrowFromPool();
        DestinationStruct ds = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getDestination(this.getPointerValue(), ds), "solClient_msg_getDestination_DestinationStruct");
            if (rc == 0) {
                Destination destination = ConceptConvertUtil.getDestination(ds);
                return destination;
            }
            Destination destination = null;
            return destination;
        }
        finally {
            PoolUtil.destinationStructPool.returnToPool(pe);
        }
    }

    @Override
    public MutableTopic getDestination(MutableTopic mutableTopic) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getDestination(this.getPointerValue(), mutableTopic.getNameBuffer()), "solClient_msg_getDestination_ByteBuffer");
        return mutableTopic;
    }

    @Override
    public void setDestination(Destination destination) throws SolclientException {
        if (destination instanceof NativeDestinationHandle) {
            NativeDestinationHandleImpl nativeDestinationHandleImpl = (NativeDestinationHandleImpl)destination;
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setDestination(this.getPointerValue(), nativeDestinationHandleImpl.getPointerValue()), "solClient_msg_setDestination_long");
        } else if (destination instanceof MutableTopic) {
            MutableTopicImpl mutableTopic = (MutableTopicImpl)destination;
            if (mutableTopic.getNameBuffer() == null) {
                throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullDestinationName"));
            }
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setDestination(this.getPointerValue(), mutableTopic.getNameBuffer(), ConceptConvertUtil.getDestinationType(destination)), "solClient_msg_setDestination_ByteBuffer");
        } else {
            if (destination != null && destination.getName() == null) {
                throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullDestinationName"));
            }
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setDestination(this.getPointerValue(), destination == null ? null : destination.getName(), ConceptConvertUtil.getDestinationType(destination)), "solClient_msg_setDestination_String");
        }
    }

    @Override
    public void setDestinationFromMessageReplyTo(MessageHandle replyToMessageHandle) throws SolclientException {
        if (replyToMessageHandle == null) {
            return;
        }
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setDestinationFromMessageReplyTo(this.getPointerValue(), ((MessageHandleImpl)replyToMessageHandle).getPointerValue()), "solClient_msg_setDestinationFromMessageReplyTo");
    }

    @Override
    public void setCorrelationIdFromMessage(MessageHandle replyToMessageHandle) throws SolclientException {
        if (replyToMessageHandle == null) {
            return;
        }
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setCorrelationIdFromMessage(this.getPointerValue(), ((MessageHandleImpl)replyToMessageHandle).getPointerValue()), "solClient_msg_setCorrelationIdFromMessage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dump(int dumpMode) throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_dumpExt(this.getPointerValue(), dumpMode, 0, sb), "solClient_msg_dumpExt");
            String string = sb.toString();
            return string;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dump(int dumpMode, int maxStrLen) throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_dumpExt(this.getPointerValue(), dumpMode, maxStrLen, sb), "solClient_msg_dumpExt");
            String string = sb.toString();
            return string;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    @Override
    public int getCorrelationKey(MutableLong correlationKey) {
        if (correlationKey == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullMutableLong"));
        }
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getCorrelationTag(this.getPointerValue(), correlationKey), "solClient_msg_getCorrelationTag");
    }

    @Override
    public void setCorrelationKey(long tag) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setCorrelationTag(this.getPointerValue(), tag), "solClient_msg_setCorrelationTag");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getGuaranteedMessageId() throws SolclientException {
        GenericPool.PoolEntry<MutableLong> pe = PoolUtil.mutableLongPool.borrowFromPool();
        MutableLong ml = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getMsgId(this.getPointerValue(), ml), "solClient_msg_getMsgId");
            if (rc != 0) {
                long l = 0L;
                return l;
            }
            long l = ml.getValue();
            return l;
        }
        finally {
            PoolUtil.mutableLongPool.returnToPool(pe);
        }
    }

    @Override
    public int getCacheRequestId(MutableLong cacheRequestId) throws SolclientException {
        if (cacheRequestId == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullMutableLong"));
        }
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getCacheRequestId(this.getPointerValue(), cacheRequestId), "solClient_msg_getCacheRequestId");
    }

    @Override
    public int getCacheStatus() throws SolclientException {
        return ccsmp_services.getJNIMessage().solClient_msg_isCacheMsg(this.getPointerValue());
    }

    @Override
    @Deprecated
    public void setDeliverToOne(boolean dto) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setDeliverToOne(this.getPointerValue(), dto), "solClient_msg_setDeliverToOne");
    }

    @Override
    @Deprecated
    public boolean getDeliverToOne() throws SolclientException {
        return ccsmp_services.getJNIMessage().solClient_msg_isDeliverToOne(this.getPointerValue());
    }

    @Override
    public void setMessageDeliveryMode(int mode) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setDeliveryMode(this.getPointerValue(), mode), "solClient_msg_setDeliveryMode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMessageDeliveryMode() throws SolclientException {
        GenericPool.PoolEntry<MutableInteger> pe = PoolUtil.mutableIntegerPool.borrowFromPool();
        MutableInteger mi = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getDeliveryMode(this.getPointerValue(), mi), "solClient_msg_getDeliveryMode");
            int n = mi.getValue();
            return n;
        }
        finally {
            PoolUtil.mutableIntegerPool.returnToPool(pe);
        }
    }

    @Override
    public boolean getDiscardIndication() throws SolclientException {
        return ccsmp_services.getJNIMessage().solClient_msg_isDiscardIndication(this.getPointerValue());
    }

    @Override
    public void setDMQEligible(boolean dmqEligible) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setDMQEligible(this.getPointerValue(), dmqEligible), "solClient_msg_setDMQEligible");
    }

    @Override
    public boolean getDMQEligible() throws SolclientException {
        return ccsmp_services.getJNIMessage().solClient_msg_isDMQEligible(this.getPointerValue());
    }

    @Override
    public void setElidingEligible(boolean eld) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setElidingEligible(this.getPointerValue(), eld), "solClient_msg_setElidingEligible");
    }

    @Override
    public boolean getElidingEligible() throws SolclientException {
        return ccsmp_services.getJNIMessage().solClient_msg_isElidingEligible(this.getPointerValue());
    }

    @Override
    public void setExpiration(long exp) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setExpiration(this.getPointerValue(), exp), "solClient_msg_setExpiration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getExpiration() throws SolclientException {
        GenericPool.PoolEntry<MutableLong> pe = PoolUtil.mutableLongPool.borrowFromPool();
        MutableLong ml = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getExpiration(this.getPointerValue(), ml), "solClient_msg_getExpiration");
            long l = ml.getValue();
            return l;
        }
        finally {
            PoolUtil.mutableLongPool.returnToPool(pe);
        }
    }

    @Override
    public boolean isReplyMessage() throws SolclientException {
        return ccsmp_services.getJNIMessage().solClient_msg_isReplyMsg(this.getPointerValue());
    }

    @Override
    public void setAsReplyMessage(boolean asReplyMessage) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setAsReplyMsg(this.getPointerValue(), asReplyMessage), "solClient_msg_setAsReplyMsg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getReceiveTimestamp() throws SolclientException {
        GenericPool.PoolEntry<MutableLong> pe = PoolUtil.mutableLongPool.borrowFromPool();
        MutableLong ml = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getRcvTimestamp(this.getPointerValue(), ml), "solClient_msg_getRcvTimestamp");
            if (rc == 0) {
                long l = ml.getValue();
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            PoolUtil.mutableLongPool.returnToPool(pe);
        }
    }

    @Override
    public boolean isRedelivered() throws SolclientException {
        return ccsmp_services.getJNIMessage().solClient_msg_isRedelivered(this.getPointerValue());
    }

    @Override
    public void setSenderTimestamp(long senderTimeStamp) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setSenderTimestamp(this.getPointerValue(), senderTimeStamp), "solClient_msg_setSenderTimestamp");
    }

    @Override
    public void deleteSenderTimestamp() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_deleteSenderTimestamp(this.getPointerValue()), "solClient_msg_deleteSenderTimestamp");
    }

    @Override
    public int getSenderTimestamp(MutableLong senderTimerstamp) throws SolclientException {
        if (senderTimerstamp == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullMutableLong"));
        }
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getSenderTimestamp(this.getPointerValue(), senderTimerstamp), "solClient_msg_getSenderTimestamp");
    }

    @Override
    public int getSequenceNumber(MutableLong sequenceNumber) throws SolclientException {
        if (sequenceNumber == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullMutableLong"));
        }
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getSequenceNumber(this.getPointerValue(), sequenceNumber), "solClient_msg_getSequenceNumber");
    }

    @Override
    public void setSequenceNumber(long sequenceNumber) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setSequenceNumber(this.getPointerValue(), sequenceNumber), "solClient_msg_setSequenceNumber");
    }

    @Override
    public void deleteSequenceNumber() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_deleteSequenceNumber(this.getPointerValue()), "solClient_msg_deleteSequenceNumber");
    }

    @Override
    public void setTimeToLive(long ttl) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setTimeToLive(this.getPointerValue(), ttl), "solClient_msg_setTimeToLive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeToLive() throws SolclientException {
        GenericPool.PoolEntry<MutableLong> pe = PoolUtil.mutableLongPool.borrowFromPool();
        MutableLong ml = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getTimeToLive(this.getPointerValue(), ml), "solClient_msg_getTimeToLive");
            long l = ml.getValue();
            return l;
        }
        finally {
            PoolUtil.mutableLongPool.returnToPool(pe);
        }
    }

    @Override
    public void setUserCos(int userCos) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setClassOfService(this.getPointerValue(), userCos), "solClient_msg_setClassOfService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserCos() throws SolclientException {
        GenericPool.PoolEntry<MutableInteger> pe = PoolUtil.mutableIntegerPool.borrowFromPool();
        MutableInteger mi = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getClassOfService(this.getPointerValue(), mi), "solClient_msg_getClassOfService");
            int n = mi.getValue();
            return n;
        }
        finally {
            PoolUtil.mutableIntegerPool.returnToPool(pe);
        }
    }

    @Override
    public void setReplyToSuffix(SessionHandle in_sessionHandle, String replyToSuffix) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setReplyToSuffix(this.getPointerValue(), ((SessionHandleImpl)in_sessionHandle).getPointerValue(), replyToSuffix), "solClient_msg_setReplyToSuffix");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDestinationTopicSuffix(SessionHandle in_sessionHandle) throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getDestinationTopicSuffix(this.getPointerValue(), ((SessionHandleImpl)in_sessionHandle).getPointerValue(), sb), "solClient_msg_getDestinationTopicSuffix");
            if (rc == 0) {
                String string = sb.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    @Override
    public void setUserData(ByteBuffer userDataBuffer) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setUserData(this.getPointerValue(), userDataBuffer), "solClient_msg_setUserData_ByteBuffer");
    }

    @Override
    public void setUserData(byte[] userData) throws SolclientException {
        this.setUserData(userData, 0, userData == null ? 0 : userData.length);
    }

    @Override
    public void setUserData(byte[] userData, int offset, int length) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setUserData(this.getPointerValue(), userData, offset, length), "solClient_msg_setUserData_byteArray");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserData(ByteBuffer userDataBuffer) throws SolclientException {
        if (userDataBuffer == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullUserData"));
        }
        GenericPool.PoolEntry<MutableInteger> pe = PoolUtil.mutableIntegerPool.borrowFromPool();
        MutableInteger mi = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getUserData(this.getPointerValue(), userDataBuffer, mi), "solClient_msg_getUserData_ByteBuffer");
            if (rc != 0) {
                int n = 0;
                return n;
            }
            int n = mi.getValue();
            return n;
        }
        finally {
            mi.setValue(0);
            PoolUtil.mutableIntegerPool.returnToPool(pe);
        }
    }

    @Override
    public void deleteSenderId() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_deleteSenderId(this.getPointerValue()), "solClient_msg_deleteSenderId");
    }

    @Override
    public void setSenderId(String senderId) throws SolclientException {
        if (senderId == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullUseDeleteInstead"));
        }
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setSenderId(this.getPointerValue(), senderId), "solClient_msg_setSenderId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSenderId() throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getSenderId(this.getPointerValue(), sb), "solClient_msg_getSenderId");
            if (rc == 0) {
                String string = sb.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getApplicationMessageId() throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getApplicationMessageId(this.getPointerValue(), sb), "solClient_msg_getApplicationMessageId");
            if (rc == 0) {
                String string = sb.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    @Override
    public void setApplicationMessageId(String appMsgId) throws SolclientException {
        if (appMsgId == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullUseDeleteInstead"));
        }
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setApplicationMessageId(this.getPointerValue(), appMsgId), "solClient_msg_setApplicationMessageId");
    }

    @Override
    public void deleteApplicationMessageId() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_deleteApplicationMessageId(this.getPointerValue()), "solClient_msg_deleteApplicationMessageId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getApplicationMessageType() throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getApplicationMsgType(this.getPointerValue(), sb), "solClient_msg_getApplicationMsgType");
            if (rc == 0) {
                String string = sb.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    @Override
    public void setApplicationMessageType(String appMsgType) throws SolclientException {
        if (appMsgType == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullUseDeleteInstead"));
        }
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setApplicationMsgType(this.getPointerValue(), appMsgType), "solClient_msg_setApplicationMsgType");
    }

    @Override
    public void deleteApplicationMessageType() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_deleteApplicationMsgType(this.getPointerValue()), "solClient_msg_deleteApplicationMsgType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination getReplyTo() throws SolclientException {
        GenericPool.PoolEntry<DestinationStruct> pe = PoolUtil.destinationStructPool.borrowFromPool();
        DestinationStruct ds = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getReplyTo(this.getPointerValue(), ds), "solClient_msg_getReplyTo_DestinationStruct");
            if (rc == 0) {
                Destination destination = ConceptConvertUtil.getDestination(ds);
                return destination;
            }
            Destination destination = null;
            return destination;
        }
        finally {
            PoolUtil.destinationStructPool.returnToPool(pe);
        }
    }

    @Override
    public MutableTopic getReplyTo(MutableTopic mutableTopic) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getReplyTo(this.getPointerValue(), mutableTopic.getNameBuffer()), "solClient_msg_getReplyTo_ByteBuffer");
        return mutableTopic;
    }

    @Override
    public void setReplyTo(Destination destination) throws SolclientException {
        if (destination == null) {
            ccsmp_services.getJNIMessage().solClient_msg_deleteReplyTo(this.getPointerValue());
            return;
        }
        if (destination instanceof NativeDestinationHandle) {
            NativeDestinationHandleImpl nativeDestinationHandleImpl = (NativeDestinationHandleImpl)destination;
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setReplyTo(this.getPointerValue(), nativeDestinationHandleImpl.getPointerValue()), "solClient_msg_setReplyTo_long");
        } else if (destination instanceof MutableTopic) {
            MutableTopicImpl mutableTopic = (MutableTopicImpl)destination;
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setReplyTo(this.getPointerValue(), mutableTopic.getNameBuffer(), ConceptConvertUtil.getDestinationType(destination)), "solClient_msg_setReplyTo_ByteBuffer");
        } else {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setReplyTo(this.getPointerValue(), destination.getName(), ConceptConvertUtil.getDestinationType(destination)), "solClient_msg_setReplyTo_String");
        }
    }

    @Override
    public void setAckImmediately(boolean ackImmediately) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setAckImmediately(this.getPointerValue(), ackImmediately), "solClient_msg_setAckImmediately");
    }

    @Override
    public boolean getAckImmediately() throws SolclientException {
        return ccsmp_services.getJNIMessage().solClient_msg_isAckImmediately(this.getPointerValue());
    }

    @Override
    public void destroy() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_free(this.getPointerValue()), "solClient_msg_free");
        this.setPointerValue(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBinaryAttachmentSize() throws SolclientException {
        GenericPool.PoolEntry<MutableInteger> pe = PoolUtil.mutableIntegerPool.borrowFromPool();
        MutableInteger mi = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getBinaryAttachmentSize(this.getPointerValue(), mi), "solClient_msg_getBinaryAttachmentSize");
            if (rc != 0) {
                int n = 0;
                return n;
            }
            int n = mi.getValue();
            return n;
        }
        finally {
            PoolUtil.mutableIntegerPool.returnToPool(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHttpContentType() throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getHttpContentType(this.getPointerValue(), sb), "solClient_msg_getHttpContentType");
            if (rc == 0) {
                String string = sb.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    @Override
    public void setHttpContentType(String contentType) throws SolclientException {
        if (contentType == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullUseDeleteInstead"));
        }
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setHttpContentType(this.getPointerValue(), contentType), "solClient_msg_setHttpContentType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHttpContentEncoding() throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getHttpContentEncoding(this.getPointerValue(), sb), "solClient_msg_getHttpContentEncoding");
            if (rc == 0) {
                String string = sb.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    @Override
    public void setHttpContentEncoding(String contentEncoding) throws SolclientException {
        if (contentEncoding == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullUseDeleteInstead"));
        }
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setHttpContentEncoding(this.getPointerValue(), contentEncoding), "solClient_msg_setHttpContentEncoding");
    }

    @Override
    public void deleteHttpContentType() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_deleteHttpContentType(this.getPointerValue()), "solClient_msg_deleteHttpContentType");
    }

    @Override
    public void deleteHttpContentEncoding() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_deleteHttpContentEncoding(this.getPointerValue()), "solClient_msg_deleteHttpContentEncoding");
    }

    @Override
    public void setPriority(int priority) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_setPriority(this.getPointerValue(), priority), "solClient_msg_setPriority");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPriority() throws SolclientException {
        GenericPool.PoolEntry<MutableInteger> pe = PoolUtil.mutableIntegerPool.borrowFromPool();
        MutableInteger mi = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getPriority(this.getPointerValue(), mi), "solClient_msg_getPriority");
            int n = mi.getValue();
            return n;
        }
        finally {
            PoolUtil.mutableIntegerPool.returnToPool(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDeliveryCount() throws SolclientException {
        GenericPool.PoolEntry<MutableInteger> pe = PoolUtil.mutableIntegerPool.borrowFromPool();
        MutableInteger mi = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getDeliveryCount(this.getPointerValue(), mi), "solClient_msg_getDeliveryCount");
            int n = mi.getValue();
            return n;
        }
        finally {
            PoolUtil.mutableIntegerPool.returnToPool(pe);
        }
    }

    @Override
    public int getReplicationGroupMessageIdForHandle(ReplicationGroupMessageIdHandle in_out_ReplicationGroupMessageIdHandle) {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNIMessage().solClient_msg_getReplicationGroupMessageId(this.getPointerValue(), (ReplicationGroupMessageIdHandleImpl)in_out_ReplicationGroupMessageIdHandle), "solClient_msg_getReplicationGroupMessageId");
    }
}

