/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.SolclientException;
import com.solacesystems.solclientj.core.handle.MutableInteger;
import com.solacesystems.solclientj.core.handle.ReplicationGroupMessageIdHandle;
import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.AbstractBaseHandleImpl;
import com.solacesystems.solclientj.core.impl.ccsmp.JNIContext;
import com.solacesystems.solclientj.core.impl.util.ExceptionGuard;
import com.solacesystems.solclientj.core.impl.util.GenericPool;
import com.solacesystems.solclientj.core.impl.util.PoolUtil;

public class ReplicationGroupMessageIdHandleImpl
extends AbstractBaseHandleImpl
implements ReplicationGroupMessageIdHandle {
    private static final JNIContext jni_context = JNIContext.onlyInstance();

    public ReplicationGroupMessageIdHandleImpl() {
    }

    public ReplicationGroupMessageIdHandleImpl(long value) {
        super(value);
    }

    @Override
    public String toString() {
        if (this.isBound()) {
            String rgmidStr;
            try {
                rgmidStr = jni_context.solClient_replicationGroupMessageId_toString(this.getPointerValue());
            }
            catch (NullPointerException npe) {
                return "invalid";
            }
            return rgmidStr;
        }
        return "invalid";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(ReplicationGroupMessageIdHandle otherReplicationGroupMessageIdHandle) {
        GenericPool.PoolEntry<MutableInteger> pe = PoolUtil.mutableIntegerPool.borrowFromPool();
        MutableInteger mi = pe.getEntry();
        ExceptionGuard.assertUsableBoundHandle("solClient_replicationGroupMessageId_compare", otherReplicationGroupMessageIdHandle, "Common.NullReplicationGroupMessageIdHandle");
        if (!(otherReplicationGroupMessageIdHandle instanceof ReplicationGroupMessageIdHandleImpl)) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.InvalidReplicationGroupMessageIdImpl"));
        }
        long otherReplicationGroupMessageIdPointer = ((ReplicationGroupMessageIdHandleImpl)otherReplicationGroupMessageIdHandle).getPointerValue();
        try {
            int rc = ExceptionGuard.assertReturnCode(jni_context.solClient_replicationGroupMessageId_compare(this.getPointerValue(), otherReplicationGroupMessageIdPointer, mi), "solClient_replicationGroupMessageId_compare");
            if (rc != 0) {
                int n = 0;
                return n;
            }
            int n = mi.getValue();
            return n;
        }
        finally {
            PoolUtil.mutableIntegerPool.returnToPool(pe);
        }
    }

    @Override
    public boolean isValid() {
        boolean isValid;
        try {
            isValid = jni_context.solClient_replicationGroupMessageId_isValid(this.getPointerValue());
        }
        catch (NullPointerException npe) {
            return false;
        }
        return isValid;
    }

    @Override
    public void destroy() throws SolclientException {
        ExceptionGuard.assertReturnCode(jni_context.solClient_replicationGroupMessageId_destroy(this.getPointerValue()), "solClient_replicationGroupMessageId_destroy");
        this.setPointerValue(0L);
    }
}

