/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.solclientj.core.impl;

import com.solacesystems.solclientj.core.Solclient;
import com.solacesystems.solclientj.core.SolclientException;
import com.solacesystems.solclientj.core.event.CacheSessionEventCallback;
import com.solacesystems.solclientj.core.event.FlowEventCallback;
import com.solacesystems.solclientj.core.event.MessageCallback;
import com.solacesystems.solclientj.core.event.SessionEvent;
import com.solacesystems.solclientj.core.event.SessionEventCallback;
import com.solacesystems.solclientj.core.handle.CacheSessionHandle;
import com.solacesystems.solclientj.core.handle.FlowHandle;
import com.solacesystems.solclientj.core.handle.MessageDispatchTargetHandle;
import com.solacesystems.solclientj.core.handle.MessageHandle;
import com.solacesystems.solclientj.core.handle.MutableInteger;
import com.solacesystems.solclientj.core.handle.MutableMessageDispatchTargetHandle;
import com.solacesystems.solclientj.core.handle.SessionHandle;
import com.solacesystems.solclientj.core.handle.TransactedSessionHandle;
import com.solacesystems.solclientj.core.i18n.SOLCLIENTJRB;
import com.solacesystems.solclientj.core.impl.AbstractMessageSupportBaseHandleImpl;
import com.solacesystems.solclientj.core.impl.CacheSessionHandleImpl;
import com.solacesystems.solclientj.core.impl.CapabilityImpl;
import com.solacesystems.solclientj.core.impl.ConceptConvertUtil;
import com.solacesystems.solclientj.core.impl.FlowHandleImpl;
import com.solacesystems.solclientj.core.impl.MessageDispatchTargetHandleImpl;
import com.solacesystems.solclientj.core.impl.MessageHandleImpl;
import com.solacesystems.solclientj.core.impl.MutableMessageDispatchTargetHandleImpl;
import com.solacesystems.solclientj.core.impl.QueueImpl;
import com.solacesystems.solclientj.core.impl.SessionEventImpl;
import com.solacesystems.solclientj.core.impl.TopicEndpointImpl;
import com.solacesystems.solclientj.core.impl.TopicImpl;
import com.solacesystems.solclientj.core.impl.TransactedSessionHandleImpl;
import com.solacesystems.solclientj.core.impl.ccsmp.CCSMPServices;
import com.solacesystems.solclientj.core.impl.util.ExceptionGuard;
import com.solacesystems.solclientj.core.impl.util.GenericPool;
import com.solacesystems.solclientj.core.impl.util.PoolUtil;
import com.solacesystems.solclientj.core.impl.util.SolLogger;
import com.solacesystems.solclientj.core.resource.ClientName;
import com.solacesystems.solclientj.core.resource.Endpoint;
import com.solacesystems.solclientj.core.resource.MutableTopic;
import com.solacesystems.solclientj.core.resource.Queue;
import com.solacesystems.solclientj.core.resource.Subscription;
import com.solacesystems.solclientj.core.resource.Topic;
import com.solacesystems.solclientj.core.resource.TopicEndpoint;
import java.nio.ByteBuffer;

public final class SessionHandleImpl
extends AbstractMessageSupportBaseHandleImpl
implements SessionHandle {
    private static final CCSMPServices ccsmp_services = CCSMPServices.onlyInstance();
    private static final SolLogger LOGGER = SolLogger.getLogger(SessionHandleImpl.class.getName());
    private SessionEventCallback sessionEventCallback;
    private SessionEventImpl lastSessionEvent;
    private ClientName m_ClientName = null;

    public SessionHandleImpl() {
    }

    public SessionHandleImpl(int value) {
        super(value);
    }

    @Override
    public SessionEvent getSessionEvent() {
        return this.lastSessionEvent;
    }

    @Override
    public void takeSessionEvent(SessionEvent sessionEvent, boolean withInfoString) {
        if (sessionEvent == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullSessionEvent"));
        }
        if (!(sessionEvent instanceof SessionEventImpl)) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.InvalidSessionEventImpl"));
        }
        SessionEventImpl sessionEventImpl = (SessionEventImpl)sessionEvent;
        sessionEventImpl.copy(this.lastSessionEvent, withInfoString);
    }

    public void onEvent(int responseCode, int sessionEventEnum, long correlationKey) {
        if (this.sessionEventCallback == null) {
            LOGGER.error("SessionHandle.onEvent:" + SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullSessionEventCallback"));
        }
        if (this.lastSessionEvent == null) {
            this.lastSessionEvent = new SessionEventImpl(responseCode, correlationKey, sessionEventEnum);
        } else {
            this.lastSessionEvent.reset();
            this.lastSessionEvent.setResponseCode(responseCode);
            this.lastSessionEvent.setCorrelationKey(correlationKey);
            this.lastSessionEvent.setSessionEventCode(sessionEventEnum);
        }
        if (this.sessionEventCallback != null) {
            this.sessionEventCallback.onEvent(this);
        }
    }

    protected void registerSessionEventCallback(SessionEventCallback sessionEvtCallback) {
        if (sessionEvtCallback == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullSessionEventCallback"));
        }
        this.sessionEventCallback = sessionEvtCallback;
    }

    @Override
    public int clearStats() throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_clearStats(this.getPointerValue()), "solClient_session_clearStats");
    }

    @Override
    public int connect() throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_connect(this.getPointerValue()), "solClient_session_connect");
    }

    @Override
    public TopicEndpoint createNonDurableTopicEndpoint() throws SolclientException {
        return new TopicEndpointImpl(null, false, null);
    }

    @Override
    public TopicEndpoint createNonDurableTopicEndpoint(String[] endpointProperties) throws SolclientException {
        return new TopicEndpointImpl(null, false, endpointProperties);
    }

    @Override
    public TopicEndpoint createNonDurableTopicEndpoint(String name) throws SolclientException {
        return this.createNonDurableTopicEndpoint(name, null);
    }

    @Override
    public TopicEndpoint createNonDurableTopicEndpoint(String name, String[] endpointProperties) throws SolclientException {
        if (name == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullEndpointName"));
        }
        if (name.trim().equals("")) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.WhitespaceEndpointName"));
        }
        return new TopicEndpointImpl(name, false, endpointProperties);
    }

    @Override
    public Queue createTemporaryQueue() throws SolclientException {
        return new QueueImpl(null, false, null);
    }

    @Override
    public Queue createTemporaryQueue(String[] endpointProperties) throws SolclientException {
        return new QueueImpl(null, false, endpointProperties);
    }

    @Override
    public Queue createTemporaryQueue(String in_queueName) throws SolclientException {
        return this.createTemporaryQueue(in_queueName, null);
    }

    @Override
    public Queue createTemporaryQueue(String in_queueName, String[] endpointProperties) throws SolclientException {
        if (in_queueName == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullEndpointName"));
        }
        if (in_queueName.trim().equals("")) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.WhitespaceEndpointName"));
        }
        return new QueueImpl(in_queueName, false, endpointProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Topic createTemporaryTopic() throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            TopicImpl tempTopic;
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_createTemporaryTopicName(this.getPointerValue(), sb), "solClient_session_createTemporaryTopicName");
            TopicImpl topicImpl = tempTopic = new TopicImpl(sb.toString(), true);
            return topicImpl;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    @Override
    public void getTxStats(long[] in_out_txStats) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_getTxStats(this.getPointerValue(), in_out_txStats), "solClient_session_getTxStats");
    }

    @Override
    public void getRxStats(long[] in_out_rxStats) throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_getRxStats(this.getPointerValue(), in_out_rxStats), "solClient_session_getRxStats");
    }

    @Override
    public int createTransactedSessionForHandle(TransactedSessionHandle in_out_txSession, String[] properties) throws SolclientException {
        ExceptionGuard.assertUsableUnboundHandle("createTransactedSessionForHandle", in_out_txSession, "Common.NullTransactedSessionHandle");
        int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_createTransactedSession(this.getPointerValue(), properties, in_out_txSession), "solClient_session_createTransactedSession");
        ((TransactedSessionHandleImpl)in_out_txSession).registerSessionHandle(this);
        return rc;
    }

    @Override
    public int deprovision(Endpoint endpoint, int deprovisionFlags, long correlationKey) throws SolclientException {
        if (endpoint == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullEndpoint"));
        }
        String[] endpointProperties = ConceptConvertUtil.computeEndPointProperties(endpoint);
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_endpointDeprovision(this.getPointerValue(), endpointProperties, deprovisionFlags, correlationKey), "solClient_session_endpointDeprovision");
    }

    @Override
    public int provision(Endpoint endpoint, int provisionFlags, long correlationKey) throws SolclientException {
        if (endpoint == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullEndpoint"));
        }
        if (!endpoint.isDurable()) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.DurableEndpointRequired"));
        }
        String[] jniEndpointProperties = ConceptConvertUtil.computeEndPointProperties(endpoint);
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_endpointProvision(this.getPointerValue(), jniEndpointProperties, provisionFlags, correlationKey), "solClient_session_endpointProvision");
    }

    @Override
    public int disconnect() throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_disconnect(this.getPointerValue()), "solClient_session_disconnect");
    }

    @Override
    public Object getCapability(String capabilityName) throws SolclientException {
        if (capabilityName == null) {
            return null;
        }
        GenericPool.PoolEntry<CapabilityImpl> pe = PoolUtil.capabilityImplPool.borrowFromPool();
        CapabilityImpl in_out_capability = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_getCapability(this.getPointerValue(), capabilityName, in_out_capability), "solClient_session_getCapability");
            int capabilityType = in_out_capability.getType();
            switch (capabilityType) {
                case 10: {
                    String string = in_out_capability.getString();
                    return string;
                }
                case 0: {
                    Boolean bl = in_out_capability.getBooleanValue();
                    return bl;
                }
                case 5: 
                case 6: {
                    Integer n = in_out_capability.getIntValue();
                    return n;
                }
                case 7: 
                case 8: {
                    Long l = in_out_capability.getLongValue();
                    return l;
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to translate Capability Type [");
            sb.append(in_out_capability.getType());
            sb.append("] length [");
            sb.append(in_out_capability.getLength());
            sb.append("]");
            LOGGER.critical(sb.toString());
            throw new IllegalArgumentException(sb.toString());
        }
        finally {
            in_out_capability.reset();
            PoolUtil.capabilityImplPool.returnToPool(pe);
        }
    }

    @Override
    public boolean isCapable(String capabilityName) throws SolclientException {
        return ccsmp_services.getJNISession().solClient_session_isCapable(this.getPointerValue(), capabilityName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(String propertyName) throws SolclientException {
        GenericPool.PoolEntry<StringBuffer> pe = PoolUtil.stringBufferPool.borrowFromPool();
        StringBuffer sb = pe.getEntry();
        try {
            ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_getProperty(this.getPointerValue(), propertyName, sb), "solClient_session_getProperty");
            String string = sb.toString();
            return string;
        }
        finally {
            sb.setLength(0);
            PoolUtil.stringBufferPool.returnToPool(pe);
        }
    }

    @Override
    public int modifyProperties(String[] sessionPropertyNameValuePairs) throws SolclientException {
        int ret = ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_modifyProperties(this.getPointerValue(), sessionPropertyNameValuePairs), "solClient_session_modifyProperties");
        return ret;
    }

    @Override
    public int modifyClientInfo(String[] sessionPropertyNameValuePairs, int flags, long correlationKey) throws SolclientException {
        int ret = ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_modifyClientInfo(this.getPointerValue(), sessionPropertyNameValuePairs, flags, correlationKey), "solClient_session_modifyClientInfo");
        return ret;
    }

    @Override
    public int send(MessageHandle in_msgHandle) throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_sendMsg(this.getPointerValue(), ((MessageHandleImpl)in_msgHandle).getPointerValue()), "solClient_session_sendMsg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int send(MessageHandle[] in_messageHandles, int offset, int length, MutableInteger in_out_HowManySent) throws SolclientException {
        if (in_messageHandles == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("SessionHandle.SendMultipleNullArray"));
        }
        if (length == 0) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("SessionHandle.SendMultipleBadLengthZero"));
        }
        if (offset + length > in_messageHandles.length) {
            if (offset > in_messageHandles.length) {
                throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("SessionHandle.SendMultipleBadOffset"));
            }
            if (length > in_messageHandles.length) {
                throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("SessionHandle.SendMultipleBadLength"));
            }
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("SessionHandle.SendMultipleLengthAndOffset"));
        }
        if (in_out_HowManySent == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullMutableInteger"));
        }
        int batchSize = 50;
        int batches = length / batchSize;
        int remainder = length % batchSize;
        GenericPool.PoolEntry<MutableInteger> pe = PoolUtil.mutableIntegerPool.borrowFromPool();
        MutableInteger batchCount = pe.getEntry();
        try {
            int rc = 0;
            int totalSent = 0;
            for (int b = 0; b < batches; ++b) {
                try {
                    rc = this.sendMultipleBatch(in_messageHandles, offset + b * batchSize, batchSize, batchCount);
                    totalSent += batchCount.getValue();
                    continue;
                }
                catch (SolclientException sce) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("send failed at offset [");
                    sb.append(offset);
                    sb.append("] batch [");
                    sb.append(b);
                    sb.append("] calculated offset [");
                    sb.append(offset + b * batchSize);
                    sb.append("] batchSize [");
                    sb.append(batchSize);
                    sb.append("] ");
                    throw new SolclientException(sb.toString(), sce.getSolclientErrorInfo(), sce.getReturnCode());
                }
            }
            if (remainder > 0) {
                try {
                    rc = this.sendMultipleBatch(in_messageHandles, offset + batchSize * batches, remainder, batchCount);
                    totalSent += batchCount.getValue();
                }
                catch (SolclientException sce) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("send failed at offset [");
                    sb.append(offset);
                    sb.append("] remainder [");
                    sb.append(remainder);
                    sb.append("] calculated offset [");
                    sb.append(offset + batchSize * batches);
                    sb.append("] ");
                    throw new SolclientException(sb.toString(), sce.getSolclientErrorInfo(), sce.getReturnCode());
                }
            }
            in_out_HowManySent.setValue(totalSent);
            int n = rc;
            return n;
        }
        finally {
            PoolUtil.mutableIntegerPool.returnToPool(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendMultipleBatch(MessageHandle[] in_messageHandles, int offset, int length, MutableInteger in_out_HowManySent) {
        int n;
        if (in_messageHandles == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("SessionHandle.SendMultipleNullArray"));
        }
        if (length == 0) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("SessionHandle.SendMultipleBadLengthZero"));
        }
        if (offset + length > in_messageHandles.length) {
            if (offset > in_messageHandles.length) {
                throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("SessionHandle.SendMultipleBadOffset"));
            }
            if (length > in_messageHandles.length) {
                throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("SessionHandle.SendMultipleBadLength"));
            }
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("SessionHandle.SendMultipleLengthAndOffset"));
        }
        if (in_out_HowManySent == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullMutableInteger"));
        }
        if (length > 50) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("SessionHandle.SendMultipleLimit"));
        }
        in_out_HowManySent.setValue(length);
        GenericPool.PoolEntry<long[]> lpe = PoolUtil.longArray50Pool.borrowFromPool();
        long[] msgPointers = lpe.getEntry();
        try {
            int arrayPosition = 0;
            for (int i = 0; i < msgPointers.length; ++i) {
                arrayPosition = i + offset;
                msgPointers[i] = arrayPosition >= in_messageHandles.length || in_messageHandles[arrayPosition] == null ? 0L : ((MessageHandleImpl)in_messageHandles[arrayPosition]).getPointerValue();
            }
            n = ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_sendMultipleMsg(this.getPointerValue(), msgPointers, in_out_HowManySent), "solClient_session_sendMultipleMsg");
        }
        catch (Throwable throwable) {
            for (int i = 0; i < msgPointers.length; ++i) {
                msgPointers[i] = 0L;
            }
            PoolUtil.longArray50Pool.returnToPool(lpe);
            throw throwable;
        }
        for (int i = 0; i < msgPointers.length; ++i) {
            msgPointers[i] = 0L;
        }
        PoolUtil.longArray50Pool.returnToPool(lpe);
        return n;
    }

    @Override
    public int sendRequest(MessageHandle in_requestMsgHandle, MessageHandle in_out_replyMsgeHandle, int timeoutInMsecs) throws SolclientException {
        ExceptionGuard.assertUsableBoundHandle("sendRequest", in_requestMsgHandle, "Common.NullMessageHandle");
        MessageHandleImpl in_requestMsgHandleImpl = (MessageHandleImpl)in_requestMsgHandle;
        MessageHandleImpl in_out_replyMsgeHandleImpl = (MessageHandleImpl)in_out_replyMsgeHandle;
        ExceptionGuard.assertUsableUnboundHandle("sendRequest", in_out_replyMsgeHandleImpl, "Common.NullMessageHandle");
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_sendRequest(this.getPointerValue(), in_requestMsgHandleImpl.getPointerValue(), in_out_replyMsgeHandleImpl, timeoutInMsecs), "solClient_session_sendRequest");
    }

    @Override
    public int sendReply(MessageHandle in_msgToReplyTo, MessageHandle in_replyMsg) throws SolclientException {
        ExceptionGuard.assertUsableBoundHandle("sendReply", in_msgToReplyTo, "Common.NullMessageHandle");
        ExceptionGuard.assertUsableBoundHandle("sendReply", in_replyMsg, "Common.NullMessageHandle");
        MessageHandleImpl in_msgToReplyToImpl = (MessageHandleImpl)in_msgToReplyTo;
        MessageHandleImpl in_replyMsgImpl = (MessageHandleImpl)in_replyMsg;
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_sendReply(this.getPointerValue(), in_msgToReplyToImpl.getPointerValue(), in_replyMsgImpl.getPointerValue()), "solClient_session_sendReply");
    }

    @Override
    public int subscribe(Subscription subscription, int subscribeFlags, long correlationKey) throws SolclientException {
        if (subscription instanceof MutableTopic) {
            ByteBuffer topicNameBuffer = this.getTopicNameBuffer(subscription);
            return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_topicSubscribeWithDispatch(this.getPointerValue(), subscribeFlags, topicNameBuffer, null, correlationKey, false), "solClient_session_topicSubscribeWithDispatch_MutableTopic");
        }
        String topicName = this.getTopicName(subscription);
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_topicSubscribeWithDispatch(this.getPointerValue(), subscribeFlags, topicName, null, correlationKey), "solClient_session_topicSubscribeWithDispatch");
    }

    @Override
    public int subscribe(ByteBuffer subscription, int subscribeFlags, long correlationKey) throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_topicSubscribeWithDispatch(this.getPointerValue(), subscribeFlags, subscription, null, correlationKey, true), "solClient_session_topicSubscribeWithDispatch_ByteBuffer");
    }

    @Override
    public int unsubscribe(Subscription subscription, int flags, long correlationKey) throws SolclientException {
        if (subscription instanceof MutableTopic) {
            ByteBuffer topicNameBuffer = this.getTopicNameBuffer(subscription);
            return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_topicUnsubscribeWithDispatch(this.getPointerValue(), flags, topicNameBuffer, null, correlationKey, false), "solClient_session_topicUnsubscribeWithDispatch_MutableTopic");
        }
        String topicName = this.getTopicName(subscription);
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_topicUnsubscribeWithDispatch(this.getPointerValue(), flags, topicName, null, correlationKey), "solClient_session_topicUnsubscribeWithDispatch");
    }

    @Override
    public int unsubscribe(ByteBuffer subscription, int flags, long correlationKey) throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_topicUnsubscribeWithDispatch(this.getPointerValue(), flags, subscription, null, correlationKey, true), "solClient_session_topicUnsubscribeWithDispatch_ByteBuffer");
    }

    @Override
    public int subscribe(Endpoint endpoint, Subscription subscription, int flags, long correlationKey) throws SolclientException {
        String[] endpointProperties = ConceptConvertUtil.computeEndPointProperties(endpoint);
        if (subscription instanceof MutableTopic) {
            ByteBuffer topicNameBuffer = this.getTopicNameBuffer(subscription);
            return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_endpointTopicSubscribe(this.getPointerValue(), endpointProperties, flags, topicNameBuffer, correlationKey, false), "solClient_session_endpointTopicSubscribe_MutableTopic");
        }
        String topicSubscription = this.getTopicName(subscription);
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_endpointTopicSubscribe(this.getPointerValue(), endpointProperties, flags, topicSubscription, correlationKey), "solClient_session_endpointTopicSubscribe");
    }

    @Override
    public int subscribe(Endpoint endpoint, ByteBuffer subscription, int flags, long correlationKey) throws SolclientException {
        String[] endpointProperties = ConceptConvertUtil.computeEndPointProperties(endpoint);
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_endpointTopicSubscribe(this.getPointerValue(), endpointProperties, flags, subscription, correlationKey, true), "solClient_session_endpointTopicSubscribe_ByteBuffer");
    }

    @Override
    public int unsubscribe(Endpoint endpoint, Subscription subscription, int flags, long correlationKey) throws SolclientException {
        String[] endpointProperties = ConceptConvertUtil.computeEndPointProperties(endpoint);
        if (subscription instanceof MutableTopic) {
            ByteBuffer topicNameBuffer = this.getTopicNameBuffer(subscription);
            return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_endpointTopicUnsubscribe(this.getPointerValue(), endpointProperties, flags, topicNameBuffer, correlationKey, false), "solClient_session_endpointTopicUnsubscribe_MutableTopic");
        }
        String topicSubscription = this.getTopicName(subscription);
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_endpointTopicUnsubscribe(this.getPointerValue(), endpointProperties, flags, topicSubscription, correlationKey), "solClient_session_endpointTopicUnsubscribe");
    }

    @Override
    public int unsubscribe(Endpoint endpoint, ByteBuffer subscription, int flags, long correlationKey) throws SolclientException {
        String[] endpointProperties = ConceptConvertUtil.computeEndPointProperties(endpoint);
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_endpointTopicUnsubscribe(this.getPointerValue(), endpointProperties, flags, subscription, correlationKey, true), "solClient_session_endpointTopicUnsubscribe_ByteBuffer");
    }

    @Override
    public int unsubscribe(TopicEndpoint topicEndpoint, long correlationKey) throws SolclientException {
        if (topicEndpoint == null) {
            throw new IllegalArgumentException(SOLCLIENTJRB.BUNDLE.getStringSafely("Common.NullEndpoint"));
        }
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_dteUnsubscribe(this.getPointerValue(), topicEndpoint.getName(), correlationKey), "solClient_session_dteUnsubscribe");
    }

    @Override
    public int validateTopic(String topicName) throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_validateTopic(this.getPointerValue(), topicName), "solClient_session_validateTopic_String");
    }

    @Override
    public int validateTopic(ByteBuffer topicNameBuffer) throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_validateTopic(this.getPointerValue(), topicNameBuffer), "solClient_session_validateTopic_ByteBuffer");
    }

    @Override
    public int subscribeOnBehalfOfClient(ByteBuffer clientname, ByteBuffer topic, int flags, long correlationKey) throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_endpointTopicSubscribe(this.getPointerValue(), clientname, flags, topic, correlationKey), "solClient_session_endpointTopicSubscribe_ByteBuffer_Client");
    }

    @Override
    public int unsubscribeOnBehalfOfClient(ByteBuffer clientname, ByteBuffer topic, int flags, long correlationKey) throws SolclientException {
        return ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_endpointTopicUnsubscribe(this.getPointerValue(), clientname, flags, topic, correlationKey), "solClient_session_endpointTopicUnsubscribe_ByteBuffer_Client");
    }

    @Override
    public int subscribe(MessageDispatchTargetHandle in_out_msgDispatchTargetHandle, int flags, long correlationKey) throws SolclientException {
        ExceptionGuard.assertUsableUnboundHandle("subscribe", in_out_msgDispatchTargetHandle, "Common.NullMessageDispatchTargetHandle");
        MessageDispatchTargetHandleImpl mdthImpl = (MessageDispatchTargetHandleImpl)in_out_msgDispatchTargetHandle;
        if (mdthImpl.isLocalDispatchOnly()) {
            flags |= 8;
        }
        Subscription subscription = in_out_msgDispatchTargetHandle.getSubscription();
        String topicSubscription = this.getTopicName(subscription);
        int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_topicSubscribeWithDispatch(this.getPointerValue(), flags, topicSubscription, mdthImpl, correlationKey), "solClient_session_topicSubscribeWithDispatch");
        mdthImpl.registerMessageDispatcher(this);
        return rc;
    }

    @Override
    public int unsubscribe(MessageDispatchTargetHandle in_out_msgDispatchTargetHandle, int flags, long correlationKey) throws SolclientException {
        ExceptionGuard.assertUsableBoundHandle("unsubscribe", in_out_msgDispatchTargetHandle, "Common.NullMessageDispatchTargetHandle");
        MessageDispatchTargetHandleImpl mdthImpl = (MessageDispatchTargetHandleImpl)in_out_msgDispatchTargetHandle;
        if (mdthImpl.isLocalDispatchOnly()) {
            flags |= 8;
        }
        Subscription subscription = in_out_msgDispatchTargetHandle.getSubscription();
        String topicSubscription = this.getTopicName(subscription);
        int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_topicUnsubscribeWithDispatch(this.getPointerValue(), flags, topicSubscription, mdthImpl, correlationKey), "solClient_session_topicUnsubscribeWithDispatch");
        mdthImpl.registerMessageDispatcher(null);
        return rc;
    }

    @Override
    public int subscribe(MutableMessageDispatchTargetHandle in_out_mutableMessageDispatchTargetHandle, MutableTopic subscription, MessageCallback messagecallback, boolean isLocalDispatchOnly, int flags, long correlationKey) throws SolclientException {
        ExceptionGuard.assertUsableUnboundHandle("subscribe", in_out_mutableMessageDispatchTargetHandle, "Common.NullMutableMessageDispatchTargetHandle");
        MutableMessageDispatchTargetHandleImpl mmdthImpl = (MutableMessageDispatchTargetHandleImpl)in_out_mutableMessageDispatchTargetHandle;
        mmdthImpl.registerMutableTopic(subscription);
        mmdthImpl.setLocalDispatchOnly(isLocalDispatchOnly);
        mmdthImpl.registerMessageCallback(messagecallback);
        if (mmdthImpl.isLocalDispatchOnly()) {
            flags |= 8;
        }
        ByteBuffer mutableTopicBuffer = this.getTopicNameBuffer(subscription);
        int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_topicSubscribeWithDispatch(this.getPointerValue(), flags, mutableTopicBuffer, mmdthImpl, correlationKey), "solClient_session_topicSubscribeWithDispatch_MutableTopic");
        mmdthImpl.registerMessageDispatcher(this);
        return rc;
    }

    @Override
    public int unsubscribe(MutableMessageDispatchTargetHandle in_out_mutableMessageDispatchTargetHandle, int flags, long correlationKey) throws SolclientException {
        ExceptionGuard.assertUsableBoundHandle("unsubscribe", in_out_mutableMessageDispatchTargetHandle, "Common.NullMutableMessageDispatchTargetHandle");
        MutableMessageDispatchTargetHandleImpl mmdthImpl = (MutableMessageDispatchTargetHandleImpl)in_out_mutableMessageDispatchTargetHandle;
        if (mmdthImpl.isLocalDispatchOnly()) {
            flags |= 8;
        }
        ByteBuffer topicSubscription = this.getTopicNameBuffer(mmdthImpl.getMutableTopic());
        int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_topicUnsubscribeWithDispatch(this.getPointerValue(), flags, topicSubscription, mmdthImpl, correlationKey), "solClient_session_topicUnsubscribeWithDispatch_MutableTopic");
        mmdthImpl.registerMessageDispatcher(null);
        return rc;
    }

    @Override
    public void destroy() throws SolclientException {
        ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_destroy(this.getPointerValue()), "solClient_session_destroy");
        this.setPointerValue(0L);
        this.m_ClientName = null;
        this.sessionEventCallback = null;
        this.unregisterMessageCallback();
    }

    @Override
    public int createCacheSessionForHandle(CacheSessionHandle in_out_cacheSessionHandle, String[] properties, CacheSessionEventCallback cacheSessionEventCallback) throws SolclientException {
        int rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_createCacheSession(this.getPointerValue(), properties, in_out_cacheSessionHandle), "solClient_session_createCacheSession");
        ((CacheSessionHandleImpl)in_out_cacheSessionHandle).registerCacheSessionCallback(cacheSessionEventCallback);
        return rc;
    }

    @Override
    public int createFlowForHandle(FlowHandle in_out_flowHandle, String[] flowProperties, Endpoint endpoint, Subscription subscription, MessageCallback messageCallback, FlowEventCallback flowEventCallback) {
        String[] jniFlowProperties = ConceptConvertUtil.validateForFlowCreate(in_out_flowHandle, flowProperties, endpoint, subscription, messageCallback, flowEventCallback, false);
        ((FlowHandleImpl)in_out_flowHandle).registerEndpoint(endpoint);
        int rc = 0;
        try {
            rc = ExceptionGuard.assertReturnCode(ccsmp_services.getJNISession().solClient_session_createFlow(this.getPointerValue(), jniFlowProperties, in_out_flowHandle), "solClient_session_createFlow");
            ((FlowHandleImpl)in_out_flowHandle).registerSessionHandle(this);
        }
        catch (SolclientException se) {
            ((FlowHandleImpl)in_out_flowHandle).registerEndpoint(null);
            throw se;
        }
        return rc;
    }

    @Override
    public ClientName getClientName() throws SolclientException {
        ExceptionGuard.assertUsableBoundHandle("getClientName", this, "Common.NullSessionHandle");
        if (this.m_ClientName == null) {
            this.m_ClientName = Solclient.Allocator.newClientName(this.getProperty("SESSION_CLIENT_NAME"));
        }
        return this.m_ClientName;
    }
}

