/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.messages.AutoValue_ContainerInfo;
import com.spotify.docker.client.messages.AutoValue_ContainerInfo_Node;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerMount;
import com.spotify.docker.client.messages.ContainerState;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.NetworkSettings;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class ContainerInfo {
    @Nullable
    @JsonProperty(value="Id")
    public abstract String id();

    @JsonProperty(value="Created")
    public abstract Date created();

    @JsonProperty(value="Path")
    public abstract String path();

    @JsonProperty(value="Args")
    public abstract ImmutableList<String> args();

    @JsonProperty(value="Config")
    public abstract ContainerConfig config();

    @Nullable
    @JsonProperty(value="HostConfig")
    public abstract HostConfig hostConfig();

    @JsonProperty(value="State")
    public abstract ContainerState state();

    @JsonProperty(value="Image")
    public abstract String image();

    @JsonProperty(value="NetworkSettings")
    public abstract NetworkSettings networkSettings();

    @JsonProperty(value="ResolvConfPath")
    public abstract String resolvConfPath();

    @JsonProperty(value="HostnamePath")
    public abstract String hostnamePath();

    @JsonProperty(value="HostsPath")
    public abstract String hostsPath();

    @JsonProperty(value="Name")
    public abstract String name();

    @JsonProperty(value="Driver")
    public abstract String driver();

    @Nullable
    @JsonProperty(value="ExecDriver")
    public abstract String execDriver();

    @JsonProperty(value="ProcessLabel")
    public abstract String processLabel();

    @JsonProperty(value="MountLabel")
    public abstract String mountLabel();

    @Nullable
    @Deprecated
    @JsonProperty(value="Volumes")
    public abstract ImmutableMap<String, String> volumes();

    @Nullable
    @Deprecated
    @JsonProperty(value="VolumesRW")
    public abstract ImmutableMap<String, Boolean> volumesRw();

    @JsonProperty(value="AppArmorProfile")
    public abstract String appArmorProfile();

    @Nullable
    @JsonProperty(value="ExecIDs")
    public abstract ImmutableList<String> execIds();

    @JsonProperty(value="LogPath")
    public abstract String logPath();

    @JsonProperty(value="RestartCount")
    public abstract Long restartCount();

    @Nullable
    @JsonProperty(value="Mounts")
    public abstract ImmutableList<ContainerMount> mounts();

    @Nullable
    @JsonProperty(value="Node")
    public abstract Node node();

    @JsonCreator
    static ContainerInfo create(@JsonProperty(value="Id") String id, @JsonProperty(value="Created") Date created, @JsonProperty(value="Path") String path, @JsonProperty(value="Args") List<String> args, @JsonProperty(value="Config") ContainerConfig containerConfig, @JsonProperty(value="HostConfig") HostConfig hostConfig, @JsonProperty(value="State") ContainerState containerState, @JsonProperty(value="Image") String image, @JsonProperty(value="NetworkSettings") NetworkSettings networkSettings, @JsonProperty(value="ResolvConfPath") String resolvConfPath, @JsonProperty(value="HostnamePath") String hostnamePath, @JsonProperty(value="HostsPath") String hostsPath, @JsonProperty(value="Name") String name, @JsonProperty(value="Driver") String driver, @JsonProperty(value="ExecDriver") String execDriver, @JsonProperty(value="ProcessLabel") String processLabel, @JsonProperty(value="MountLabel") String mountLabel, @JsonProperty(value="Volumes") Map<String, String> volumes, @JsonProperty(value="VolumesRW") Map<String, Boolean> volumesRw, @JsonProperty(value="AppArmorProfile") String appArmorProfile, @JsonProperty(value="ExecIDs") List<String> execIds, @JsonProperty(value="LogPath") String logPath, @JsonProperty(value="RestartCount") Long restartCount, @JsonProperty(value="Mounts") List<ContainerMount> mounts, @JsonProperty(value="Node") Node node) {
        ImmutableMap volumesCopy = volumes == null ? null : ImmutableMap.copyOf(volumes);
        ImmutableMap volumesRwCopy = volumesRw == null ? null : ImmutableMap.copyOf(volumesRw);
        ImmutableList execIdsCopy = execIds == null ? null : ImmutableList.copyOf(execIds);
        ImmutableList mountsCopy = mounts == null ? null : ImmutableList.copyOf(mounts);
        return new AutoValue_ContainerInfo(id, created, path, (ImmutableList<String>)ImmutableList.copyOf(args), containerConfig, hostConfig, containerState, image, networkSettings, resolvConfPath, hostnamePath, hostsPath, name, driver, execDriver, processLabel, mountLabel, (ImmutableMap<String, String>)volumesCopy, (ImmutableMap<String, Boolean>)volumesRwCopy, appArmorProfile, (ImmutableList<String>)execIdsCopy, logPath, restartCount, (ImmutableList<ContainerMount>)mountsCopy, node);
    }

    public static abstract class Node {
        @JsonProperty(value="Id")
        public abstract String id();

        @JsonProperty(value="Ip")
        public abstract String ip();

        @JsonProperty(value="Addr")
        public abstract String addr();

        @JsonProperty(value="Name")
        public abstract String name();

        @JsonCreator
        static Node create(@JsonProperty(value="Id") String id, @JsonProperty(value="Ip") String ip, @JsonProperty(value="Addr") String addr, @JsonProperty(value="Name") String name) {
            return new AutoValue_ContainerInfo_Node(id, ip, addr, name);
        }
    }
}

