/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.api;

import com.squareup.connect.ApiClient;
import com.squareup.connect.ApiException;
import com.squareup.connect.CompleteResponse;
import com.squareup.connect.Configuration;
import com.squareup.connect.Pair;
import com.squareup.connect.models.BatchChangeInventoryRequest;
import com.squareup.connect.models.BatchChangeInventoryResponse;
import com.squareup.connect.models.BatchRetrieveInventoryChangesRequest;
import com.squareup.connect.models.BatchRetrieveInventoryChangesResponse;
import com.squareup.connect.models.BatchRetrieveInventoryCountsRequest;
import com.squareup.connect.models.BatchRetrieveInventoryCountsResponse;
import com.squareup.connect.models.RetrieveInventoryAdjustmentResponse;
import com.squareup.connect.models.RetrieveInventoryChangesResponse;
import com.squareup.connect.models.RetrieveInventoryCountResponse;
import com.squareup.connect.models.RetrieveInventoryPhysicalCountResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class InventoryApi {
    private ApiClient apiClient;

    public InventoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InventoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BatchChangeInventoryResponse batchChangeInventory(BatchChangeInventoryRequest body) throws ApiException {
        BatchChangeInventoryRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchChangeInventory");
        }
        String localVarPath = "/v2/inventory/batch-change";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2018-09-18");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<BatchChangeInventoryResponse> localVarReturnType = new GenericType<BatchChangeInventoryResponse>(){};
        CompleteResponse<BatchChangeInventoryResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<BatchChangeInventoryResponse> batchChangeInventoryWithHttpInfo(BatchChangeInventoryRequest body) throws ApiException {
        BatchChangeInventoryRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchChangeInventory");
        }
        String localVarPath = "/v2/inventory/batch-change";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<BatchChangeInventoryResponse> localVarReturnType = new GenericType<BatchChangeInventoryResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BatchRetrieveInventoryChangesResponse batchRetrieveInventoryChanges(BatchRetrieveInventoryChangesRequest body) throws ApiException {
        BatchRetrieveInventoryChangesRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchRetrieveInventoryChanges");
        }
        String localVarPath = "/v2/inventory/batch-retrieve-changes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2018-09-18");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<BatchRetrieveInventoryChangesResponse> localVarReturnType = new GenericType<BatchRetrieveInventoryChangesResponse>(){};
        CompleteResponse<BatchRetrieveInventoryChangesResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<BatchRetrieveInventoryChangesResponse> batchRetrieveInventoryChangesWithHttpInfo(BatchRetrieveInventoryChangesRequest body) throws ApiException {
        BatchRetrieveInventoryChangesRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchRetrieveInventoryChanges");
        }
        String localVarPath = "/v2/inventory/batch-retrieve-changes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<BatchRetrieveInventoryChangesResponse> localVarReturnType = new GenericType<BatchRetrieveInventoryChangesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BatchRetrieveInventoryCountsResponse batchRetrieveInventoryCounts(BatchRetrieveInventoryCountsRequest body) throws ApiException {
        BatchRetrieveInventoryCountsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchRetrieveInventoryCounts");
        }
        String localVarPath = "/v2/inventory/batch-retrieve-counts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2018-09-18");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<BatchRetrieveInventoryCountsResponse> localVarReturnType = new GenericType<BatchRetrieveInventoryCountsResponse>(){};
        CompleteResponse<BatchRetrieveInventoryCountsResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<BatchRetrieveInventoryCountsResponse> batchRetrieveInventoryCountsWithHttpInfo(BatchRetrieveInventoryCountsRequest body) throws ApiException {
        BatchRetrieveInventoryCountsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchRetrieveInventoryCounts");
        }
        String localVarPath = "/v2/inventory/batch-retrieve-counts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<BatchRetrieveInventoryCountsResponse> localVarReturnType = new GenericType<BatchRetrieveInventoryCountsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RetrieveInventoryAdjustmentResponse retrieveInventoryAdjustment(String adjustmentId) throws ApiException {
        Object localVarPostBody = null;
        if (adjustmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'adjustmentId' when calling retrieveInventoryAdjustment");
        }
        String localVarPath = "/v2/inventory/adjustment/{adjustment_id}".replaceAll("\\{adjustment_id\\}", this.apiClient.escapeString(adjustmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2018-09-18");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveInventoryAdjustmentResponse> localVarReturnType = new GenericType<RetrieveInventoryAdjustmentResponse>(){};
        CompleteResponse<RetrieveInventoryAdjustmentResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<RetrieveInventoryAdjustmentResponse> retrieveInventoryAdjustmentWithHttpInfo(String adjustmentId) throws ApiException {
        Object localVarPostBody = null;
        if (adjustmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'adjustmentId' when calling retrieveInventoryAdjustment");
        }
        String localVarPath = "/v2/inventory/adjustment/{adjustment_id}".replaceAll("\\{adjustment_id\\}", this.apiClient.escapeString(adjustmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveInventoryAdjustmentResponse> localVarReturnType = new GenericType<RetrieveInventoryAdjustmentResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RetrieveInventoryChangesResponse retrieveInventoryChanges(String catalogObjectId, String locationIds, String cursor) throws ApiException {
        Object localVarPostBody = null;
        if (catalogObjectId == null) {
            throw new ApiException(400, "Missing the required parameter 'catalogObjectId' when calling retrieveInventoryChanges");
        }
        String localVarPath = "/v2/inventory/{catalog_object_id}/changes".replaceAll("\\{catalog_object_id\\}", this.apiClient.escapeString(catalogObjectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2018-09-18");
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "location_ids", locationIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveInventoryChangesResponse> localVarReturnType = new GenericType<RetrieveInventoryChangesResponse>(){};
        CompleteResponse<RetrieveInventoryChangesResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<RetrieveInventoryChangesResponse> retrieveInventoryChangesWithHttpInfo(String catalogObjectId, String locationIds, String cursor) throws ApiException {
        Object localVarPostBody = null;
        if (catalogObjectId == null) {
            throw new ApiException(400, "Missing the required parameter 'catalogObjectId' when calling retrieveInventoryChanges");
        }
        String localVarPath = "/v2/inventory/{catalog_object_id}/changes".replaceAll("\\{catalog_object_id\\}", this.apiClient.escapeString(catalogObjectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "location_ids", locationIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveInventoryChangesResponse> localVarReturnType = new GenericType<RetrieveInventoryChangesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RetrieveInventoryCountResponse retrieveInventoryCount(String catalogObjectId, String locationIds, String cursor) throws ApiException {
        Object localVarPostBody = null;
        if (catalogObjectId == null) {
            throw new ApiException(400, "Missing the required parameter 'catalogObjectId' when calling retrieveInventoryCount");
        }
        String localVarPath = "/v2/inventory/{catalog_object_id}".replaceAll("\\{catalog_object_id\\}", this.apiClient.escapeString(catalogObjectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2018-09-18");
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "location_ids", locationIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveInventoryCountResponse> localVarReturnType = new GenericType<RetrieveInventoryCountResponse>(){};
        CompleteResponse<RetrieveInventoryCountResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<RetrieveInventoryCountResponse> retrieveInventoryCountWithHttpInfo(String catalogObjectId, String locationIds, String cursor) throws ApiException {
        Object localVarPostBody = null;
        if (catalogObjectId == null) {
            throw new ApiException(400, "Missing the required parameter 'catalogObjectId' when calling retrieveInventoryCount");
        }
        String localVarPath = "/v2/inventory/{catalog_object_id}".replaceAll("\\{catalog_object_id\\}", this.apiClient.escapeString(catalogObjectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "location_ids", locationIds));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveInventoryCountResponse> localVarReturnType = new GenericType<RetrieveInventoryCountResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RetrieveInventoryPhysicalCountResponse retrieveInventoryPhysicalCount(String physicalCountId) throws ApiException {
        Object localVarPostBody = null;
        if (physicalCountId == null) {
            throw new ApiException(400, "Missing the required parameter 'physicalCountId' when calling retrieveInventoryPhysicalCount");
        }
        String localVarPath = "/v2/inventory/physical-count/{physical_count_id}".replaceAll("\\{physical_count_id\\}", this.apiClient.escapeString(physicalCountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2018-09-18");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveInventoryPhysicalCountResponse> localVarReturnType = new GenericType<RetrieveInventoryPhysicalCountResponse>(){};
        CompleteResponse<RetrieveInventoryPhysicalCountResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<RetrieveInventoryPhysicalCountResponse> retrieveInventoryPhysicalCountWithHttpInfo(String physicalCountId) throws ApiException {
        Object localVarPostBody = null;
        if (physicalCountId == null) {
            throw new ApiException(400, "Missing the required parameter 'physicalCountId' when calling retrieveInventoryPhysicalCount");
        }
        String localVarPath = "/v2/inventory/physical-count/{physical_count_id}".replaceAll("\\{physical_count_id\\}", this.apiClient.escapeString(physicalCountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveInventoryPhysicalCountResponse> localVarReturnType = new GenericType<RetrieveInventoryPhysicalCountResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

