/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.api;

import com.squareup.connect.ApiClient;
import com.squareup.connect.ApiException;
import com.squareup.connect.CompleteResponse;
import com.squareup.connect.Configuration;
import com.squareup.connect.Pair;
import com.squareup.connect.models.V1CashDrawerShift;
import com.squareup.connect.models.V1Employee;
import com.squareup.connect.models.V1EmployeeRole;
import com.squareup.connect.models.V1Timecard;
import com.squareup.connect.models.V1TimecardEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class V1EmployeesApi {
    private ApiClient apiClient;

    public V1EmployeesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public V1EmployeesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public V1Employee createEmployee(V1Employee body) throws ApiException {
        V1Employee localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createEmployee");
        }
        String localVarPath = "/v1/me/employees";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Employee> localVarReturnType = new GenericType<V1Employee>(){};
        CompleteResponse<V1Employee> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Employee> createEmployeeWithHttpInfo(V1Employee body) throws ApiException {
        V1Employee localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createEmployee");
        }
        String localVarPath = "/v1/me/employees";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Employee> localVarReturnType = new GenericType<V1Employee>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1EmployeeRole createEmployeeRole(V1EmployeeRole employeeRole) throws ApiException {
        V1EmployeeRole localVarPostBody = employeeRole;
        if (employeeRole == null) {
            throw new ApiException(400, "Missing the required parameter 'employeeRole' when calling createEmployeeRole");
        }
        String localVarPath = "/v1/me/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1EmployeeRole> localVarReturnType = new GenericType<V1EmployeeRole>(){};
        CompleteResponse<V1EmployeeRole> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1EmployeeRole> createEmployeeRoleWithHttpInfo(V1EmployeeRole employeeRole) throws ApiException {
        V1EmployeeRole localVarPostBody = employeeRole;
        if (employeeRole == null) {
            throw new ApiException(400, "Missing the required parameter 'employeeRole' when calling createEmployeeRole");
        }
        String localVarPath = "/v1/me/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1EmployeeRole> localVarReturnType = new GenericType<V1EmployeeRole>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Timecard createTimecard(V1Timecard body) throws ApiException {
        V1Timecard localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTimecard");
        }
        String localVarPath = "/v1/me/timecards";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Timecard> localVarReturnType = new GenericType<V1Timecard>(){};
        CompleteResponse<V1Timecard> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Timecard> createTimecardWithHttpInfo(V1Timecard body) throws ApiException {
        V1Timecard localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTimecard");
        }
        String localVarPath = "/v1/me/timecards";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Timecard> localVarReturnType = new GenericType<V1Timecard>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object deleteTimecard(String timecardId) throws ApiException {
        Object localVarPostBody = null;
        if (timecardId == null) {
            throw new ApiException(400, "Missing the required parameter 'timecardId' when calling deleteTimecard");
        }
        String localVarPath = "/v1/me/timecards/{timecard_id}".replaceAll("\\{timecard_id\\}", this.apiClient.escapeString(timecardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        CompleteResponse<Object> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<Object> deleteTimecardWithHttpInfo(String timecardId) throws ApiException {
        Object localVarPostBody = null;
        if (timecardId == null) {
            throw new ApiException(400, "Missing the required parameter 'timecardId' when calling deleteTimecard");
        }
        String localVarPath = "/v1/me/timecards/{timecard_id}".replaceAll("\\{timecard_id\\}", this.apiClient.escapeString(timecardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1CashDrawerShift> listCashDrawerShifts(String locationId, String order, String beginTime, String endTime) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listCashDrawerShifts");
        }
        String localVarPath = "/v1/{location_id}/cash-drawer-shifts".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_time", beginTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_time", endTime));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1CashDrawerShift>> localVarReturnType = new GenericType<List<V1CashDrawerShift>>(){};
        CompleteResponse<List<V1CashDrawerShift>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1CashDrawerShift>> listCashDrawerShiftsWithHttpInfo(String locationId, String order, String beginTime, String endTime) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listCashDrawerShifts");
        }
        String localVarPath = "/v1/{location_id}/cash-drawer-shifts".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_time", beginTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_time", endTime));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1CashDrawerShift>> localVarReturnType = new GenericType<List<V1CashDrawerShift>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1EmployeeRole> listEmployeeRoles(String order, Integer limit, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/me/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1EmployeeRole>> localVarReturnType = new GenericType<List<V1EmployeeRole>>(){};
        CompleteResponse<List<V1EmployeeRole>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1EmployeeRole>> listEmployeeRolesWithHttpInfo(String order, Integer limit, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/me/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1EmployeeRole>> localVarReturnType = new GenericType<List<V1EmployeeRole>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1Employee> listEmployees(String order, String beginUpdatedAt, String endUpdatedAt, String beginCreatedAt, String endCreatedAt, String status, String externalId, Integer limit, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/me/employees";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_updated_at", beginUpdatedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_updated_at", endUpdatedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_created_at", beginCreatedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_created_at", endCreatedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "external_id", externalId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Employee>> localVarReturnType = new GenericType<List<V1Employee>>(){};
        CompleteResponse<List<V1Employee>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1Employee>> listEmployeesWithHttpInfo(String order, String beginUpdatedAt, String endUpdatedAt, String beginCreatedAt, String endCreatedAt, String status, String externalId, Integer limit, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/me/employees";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_updated_at", beginUpdatedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_updated_at", endUpdatedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_created_at", beginCreatedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_created_at", endCreatedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "external_id", externalId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Employee>> localVarReturnType = new GenericType<List<V1Employee>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1TimecardEvent> listTimecardEvents(String timecardId) throws ApiException {
        Object localVarPostBody = null;
        if (timecardId == null) {
            throw new ApiException(400, "Missing the required parameter 'timecardId' when calling listTimecardEvents");
        }
        String localVarPath = "/v1/me/timecards/{timecard_id}/events".replaceAll("\\{timecard_id\\}", this.apiClient.escapeString(timecardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1TimecardEvent>> localVarReturnType = new GenericType<List<V1TimecardEvent>>(){};
        CompleteResponse<List<V1TimecardEvent>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1TimecardEvent>> listTimecardEventsWithHttpInfo(String timecardId) throws ApiException {
        Object localVarPostBody = null;
        if (timecardId == null) {
            throw new ApiException(400, "Missing the required parameter 'timecardId' when calling listTimecardEvents");
        }
        String localVarPath = "/v1/me/timecards/{timecard_id}/events".replaceAll("\\{timecard_id\\}", this.apiClient.escapeString(timecardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1TimecardEvent>> localVarReturnType = new GenericType<List<V1TimecardEvent>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1Timecard> listTimecards(String order, String employeeId, String beginClockinTime, String endClockinTime, String beginClockoutTime, String endClockoutTime, String beginUpdatedAt, String endUpdatedAt, Boolean deleted, Integer limit, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/me/timecards";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "employee_id", employeeId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_clockin_time", beginClockinTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_clockin_time", endClockinTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_clockout_time", beginClockoutTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_clockout_time", endClockoutTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_updated_at", beginUpdatedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_updated_at", endUpdatedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "deleted", deleted));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Timecard>> localVarReturnType = new GenericType<List<V1Timecard>>(){};
        CompleteResponse<List<V1Timecard>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1Timecard>> listTimecardsWithHttpInfo(String order, String employeeId, String beginClockinTime, String endClockinTime, String beginClockoutTime, String endClockoutTime, String beginUpdatedAt, String endUpdatedAt, Boolean deleted, Integer limit, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/me/timecards";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "employee_id", employeeId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_clockin_time", beginClockinTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_clockin_time", endClockinTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_clockout_time", beginClockoutTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_clockout_time", endClockoutTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_updated_at", beginUpdatedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_updated_at", endUpdatedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "deleted", deleted));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Timecard>> localVarReturnType = new GenericType<List<V1Timecard>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1CashDrawerShift retrieveCashDrawerShift(String locationId, String shiftId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveCashDrawerShift");
        }
        if (shiftId == null) {
            throw new ApiException(400, "Missing the required parameter 'shiftId' when calling retrieveCashDrawerShift");
        }
        String localVarPath = "/v1/{location_id}/cash-drawer-shifts/{shift_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{shift_id\\}", this.apiClient.escapeString(shiftId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1CashDrawerShift> localVarReturnType = new GenericType<V1CashDrawerShift>(){};
        CompleteResponse<V1CashDrawerShift> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1CashDrawerShift> retrieveCashDrawerShiftWithHttpInfo(String locationId, String shiftId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveCashDrawerShift");
        }
        if (shiftId == null) {
            throw new ApiException(400, "Missing the required parameter 'shiftId' when calling retrieveCashDrawerShift");
        }
        String localVarPath = "/v1/{location_id}/cash-drawer-shifts/{shift_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{shift_id\\}", this.apiClient.escapeString(shiftId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1CashDrawerShift> localVarReturnType = new GenericType<V1CashDrawerShift>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Employee retrieveEmployee(String employeeId) throws ApiException {
        Object localVarPostBody = null;
        if (employeeId == null) {
            throw new ApiException(400, "Missing the required parameter 'employeeId' when calling retrieveEmployee");
        }
        String localVarPath = "/v1/me/employees/{employee_id}".replaceAll("\\{employee_id\\}", this.apiClient.escapeString(employeeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Employee> localVarReturnType = new GenericType<V1Employee>(){};
        CompleteResponse<V1Employee> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Employee> retrieveEmployeeWithHttpInfo(String employeeId) throws ApiException {
        Object localVarPostBody = null;
        if (employeeId == null) {
            throw new ApiException(400, "Missing the required parameter 'employeeId' when calling retrieveEmployee");
        }
        String localVarPath = "/v1/me/employees/{employee_id}".replaceAll("\\{employee_id\\}", this.apiClient.escapeString(employeeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Employee> localVarReturnType = new GenericType<V1Employee>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1EmployeeRole retrieveEmployeeRole(String roleId) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling retrieveEmployeeRole");
        }
        String localVarPath = "/v1/me/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1EmployeeRole> localVarReturnType = new GenericType<V1EmployeeRole>(){};
        CompleteResponse<V1EmployeeRole> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1EmployeeRole> retrieveEmployeeRoleWithHttpInfo(String roleId) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling retrieveEmployeeRole");
        }
        String localVarPath = "/v1/me/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1EmployeeRole> localVarReturnType = new GenericType<V1EmployeeRole>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Timecard retrieveTimecard(String timecardId) throws ApiException {
        Object localVarPostBody = null;
        if (timecardId == null) {
            throw new ApiException(400, "Missing the required parameter 'timecardId' when calling retrieveTimecard");
        }
        String localVarPath = "/v1/me/timecards/{timecard_id}".replaceAll("\\{timecard_id\\}", this.apiClient.escapeString(timecardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Timecard> localVarReturnType = new GenericType<V1Timecard>(){};
        CompleteResponse<V1Timecard> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Timecard> retrieveTimecardWithHttpInfo(String timecardId) throws ApiException {
        Object localVarPostBody = null;
        if (timecardId == null) {
            throw new ApiException(400, "Missing the required parameter 'timecardId' when calling retrieveTimecard");
        }
        String localVarPath = "/v1/me/timecards/{timecard_id}".replaceAll("\\{timecard_id\\}", this.apiClient.escapeString(timecardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Timecard> localVarReturnType = new GenericType<V1Timecard>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Employee updateEmployee(String employeeId, V1Employee body) throws ApiException {
        V1Employee localVarPostBody = body;
        if (employeeId == null) {
            throw new ApiException(400, "Missing the required parameter 'employeeId' when calling updateEmployee");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateEmployee");
        }
        String localVarPath = "/v1/me/employees/{employee_id}".replaceAll("\\{employee_id\\}", this.apiClient.escapeString(employeeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Employee> localVarReturnType = new GenericType<V1Employee>(){};
        CompleteResponse<V1Employee> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Employee> updateEmployeeWithHttpInfo(String employeeId, V1Employee body) throws ApiException {
        V1Employee localVarPostBody = body;
        if (employeeId == null) {
            throw new ApiException(400, "Missing the required parameter 'employeeId' when calling updateEmployee");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateEmployee");
        }
        String localVarPath = "/v1/me/employees/{employee_id}".replaceAll("\\{employee_id\\}", this.apiClient.escapeString(employeeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Employee> localVarReturnType = new GenericType<V1Employee>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1EmployeeRole updateEmployeeRole(String roleId, V1EmployeeRole body) throws ApiException {
        V1EmployeeRole localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling updateEmployeeRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateEmployeeRole");
        }
        String localVarPath = "/v1/me/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1EmployeeRole> localVarReturnType = new GenericType<V1EmployeeRole>(){};
        CompleteResponse<V1EmployeeRole> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1EmployeeRole> updateEmployeeRoleWithHttpInfo(String roleId, V1EmployeeRole body) throws ApiException {
        V1EmployeeRole localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling updateEmployeeRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateEmployeeRole");
        }
        String localVarPath = "/v1/me/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1EmployeeRole> localVarReturnType = new GenericType<V1EmployeeRole>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Timecard updateTimecard(String timecardId, V1Timecard body) throws ApiException {
        V1Timecard localVarPostBody = body;
        if (timecardId == null) {
            throw new ApiException(400, "Missing the required parameter 'timecardId' when calling updateTimecard");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTimecard");
        }
        String localVarPath = "/v1/me/timecards/{timecard_id}".replaceAll("\\{timecard_id\\}", this.apiClient.escapeString(timecardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Timecard> localVarReturnType = new GenericType<V1Timecard>(){};
        CompleteResponse<V1Timecard> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Timecard> updateTimecardWithHttpInfo(String timecardId, V1Timecard body) throws ApiException {
        V1Timecard localVarPostBody = body;
        if (timecardId == null) {
            throw new ApiException(400, "Missing the required parameter 'timecardId' when calling updateTimecard");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTimecard");
        }
        String localVarPath = "/v1/me/timecards/{timecard_id}".replaceAll("\\{timecard_id\\}", this.apiClient.escapeString(timecardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Timecard> localVarReturnType = new GenericType<V1Timecard>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

