/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.api;

import com.squareup.connect.ApiClient;
import com.squareup.connect.ApiException;
import com.squareup.connect.CompleteResponse;
import com.squareup.connect.Configuration;
import com.squareup.connect.Pair;
import com.squareup.connect.models.V1AdjustInventoryRequest;
import com.squareup.connect.models.V1Category;
import com.squareup.connect.models.V1Discount;
import com.squareup.connect.models.V1Fee;
import com.squareup.connect.models.V1InventoryEntry;
import com.squareup.connect.models.V1Item;
import com.squareup.connect.models.V1ModifierList;
import com.squareup.connect.models.V1ModifierOption;
import com.squareup.connect.models.V1Page;
import com.squareup.connect.models.V1PageCell;
import com.squareup.connect.models.V1UpdateModifierListRequest;
import com.squareup.connect.models.V1Variation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class V1ItemsApi {
    private ApiClient apiClient;

    public V1ItemsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public V1ItemsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public V1InventoryEntry adjustInventory(String locationId, String variationId, V1AdjustInventoryRequest body) throws ApiException {
        V1AdjustInventoryRequest localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling adjustInventory");
        }
        if (variationId == null) {
            throw new ApiException(400, "Missing the required parameter 'variationId' when calling adjustInventory");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling adjustInventory");
        }
        String localVarPath = "/v1/{location_id}/inventory/{variation_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{variation_id\\}", this.apiClient.escapeString(variationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1InventoryEntry> localVarReturnType = new GenericType<V1InventoryEntry>(){};
        CompleteResponse<V1InventoryEntry> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1InventoryEntry> adjustInventoryWithHttpInfo(String locationId, String variationId, V1AdjustInventoryRequest body) throws ApiException {
        V1AdjustInventoryRequest localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling adjustInventory");
        }
        if (variationId == null) {
            throw new ApiException(400, "Missing the required parameter 'variationId' when calling adjustInventory");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling adjustInventory");
        }
        String localVarPath = "/v1/{location_id}/inventory/{variation_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{variation_id\\}", this.apiClient.escapeString(variationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1InventoryEntry> localVarReturnType = new GenericType<V1InventoryEntry>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Item applyFee(String locationId, String itemId, String feeId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling applyFee");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling applyFee");
        }
        if (feeId == null) {
            throw new ApiException(400, "Missing the required parameter 'feeId' when calling applyFee");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/fees/{fee_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString())).replaceAll("\\{fee_id\\}", this.apiClient.escapeString(feeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        CompleteResponse<V1Item> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Item> applyFeeWithHttpInfo(String locationId, String itemId, String feeId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling applyFee");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling applyFee");
        }
        if (feeId == null) {
            throw new ApiException(400, "Missing the required parameter 'feeId' when calling applyFee");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/fees/{fee_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString())).replaceAll("\\{fee_id\\}", this.apiClient.escapeString(feeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Item applyModifierList(String locationId, String modifierListId, String itemId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling applyModifierList");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling applyModifierList");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling applyModifierList");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/modifier-lists/{modifier_list_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        CompleteResponse<V1Item> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Item> applyModifierListWithHttpInfo(String locationId, String modifierListId, String itemId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling applyModifierList");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling applyModifierList");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling applyModifierList");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/modifier-lists/{modifier_list_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Category createCategory(String locationId, V1Category body) throws ApiException {
        V1Category localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createCategory");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCategory");
        }
        String localVarPath = "/v1/{location_id}/categories".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Category> localVarReturnType = new GenericType<V1Category>(){};
        CompleteResponse<V1Category> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Category> createCategoryWithHttpInfo(String locationId, V1Category body) throws ApiException {
        V1Category localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createCategory");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCategory");
        }
        String localVarPath = "/v1/{location_id}/categories".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Category> localVarReturnType = new GenericType<V1Category>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Discount createDiscount(String locationId, V1Discount body) throws ApiException {
        V1Discount localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createDiscount");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDiscount");
        }
        String localVarPath = "/v1/{location_id}/discounts".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Discount> localVarReturnType = new GenericType<V1Discount>(){};
        CompleteResponse<V1Discount> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Discount> createDiscountWithHttpInfo(String locationId, V1Discount body) throws ApiException {
        V1Discount localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createDiscount");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDiscount");
        }
        String localVarPath = "/v1/{location_id}/discounts".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Discount> localVarReturnType = new GenericType<V1Discount>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Fee createFee(String locationId, V1Fee body) throws ApiException {
        V1Fee localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createFee");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createFee");
        }
        String localVarPath = "/v1/{location_id}/fees".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Fee> localVarReturnType = new GenericType<V1Fee>(){};
        CompleteResponse<V1Fee> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Fee> createFeeWithHttpInfo(String locationId, V1Fee body) throws ApiException {
        V1Fee localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createFee");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createFee");
        }
        String localVarPath = "/v1/{location_id}/fees".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Fee> localVarReturnType = new GenericType<V1Fee>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Item createItem(String locationId, V1Item body) throws ApiException {
        V1Item localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createItem");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createItem");
        }
        String localVarPath = "/v1/{location_id}/items".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        CompleteResponse<V1Item> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Item> createItemWithHttpInfo(String locationId, V1Item body) throws ApiException {
        V1Item localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createItem");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createItem");
        }
        String localVarPath = "/v1/{location_id}/items".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1ModifierList createModifierList(String locationId, V1ModifierList body) throws ApiException {
        V1ModifierList localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createModifierList");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createModifierList");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierList> localVarReturnType = new GenericType<V1ModifierList>(){};
        CompleteResponse<V1ModifierList> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1ModifierList> createModifierListWithHttpInfo(String locationId, V1ModifierList body) throws ApiException {
        V1ModifierList localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createModifierList");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createModifierList");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierList> localVarReturnType = new GenericType<V1ModifierList>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1ModifierOption createModifierOption(String locationId, String modifierListId, V1ModifierOption body) throws ApiException {
        V1ModifierOption localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createModifierOption");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling createModifierOption");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createModifierOption");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists/{modifier_list_id}/modifier-options".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierOption> localVarReturnType = new GenericType<V1ModifierOption>(){};
        CompleteResponse<V1ModifierOption> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1ModifierOption> createModifierOptionWithHttpInfo(String locationId, String modifierListId, V1ModifierOption body) throws ApiException {
        V1ModifierOption localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createModifierOption");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling createModifierOption");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createModifierOption");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists/{modifier_list_id}/modifier-options".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierOption> localVarReturnType = new GenericType<V1ModifierOption>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Page createPage(String locationId, V1Page body) throws ApiException {
        V1Page localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createPage");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createPage");
        }
        String localVarPath = "/v1/{location_id}/pages".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Page> localVarReturnType = new GenericType<V1Page>(){};
        CompleteResponse<V1Page> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Page> createPageWithHttpInfo(String locationId, V1Page body) throws ApiException {
        V1Page localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createPage");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createPage");
        }
        String localVarPath = "/v1/{location_id}/pages".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Page> localVarReturnType = new GenericType<V1Page>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Variation createVariation(String locationId, String itemId, V1Variation body) throws ApiException {
        V1Variation localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createVariation");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling createVariation");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createVariation");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/variations".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Variation> localVarReturnType = new GenericType<V1Variation>(){};
        CompleteResponse<V1Variation> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Variation> createVariationWithHttpInfo(String locationId, String itemId, V1Variation body) throws ApiException {
        V1Variation localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createVariation");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling createVariation");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createVariation");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/variations".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Variation> localVarReturnType = new GenericType<V1Variation>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Category deleteCategory(String locationId, String categoryId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteCategory");
        }
        if (categoryId == null) {
            throw new ApiException(400, "Missing the required parameter 'categoryId' when calling deleteCategory");
        }
        String localVarPath = "/v1/{location_id}/categories/{category_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{category_id\\}", this.apiClient.escapeString(categoryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Category> localVarReturnType = new GenericType<V1Category>(){};
        CompleteResponse<V1Category> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Category> deleteCategoryWithHttpInfo(String locationId, String categoryId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteCategory");
        }
        if (categoryId == null) {
            throw new ApiException(400, "Missing the required parameter 'categoryId' when calling deleteCategory");
        }
        String localVarPath = "/v1/{location_id}/categories/{category_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{category_id\\}", this.apiClient.escapeString(categoryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Category> localVarReturnType = new GenericType<V1Category>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Discount deleteDiscount(String locationId, String discountId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteDiscount");
        }
        if (discountId == null) {
            throw new ApiException(400, "Missing the required parameter 'discountId' when calling deleteDiscount");
        }
        String localVarPath = "/v1/{location_id}/discounts/{discount_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{discount_id\\}", this.apiClient.escapeString(discountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Discount> localVarReturnType = new GenericType<V1Discount>(){};
        CompleteResponse<V1Discount> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Discount> deleteDiscountWithHttpInfo(String locationId, String discountId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteDiscount");
        }
        if (discountId == null) {
            throw new ApiException(400, "Missing the required parameter 'discountId' when calling deleteDiscount");
        }
        String localVarPath = "/v1/{location_id}/discounts/{discount_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{discount_id\\}", this.apiClient.escapeString(discountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Discount> localVarReturnType = new GenericType<V1Discount>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Fee deleteFee(String locationId, String feeId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteFee");
        }
        if (feeId == null) {
            throw new ApiException(400, "Missing the required parameter 'feeId' when calling deleteFee");
        }
        String localVarPath = "/v1/{location_id}/fees/{fee_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{fee_id\\}", this.apiClient.escapeString(feeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Fee> localVarReturnType = new GenericType<V1Fee>(){};
        CompleteResponse<V1Fee> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Fee> deleteFeeWithHttpInfo(String locationId, String feeId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteFee");
        }
        if (feeId == null) {
            throw new ApiException(400, "Missing the required parameter 'feeId' when calling deleteFee");
        }
        String localVarPath = "/v1/{location_id}/fees/{fee_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{fee_id\\}", this.apiClient.escapeString(feeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Fee> localVarReturnType = new GenericType<V1Fee>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Item deleteItem(String locationId, String itemId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteItem");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling deleteItem");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        CompleteResponse<V1Item> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Item> deleteItemWithHttpInfo(String locationId, String itemId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteItem");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling deleteItem");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1ModifierList deleteModifierList(String locationId, String modifierListId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteModifierList");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling deleteModifierList");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists/{modifier_list_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierList> localVarReturnType = new GenericType<V1ModifierList>(){};
        CompleteResponse<V1ModifierList> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1ModifierList> deleteModifierListWithHttpInfo(String locationId, String modifierListId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteModifierList");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling deleteModifierList");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists/{modifier_list_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierList> localVarReturnType = new GenericType<V1ModifierList>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1ModifierOption deleteModifierOption(String locationId, String modifierListId, String modifierOptionId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteModifierOption");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling deleteModifierOption");
        }
        if (modifierOptionId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierOptionId' when calling deleteModifierOption");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists/{modifier_list_id}/modifier-options/{modifier_option_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString())).replaceAll("\\{modifier_option_id\\}", this.apiClient.escapeString(modifierOptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierOption> localVarReturnType = new GenericType<V1ModifierOption>(){};
        CompleteResponse<V1ModifierOption> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1ModifierOption> deleteModifierOptionWithHttpInfo(String locationId, String modifierListId, String modifierOptionId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteModifierOption");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling deleteModifierOption");
        }
        if (modifierOptionId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierOptionId' when calling deleteModifierOption");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists/{modifier_list_id}/modifier-options/{modifier_option_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString())).replaceAll("\\{modifier_option_id\\}", this.apiClient.escapeString(modifierOptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierOption> localVarReturnType = new GenericType<V1ModifierOption>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Page deletePage(String locationId, String pageId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deletePage");
        }
        if (pageId == null) {
            throw new ApiException(400, "Missing the required parameter 'pageId' when calling deletePage");
        }
        String localVarPath = "/v1/{location_id}/pages/{page_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Page> localVarReturnType = new GenericType<V1Page>(){};
        CompleteResponse<V1Page> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Page> deletePageWithHttpInfo(String locationId, String pageId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deletePage");
        }
        if (pageId == null) {
            throw new ApiException(400, "Missing the required parameter 'pageId' when calling deletePage");
        }
        String localVarPath = "/v1/{location_id}/pages/{page_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Page> localVarReturnType = new GenericType<V1Page>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Page deletePageCell(String locationId, String pageId, String row, String column) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deletePageCell");
        }
        if (pageId == null) {
            throw new ApiException(400, "Missing the required parameter 'pageId' when calling deletePageCell");
        }
        String localVarPath = "/v1/{location_id}/pages/{page_id}/cells".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "row", row));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "column", column));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Page> localVarReturnType = new GenericType<V1Page>(){};
        CompleteResponse<V1Page> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Page> deletePageCellWithHttpInfo(String locationId, String pageId, String row, String column) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deletePageCell");
        }
        if (pageId == null) {
            throw new ApiException(400, "Missing the required parameter 'pageId' when calling deletePageCell");
        }
        String localVarPath = "/v1/{location_id}/pages/{page_id}/cells".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "row", row));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "column", column));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Page> localVarReturnType = new GenericType<V1Page>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Variation deleteVariation(String locationId, String itemId, String variationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteVariation");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling deleteVariation");
        }
        if (variationId == null) {
            throw new ApiException(400, "Missing the required parameter 'variationId' when calling deleteVariation");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/variations/{variation_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString())).replaceAll("\\{variation_id\\}", this.apiClient.escapeString(variationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Variation> localVarReturnType = new GenericType<V1Variation>(){};
        CompleteResponse<V1Variation> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Variation> deleteVariationWithHttpInfo(String locationId, String itemId, String variationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deleteVariation");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling deleteVariation");
        }
        if (variationId == null) {
            throw new ApiException(400, "Missing the required parameter 'variationId' when calling deleteVariation");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/variations/{variation_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString())).replaceAll("\\{variation_id\\}", this.apiClient.escapeString(variationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Variation> localVarReturnType = new GenericType<V1Variation>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1Category> listCategories(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listCategories");
        }
        String localVarPath = "/v1/{location_id}/categories".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Category>> localVarReturnType = new GenericType<List<V1Category>>(){};
        CompleteResponse<List<V1Category>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1Category>> listCategoriesWithHttpInfo(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listCategories");
        }
        String localVarPath = "/v1/{location_id}/categories".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Category>> localVarReturnType = new GenericType<List<V1Category>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1Discount> listDiscounts(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listDiscounts");
        }
        String localVarPath = "/v1/{location_id}/discounts".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Discount>> localVarReturnType = new GenericType<List<V1Discount>>(){};
        CompleteResponse<List<V1Discount>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1Discount>> listDiscountsWithHttpInfo(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listDiscounts");
        }
        String localVarPath = "/v1/{location_id}/discounts".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Discount>> localVarReturnType = new GenericType<List<V1Discount>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1Fee> listFees(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listFees");
        }
        String localVarPath = "/v1/{location_id}/fees".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Fee>> localVarReturnType = new GenericType<List<V1Fee>>(){};
        CompleteResponse<List<V1Fee>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1Fee>> listFeesWithHttpInfo(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listFees");
        }
        String localVarPath = "/v1/{location_id}/fees".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Fee>> localVarReturnType = new GenericType<List<V1Fee>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1InventoryEntry> listInventory(String locationId, Integer limit, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listInventory");
        }
        String localVarPath = "/v1/{location_id}/inventory".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1InventoryEntry>> localVarReturnType = new GenericType<List<V1InventoryEntry>>(){};
        CompleteResponse<List<V1InventoryEntry>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1InventoryEntry>> listInventoryWithHttpInfo(String locationId, Integer limit, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listInventory");
        }
        String localVarPath = "/v1/{location_id}/inventory".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1InventoryEntry>> localVarReturnType = new GenericType<List<V1InventoryEntry>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1Item> listItems(String locationId, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listItems");
        }
        String localVarPath = "/v1/{location_id}/items".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Item>> localVarReturnType = new GenericType<List<V1Item>>(){};
        CompleteResponse<List<V1Item>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1Item>> listItemsWithHttpInfo(String locationId, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listItems");
        }
        String localVarPath = "/v1/{location_id}/items".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Item>> localVarReturnType = new GenericType<List<V1Item>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1ModifierList> listModifierLists(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listModifierLists");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1ModifierList>> localVarReturnType = new GenericType<List<V1ModifierList>>(){};
        CompleteResponse<List<V1ModifierList>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1ModifierList>> listModifierListsWithHttpInfo(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listModifierLists");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1ModifierList>> localVarReturnType = new GenericType<List<V1ModifierList>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1Page> listPages(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listPages");
        }
        String localVarPath = "/v1/{location_id}/pages".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Page>> localVarReturnType = new GenericType<List<V1Page>>(){};
        CompleteResponse<List<V1Page>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1Page>> listPagesWithHttpInfo(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listPages");
        }
        String localVarPath = "/v1/{location_id}/pages".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Page>> localVarReturnType = new GenericType<List<V1Page>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Item removeFee(String locationId, String itemId, String feeId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling removeFee");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling removeFee");
        }
        if (feeId == null) {
            throw new ApiException(400, "Missing the required parameter 'feeId' when calling removeFee");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/fees/{fee_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString())).replaceAll("\\{fee_id\\}", this.apiClient.escapeString(feeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        CompleteResponse<V1Item> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Item> removeFeeWithHttpInfo(String locationId, String itemId, String feeId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling removeFee");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling removeFee");
        }
        if (feeId == null) {
            throw new ApiException(400, "Missing the required parameter 'feeId' when calling removeFee");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/fees/{fee_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString())).replaceAll("\\{fee_id\\}", this.apiClient.escapeString(feeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Item removeModifierList(String locationId, String modifierListId, String itemId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling removeModifierList");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling removeModifierList");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling removeModifierList");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/modifier-lists/{modifier_list_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        CompleteResponse<V1Item> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Item> removeModifierListWithHttpInfo(String locationId, String modifierListId, String itemId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling removeModifierList");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling removeModifierList");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling removeModifierList");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/modifier-lists/{modifier_list_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Item retrieveItem(String locationId, String itemId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveItem");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling retrieveItem");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        CompleteResponse<V1Item> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Item> retrieveItemWithHttpInfo(String locationId, String itemId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveItem");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling retrieveItem");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1ModifierList retrieveModifierList(String locationId, String modifierListId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveModifierList");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling retrieveModifierList");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists/{modifier_list_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierList> localVarReturnType = new GenericType<V1ModifierList>(){};
        CompleteResponse<V1ModifierList> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1ModifierList> retrieveModifierListWithHttpInfo(String locationId, String modifierListId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveModifierList");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling retrieveModifierList");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists/{modifier_list_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierList> localVarReturnType = new GenericType<V1ModifierList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Category updateCategory(String locationId, String categoryId, V1Category body) throws ApiException {
        V1Category localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateCategory");
        }
        if (categoryId == null) {
            throw new ApiException(400, "Missing the required parameter 'categoryId' when calling updateCategory");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCategory");
        }
        String localVarPath = "/v1/{location_id}/categories/{category_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{category_id\\}", this.apiClient.escapeString(categoryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Category> localVarReturnType = new GenericType<V1Category>(){};
        CompleteResponse<V1Category> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Category> updateCategoryWithHttpInfo(String locationId, String categoryId, V1Category body) throws ApiException {
        V1Category localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateCategory");
        }
        if (categoryId == null) {
            throw new ApiException(400, "Missing the required parameter 'categoryId' when calling updateCategory");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCategory");
        }
        String localVarPath = "/v1/{location_id}/categories/{category_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{category_id\\}", this.apiClient.escapeString(categoryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Category> localVarReturnType = new GenericType<V1Category>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Discount updateDiscount(String locationId, String discountId, V1Discount body) throws ApiException {
        V1Discount localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateDiscount");
        }
        if (discountId == null) {
            throw new ApiException(400, "Missing the required parameter 'discountId' when calling updateDiscount");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDiscount");
        }
        String localVarPath = "/v1/{location_id}/discounts/{discount_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{discount_id\\}", this.apiClient.escapeString(discountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Discount> localVarReturnType = new GenericType<V1Discount>(){};
        CompleteResponse<V1Discount> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Discount> updateDiscountWithHttpInfo(String locationId, String discountId, V1Discount body) throws ApiException {
        V1Discount localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateDiscount");
        }
        if (discountId == null) {
            throw new ApiException(400, "Missing the required parameter 'discountId' when calling updateDiscount");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDiscount");
        }
        String localVarPath = "/v1/{location_id}/discounts/{discount_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{discount_id\\}", this.apiClient.escapeString(discountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Discount> localVarReturnType = new GenericType<V1Discount>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Fee updateFee(String locationId, String feeId, V1Fee body) throws ApiException {
        V1Fee localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateFee");
        }
        if (feeId == null) {
            throw new ApiException(400, "Missing the required parameter 'feeId' when calling updateFee");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateFee");
        }
        String localVarPath = "/v1/{location_id}/fees/{fee_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{fee_id\\}", this.apiClient.escapeString(feeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Fee> localVarReturnType = new GenericType<V1Fee>(){};
        CompleteResponse<V1Fee> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Fee> updateFeeWithHttpInfo(String locationId, String feeId, V1Fee body) throws ApiException {
        V1Fee localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateFee");
        }
        if (feeId == null) {
            throw new ApiException(400, "Missing the required parameter 'feeId' when calling updateFee");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateFee");
        }
        String localVarPath = "/v1/{location_id}/fees/{fee_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{fee_id\\}", this.apiClient.escapeString(feeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Fee> localVarReturnType = new GenericType<V1Fee>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Item updateItem(String locationId, String itemId, V1Item body) throws ApiException {
        V1Item localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateItem");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling updateItem");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateItem");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        CompleteResponse<V1Item> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Item> updateItemWithHttpInfo(String locationId, String itemId, V1Item body) throws ApiException {
        V1Item localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateItem");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling updateItem");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateItem");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Item> localVarReturnType = new GenericType<V1Item>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1ModifierList updateModifierList(String locationId, String modifierListId, V1UpdateModifierListRequest body) throws ApiException {
        V1UpdateModifierListRequest localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateModifierList");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling updateModifierList");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateModifierList");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists/{modifier_list_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierList> localVarReturnType = new GenericType<V1ModifierList>(){};
        CompleteResponse<V1ModifierList> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1ModifierList> updateModifierListWithHttpInfo(String locationId, String modifierListId, V1UpdateModifierListRequest body) throws ApiException {
        V1UpdateModifierListRequest localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateModifierList");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling updateModifierList");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateModifierList");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists/{modifier_list_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierList> localVarReturnType = new GenericType<V1ModifierList>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1ModifierOption updateModifierOption(String locationId, String modifierListId, String modifierOptionId, V1ModifierOption body) throws ApiException {
        V1ModifierOption localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateModifierOption");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling updateModifierOption");
        }
        if (modifierOptionId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierOptionId' when calling updateModifierOption");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateModifierOption");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists/{modifier_list_id}/modifier-options/{modifier_option_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString())).replaceAll("\\{modifier_option_id\\}", this.apiClient.escapeString(modifierOptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierOption> localVarReturnType = new GenericType<V1ModifierOption>(){};
        CompleteResponse<V1ModifierOption> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1ModifierOption> updateModifierOptionWithHttpInfo(String locationId, String modifierListId, String modifierOptionId, V1ModifierOption body) throws ApiException {
        V1ModifierOption localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateModifierOption");
        }
        if (modifierListId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierListId' when calling updateModifierOption");
        }
        if (modifierOptionId == null) {
            throw new ApiException(400, "Missing the required parameter 'modifierOptionId' when calling updateModifierOption");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateModifierOption");
        }
        String localVarPath = "/v1/{location_id}/modifier-lists/{modifier_list_id}/modifier-options/{modifier_option_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{modifier_list_id\\}", this.apiClient.escapeString(modifierListId.toString())).replaceAll("\\{modifier_option_id\\}", this.apiClient.escapeString(modifierOptionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1ModifierOption> localVarReturnType = new GenericType<V1ModifierOption>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Page updatePage(String locationId, String pageId, V1Page body) throws ApiException {
        V1Page localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updatePage");
        }
        if (pageId == null) {
            throw new ApiException(400, "Missing the required parameter 'pageId' when calling updatePage");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePage");
        }
        String localVarPath = "/v1/{location_id}/pages/{page_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Page> localVarReturnType = new GenericType<V1Page>(){};
        CompleteResponse<V1Page> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Page> updatePageWithHttpInfo(String locationId, String pageId, V1Page body) throws ApiException {
        V1Page localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updatePage");
        }
        if (pageId == null) {
            throw new ApiException(400, "Missing the required parameter 'pageId' when calling updatePage");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePage");
        }
        String localVarPath = "/v1/{location_id}/pages/{page_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Page> localVarReturnType = new GenericType<V1Page>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Page updatePageCell(String locationId, String pageId, V1PageCell body) throws ApiException {
        V1PageCell localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updatePageCell");
        }
        if (pageId == null) {
            throw new ApiException(400, "Missing the required parameter 'pageId' when calling updatePageCell");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePageCell");
        }
        String localVarPath = "/v1/{location_id}/pages/{page_id}/cells".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Page> localVarReturnType = new GenericType<V1Page>(){};
        CompleteResponse<V1Page> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Page> updatePageCellWithHttpInfo(String locationId, String pageId, V1PageCell body) throws ApiException {
        V1PageCell localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updatePageCell");
        }
        if (pageId == null) {
            throw new ApiException(400, "Missing the required parameter 'pageId' when calling updatePageCell");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePageCell");
        }
        String localVarPath = "/v1/{location_id}/pages/{page_id}/cells".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{page_id\\}", this.apiClient.escapeString(pageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Page> localVarReturnType = new GenericType<V1Page>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Variation updateVariation(String locationId, String itemId, String variationId, V1Variation body) throws ApiException {
        V1Variation localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateVariation");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling updateVariation");
        }
        if (variationId == null) {
            throw new ApiException(400, "Missing the required parameter 'variationId' when calling updateVariation");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateVariation");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/variations/{variation_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString())).replaceAll("\\{variation_id\\}", this.apiClient.escapeString(variationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Variation> localVarReturnType = new GenericType<V1Variation>(){};
        CompleteResponse<V1Variation> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Variation> updateVariationWithHttpInfo(String locationId, String itemId, String variationId, V1Variation body) throws ApiException {
        V1Variation localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateVariation");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling updateVariation");
        }
        if (variationId == null) {
            throw new ApiException(400, "Missing the required parameter 'variationId' when calling updateVariation");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateVariation");
        }
        String localVarPath = "/v1/{location_id}/items/{item_id}/variations/{variation_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString())).replaceAll("\\{variation_id\\}", this.apiClient.escapeString(variationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Variation> localVarReturnType = new GenericType<V1Variation>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

