/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents an additional recipient (other than the merchant) receiving a portion of this tender.")
public class AdditionalRecipient {
    @JsonProperty(value="location_id")
    private String locationId = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="amount_money")
    private Money amountMoney = null;
    @JsonProperty(value="receivable_id")
    private String receivableId = null;

    public AdditionalRecipient locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The location ID for a recipient (other than the merchant) receiving a portion of this tender.")
    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public AdditionalRecipient description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The description of the additional recipient.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AdditionalRecipient amountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of money distributed to the recipient.")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public AdditionalRecipient receivableId(String receivableId) {
        this.receivableId = receivableId;
        return this;
    }

    @ApiModelProperty(value="The unique ID for this [AdditionalRecipientReceivable](#type-additionalrecipientreceivable), assigned by the server.")
    public String getReceivableId() {
        return this.receivableId;
    }

    public void setReceivableId(String receivableId) {
        this.receivableId = receivableId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalRecipient additionalRecipient = (AdditionalRecipient)o;
        return Objects.equals(this.locationId, additionalRecipient.locationId) && Objects.equals(this.description, additionalRecipient.description) && Objects.equals(this.amountMoney, additionalRecipient.amountMoney) && Objects.equals(this.receivableId, additionalRecipient.receivableId);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.description, this.amountMoney, this.receivableId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdditionalRecipient {\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("    receivableId: ").append(this.toIndentedString(this.receivableId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

