/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class BatchRetrieveCatalogObjectsRequest {
    @JsonProperty(value="object_ids")
    private List<String> objectIds = new ArrayList<String>();
    @JsonProperty(value="include_related_objects")
    private Boolean includeRelatedObjects = null;

    public BatchRetrieveCatalogObjectsRequest objectIds(List<String> objectIds) {
        this.objectIds = objectIds;
        return this;
    }

    public BatchRetrieveCatalogObjectsRequest addObjectIdsItem(String objectIdsItem) {
        this.objectIds.add(objectIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The IDs of the [CatalogObject](#type-catalogobject)s to be retrieved.")
    public List<String> getObjectIds() {
        return this.objectIds;
    }

    public void setObjectIds(List<String> objectIds) {
        this.objectIds = objectIds;
    }

    public BatchRetrieveCatalogObjectsRequest includeRelatedObjects(Boolean includeRelatedObjects) {
        this.includeRelatedObjects = includeRelatedObjects;
        return this;
    }

    @ApiModelProperty(value="If `true`, the response will include additional objects that are related to the requested objects, as follows:  If the `objects` field of the response contains a [CatalogItem](#type-catalogitem), its associated [CatalogCategory](#type-catalogcategory), [CatalogTax](#type-catalogtax)es, and [CatalogModifierList](#type-catalogmodifierlist)s will be returned in the `related_objects` field of the response. If the `objects` field of the response contains a [CatalogItemVariation](#type-catalogitemvariation), its parent [CatalogItem](#type-catalogitem) will be returned in the `related_objects` field of the response.")
    public Boolean getIncludeRelatedObjects() {
        return this.includeRelatedObjects;
    }

    public void setIncludeRelatedObjects(Boolean includeRelatedObjects) {
        this.includeRelatedObjects = includeRelatedObjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchRetrieveCatalogObjectsRequest batchRetrieveCatalogObjectsRequest = (BatchRetrieveCatalogObjectsRequest)o;
        return Objects.equals(this.objectIds, batchRetrieveCatalogObjectsRequest.objectIds) && Objects.equals(this.includeRelatedObjects, batchRetrieveCatalogObjectsRequest.includeRelatedObjects);
    }

    public int hashCode() {
        return Objects.hash(this.objectIds, this.includeRelatedObjects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchRetrieveCatalogObjectsRequest {\n");
        sb.append("    objectIds: ").append(this.toIndentedString(this.objectIds)).append("\n");
        sb.append("    includeRelatedObjects: ").append(this.toIndentedString(this.includeRelatedObjects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

