/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class BatchRetrieveInventoryChangesRequest {
    @JsonProperty(value="catalog_object_ids")
    private List<String> catalogObjectIds = new ArrayList<String>();
    @JsonProperty(value="location_ids")
    private List<String> locationIds = new ArrayList<String>();
    @JsonProperty(value="types")
    private List<TypesEnum> types = new ArrayList<TypesEnum>();
    @JsonProperty(value="states")
    private List<StatesEnum> states = new ArrayList<StatesEnum>();
    @JsonProperty(value="updated_after")
    private String updatedAfter = null;
    @JsonProperty(value="updated_before")
    private String updatedBefore = null;
    @JsonProperty(value="cursor")
    private String cursor = null;

    public BatchRetrieveInventoryChangesRequest catalogObjectIds(List<String> catalogObjectIds) {
        this.catalogObjectIds = catalogObjectIds;
        return this;
    }

    public BatchRetrieveInventoryChangesRequest addCatalogObjectIdsItem(String catalogObjectIdsItem) {
        this.catalogObjectIds.add(catalogObjectIdsItem);
        return this;
    }

    @ApiModelProperty(value="Filters results by [CatalogObject](#type-catalogobject) ID. Only applied when set. Default: unset.")
    public List<String> getCatalogObjectIds() {
        return this.catalogObjectIds;
    }

    public void setCatalogObjectIds(List<String> catalogObjectIds) {
        this.catalogObjectIds = catalogObjectIds;
    }

    public BatchRetrieveInventoryChangesRequest locationIds(List<String> locationIds) {
        this.locationIds = locationIds;
        return this;
    }

    public BatchRetrieveInventoryChangesRequest addLocationIdsItem(String locationIdsItem) {
        this.locationIds.add(locationIdsItem);
        return this;
    }

    @ApiModelProperty(value="Filters results by [Location](#type-location) ID. Only applied when set. Default: unset.")
    public List<String> getLocationIds() {
        return this.locationIds;
    }

    public void setLocationIds(List<String> locationIds) {
        this.locationIds = locationIds;
    }

    public BatchRetrieveInventoryChangesRequest types(List<TypesEnum> types) {
        this.types = types;
        return this;
    }

    public BatchRetrieveInventoryChangesRequest addTypesItem(TypesEnum typesItem) {
        this.types.add(typesItem);
        return this;
    }

    @ApiModelProperty(value="Filters results by [InventoryChangeType](#type-inventorychangetype). Default: [`PHYSICAL_COUNT`, `ADJUSTMENT`]. `TRANSFER` is not supported as a filter.")
    public List<TypesEnum> getTypes() {
        return this.types;
    }

    public void setTypes(List<TypesEnum> types) {
        this.types = types;
    }

    public BatchRetrieveInventoryChangesRequest states(List<StatesEnum> states) {
        this.states = states;
        return this;
    }

    public BatchRetrieveInventoryChangesRequest addStatesItem(StatesEnum statesItem) {
        this.states.add(statesItem);
        return this;
    }

    @ApiModelProperty(value="Filters `ADJUSTMENT` query results by [InventoryState](#type-inventorystate). Only applied when set. Default: unset.")
    public List<StatesEnum> getStates() {
        return this.states;
    }

    public void setStates(List<StatesEnum> states) {
        this.states = states;
    }

    public BatchRetrieveInventoryChangesRequest updatedAfter(String updatedAfter) {
        this.updatedAfter = updatedAfter;
        return this;
    }

    @ApiModelProperty(value="Provided as an RFC 3339 timestamp. Returns results whose `created_at` or `calculated_at` value is after the given time. Default: UNIX epoch (`1970-01-01T00:00:00Z`).")
    public String getUpdatedAfter() {
        return this.updatedAfter;
    }

    public void setUpdatedAfter(String updatedAfter) {
        this.updatedAfter = updatedAfter;
    }

    public BatchRetrieveInventoryChangesRequest updatedBefore(String updatedBefore) {
        this.updatedBefore = updatedBefore;
        return this;
    }

    @ApiModelProperty(value="Provided as an RFC 3339 timestamp. Returns results whose `created_at` or `calculated_at` value is strictly before the given time. Default: UNIX epoch (`1970-01-01T00:00:00Z`).")
    public String getUpdatedBefore() {
        return this.updatedBefore;
    }

    public void setUpdatedBefore(String updatedBefore) {
        this.updatedBefore = updatedBefore;
    }

    public BatchRetrieveInventoryChangesRequest cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @ApiModelProperty(value="A pagination cursor returned by a previous call to this endpoint. Provide this to retrieve the next set of results for the original query.  See [Paginating results](#paginatingresults) for more information.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchRetrieveInventoryChangesRequest batchRetrieveInventoryChangesRequest = (BatchRetrieveInventoryChangesRequest)o;
        return Objects.equals(this.catalogObjectIds, batchRetrieveInventoryChangesRequest.catalogObjectIds) && Objects.equals(this.locationIds, batchRetrieveInventoryChangesRequest.locationIds) && Objects.equals(this.types, batchRetrieveInventoryChangesRequest.types) && Objects.equals(this.states, batchRetrieveInventoryChangesRequest.states) && Objects.equals(this.updatedAfter, batchRetrieveInventoryChangesRequest.updatedAfter) && Objects.equals(this.updatedBefore, batchRetrieveInventoryChangesRequest.updatedBefore) && Objects.equals(this.cursor, batchRetrieveInventoryChangesRequest.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.catalogObjectIds, this.locationIds, this.types, this.states, this.updatedAfter, this.updatedBefore, this.cursor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchRetrieveInventoryChangesRequest {\n");
        sb.append("    catalogObjectIds: ").append(this.toIndentedString(this.catalogObjectIds)).append("\n");
        sb.append("    locationIds: ").append(this.toIndentedString(this.locationIds)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("    states: ").append(this.toIndentedString(this.states)).append("\n");
        sb.append("    updatedAfter: ").append(this.toIndentedString(this.updatedAfter)).append("\n");
        sb.append("    updatedBefore: ").append(this.toIndentedString(this.updatedBefore)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatesEnum {
        CUSTOM("CUSTOM"),
        IN_STOCK("IN_STOCK"),
        SOLD("SOLD"),
        RETURNED_BY_CUSTOMER("RETURNED_BY_CUSTOMER"),
        RESERVED_FOR_SALE("RESERVED_FOR_SALE"),
        SOLD_ONLINE("SOLD_ONLINE"),
        ORDERED_FROM_VENDOR("ORDERED_FROM_VENDOR"),
        RECEIVED_FROM_VENDOR("RECEIVED_FROM_VENDOR"),
        IN_TRANSIT_TO("IN_TRANSIT_TO"),
        NONE("NONE"),
        WASTE("WASTE"),
        UNLINKED_RETURN("UNLINKED_RETURN");

        private String value;

        private StatesEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatesEnum fromValue(String text) {
            for (StatesEnum b : StatesEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TypesEnum {
        PHYSICAL_COUNT("PHYSICAL_COUNT"),
        ADJUSTMENT("ADJUSTMENT"),
        TRANSFER("TRANSFER");

        private String value;

        private TypesEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypesEnum fromValue(String text) {
            for (TypesEnum b : TypesEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

