/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Error;
import com.squareup.connect.models.Order;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the fields that are included in the response body of a request to the [BatchRetrieveOrders](#endpoint-batchretrieveorders) endpoint.")
public class BatchRetrieveOrdersResponse {
    @JsonProperty(value="orders")
    private List<Order> orders = new ArrayList<Order>();
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();

    public BatchRetrieveOrdersResponse orders(List<Order> orders) {
        this.orders = orders;
        return this;
    }

    public BatchRetrieveOrdersResponse addOrdersItem(Order ordersItem) {
        this.orders.add(ordersItem);
        return this;
    }

    @ApiModelProperty(value="The requested orders. This will omit any requested orders that do not exist or are not charged.")
    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public BatchRetrieveOrdersResponse errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public BatchRetrieveOrdersResponse addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Any errors that occurred during the request.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchRetrieveOrdersResponse batchRetrieveOrdersResponse = (BatchRetrieveOrdersResponse)o;
        return Objects.equals(this.orders, batchRetrieveOrdersResponse.orders) && Objects.equals(this.errors, batchRetrieveOrdersResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(this.orders, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchRetrieveOrdersResponse {\n");
        sb.append("    orders: ").append(this.toIndentedString(this.orders)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

