/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.CatalogObjectBatch;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class BatchUpsertCatalogObjectsRequest {
    @JsonProperty(value="idempotency_key")
    private String idempotencyKey = null;
    @JsonProperty(value="batches")
    private List<CatalogObjectBatch> batches = new ArrayList<CatalogObjectBatch>();

    public BatchUpsertCatalogObjectsRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="A value you specify that uniquely identifies this request among all your requests. A common way to create a valid idempotency key is to use a Universally unique identifier (UUID).  If you're unsure whether a particular request was successful, you can reattempt it with the same idempotency key without worrying about creating duplicate objects.  See [Idempotency keys](#idempotencykeys) for more information.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public BatchUpsertCatalogObjectsRequest batches(List<CatalogObjectBatch> batches) {
        this.batches = batches;
        return this;
    }

    public BatchUpsertCatalogObjectsRequest addBatchesItem(CatalogObjectBatch batchesItem) {
        this.batches.add(batchesItem);
        return this;
    }

    @ApiModelProperty(value="A batch of [CatalogObject](#type-catalogobject)s to be inserted/updated atomically. The objects within a batch will be inserted in an all-or-nothing fashion, i.e., if an error occurs attempting to insert or update an object within a batch, the entire batch will be rejected. However, an error in one batch will not affect other batches within the same request.  For each object, its `updated_at` field is ignored and replaced with a current [timestamp](#workingwithdates), and its `is_deleted` field must not be set to `true`.  To modify an existing object, supply its ID. To create a new object, use an ID starting with `#`. These IDs may be used to create relationships between an object and attributes of other objects that reference it. For example, you can create a [CatalogItem](#type-catalogitem) with ID `#ABC` and a [CatalogItemVariation](#type-catalogitemvariation) with its `item_id` attribute set to `#ABC` in order to associate the [CatalogItemVariation](#type-catalogitemvariation) with its parent [CatalogItem](#type-catalogitem).  Any `#`-prefixed IDs are valid only within a single atomic batch, and will be replaced by server-generated IDs.  Each batch may contain up to 1,000 objects. The total number of objects across all batches for a single request may not exceed 10,000. If either of these limits is violated, an error will be returned and no objects will be inserted or updated.")
    public List<CatalogObjectBatch> getBatches() {
        return this.batches;
    }

    public void setBatches(List<CatalogObjectBatch> batches) {
        this.batches = batches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchUpsertCatalogObjectsRequest batchUpsertCatalogObjectsRequest = (BatchUpsertCatalogObjectsRequest)o;
        return Objects.equals(this.idempotencyKey, batchUpsertCatalogObjectsRequest.idempotencyKey) && Objects.equals(this.batches, batchUpsertCatalogObjectsRequest.batches);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.batches);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchUpsertCatalogObjectsRequest {\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    batches: ").append(this.toIndentedString(this.batches)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

