/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A discount in the Catalog object model.")
public class CatalogDiscount {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="discount_type")
    private DiscountTypeEnum discountType = null;
    @JsonProperty(value="percentage")
    private String percentage = null;
    @JsonProperty(value="amount_money")
    private Money amountMoney = null;
    @JsonProperty(value="pin_required")
    private Boolean pinRequired = null;
    @JsonProperty(value="label_color")
    private String labelColor = null;

    public CatalogDiscount name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The discount's name. Searchable.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CatalogDiscount discountType(DiscountTypeEnum discountType) {
        this.discountType = discountType;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the discount is a fixed amount or percentage, or entered at the time of sale. See [CatalogDiscountType](#type-catalogdiscounttype) for all possible values.")
    public DiscountTypeEnum getDiscountType() {
        return this.discountType;
    }

    public void setDiscountType(DiscountTypeEnum discountType) {
        this.discountType = discountType;
    }

    public CatalogDiscount percentage(String percentage) {
        this.percentage = percentage;
        return this;
    }

    @ApiModelProperty(value="The percentage of the discount as a string representation of a decimal number, using a `.` as the decimal separator and without a `%` sign. A value of `7.5` corresponds to `7.5%`. Specify a percentage of `0` if `discount_type` is `VARIABLE_PERCENTAGE`.  Do not include this field for amount-based or variable discounts.")
    public String getPercentage() {
        return this.percentage;
    }

    public void setPercentage(String percentage) {
        this.percentage = percentage;
    }

    public CatalogDiscount amountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of the discount. Specify an amount of `0` if `discount_type` is `VARIABLE_AMOUNT`.  Do not include this field for percentage-based or variable discounts.")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public CatalogDiscount pinRequired(Boolean pinRequired) {
        this.pinRequired = pinRequired;
        return this;
    }

    @ApiModelProperty(value="Indicates whether a mobile staff member needs to enter their PIN to apply the discount to a payment in the Square Point of Sale app.")
    public Boolean getPinRequired() {
        return this.pinRequired;
    }

    public void setPinRequired(Boolean pinRequired) {
        this.pinRequired = pinRequired;
    }

    public CatalogDiscount labelColor(String labelColor) {
        this.labelColor = labelColor;
        return this;
    }

    @ApiModelProperty(value="The color of the discount's display label in the Square Point of Sale app.")
    public String getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(String labelColor) {
        this.labelColor = labelColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogDiscount catalogDiscount = (CatalogDiscount)o;
        return Objects.equals(this.name, catalogDiscount.name) && Objects.equals((Object)this.discountType, (Object)catalogDiscount.discountType) && Objects.equals(this.percentage, catalogDiscount.percentage) && Objects.equals(this.amountMoney, catalogDiscount.amountMoney) && Objects.equals(this.pinRequired, catalogDiscount.pinRequired) && Objects.equals(this.labelColor, catalogDiscount.labelColor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.discountType, this.percentage, this.amountMoney, this.pinRequired, this.labelColor});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogDiscount {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    discountType: ").append(this.toIndentedString((Object)this.discountType)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("    pinRequired: ").append(this.toIndentedString(this.pinRequired)).append("\n");
        sb.append("    labelColor: ").append(this.toIndentedString(this.labelColor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DiscountTypeEnum {
        FIXED_PERCENTAGE("FIXED_PERCENTAGE"),
        FIXED_AMOUNT("FIXED_AMOUNT"),
        VARIABLE_PERCENTAGE("VARIABLE_PERCENTAGE"),
        VARIABLE_AMOUNT("VARIABLE_AMOUNT");

        private String value;

        private DiscountTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DiscountTypeEnum fromValue(String text) {
            for (DiscountTypeEnum b : DiscountTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

