/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.CatalogModifierOverride;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Controls the properties of a [CatalogModifierList](#type-catalogmodifierlist) as it applies to this [CatalogItem](#type-catalogitem).")
public class CatalogItemModifierListInfo {
    @JsonProperty(value="modifier_list_id")
    private String modifierListId = null;
    @JsonProperty(value="modifier_overrides")
    private List<CatalogModifierOverride> modifierOverrides = new ArrayList<CatalogModifierOverride>();
    @JsonProperty(value="min_selected_modifiers")
    private Integer minSelectedModifiers = null;
    @JsonProperty(value="max_selected_modifiers")
    private Integer maxSelectedModifiers = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;

    public CatalogItemModifierListInfo modifierListId(String modifierListId) {
        this.modifierListId = modifierListId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the [CatalogModifierList](#type-catalogmodifierlist) controlled by this [CatalogModifierListInfo](#type-catalogmodifierlistinfo).")
    public String getModifierListId() {
        return this.modifierListId;
    }

    public void setModifierListId(String modifierListId) {
        this.modifierListId = modifierListId;
    }

    public CatalogItemModifierListInfo modifierOverrides(List<CatalogModifierOverride> modifierOverrides) {
        this.modifierOverrides = modifierOverrides;
        return this;
    }

    public CatalogItemModifierListInfo addModifierOverridesItem(CatalogModifierOverride modifierOverridesItem) {
        this.modifierOverrides.add(modifierOverridesItem);
        return this;
    }

    @ApiModelProperty(value="A set of [CatalogModifierOverride](#type-catalogmodifieroverride) objects that override whether a given [CatalogModifier](#type-catalogmodifier) is enabled by default.")
    public List<CatalogModifierOverride> getModifierOverrides() {
        return this.modifierOverrides;
    }

    public void setModifierOverrides(List<CatalogModifierOverride> modifierOverrides) {
        this.modifierOverrides = modifierOverrides;
    }

    public CatalogItemModifierListInfo minSelectedModifiers(Integer minSelectedModifiers) {
        this.minSelectedModifiers = minSelectedModifiers;
        return this;
    }

    @ApiModelProperty(value="If zero or larger, the smallest number of [CatalogModifier](#type-catalogmodifier)s that must be selected from this [CatalogModifierList](#type-catalogmodifierlist).")
    public Integer getMinSelectedModifiers() {
        return this.minSelectedModifiers;
    }

    public void setMinSelectedModifiers(Integer minSelectedModifiers) {
        this.minSelectedModifiers = minSelectedModifiers;
    }

    public CatalogItemModifierListInfo maxSelectedModifiers(Integer maxSelectedModifiers) {
        this.maxSelectedModifiers = maxSelectedModifiers;
        return this;
    }

    @ApiModelProperty(value="If zero or larger, the largest number of [CatalogModifier](#type-catalogmodifier)s that can be selected from this [CatalogModifierList](#type-catalogmodifierlist).")
    public Integer getMaxSelectedModifiers() {
        return this.maxSelectedModifiers;
    }

    public void setMaxSelectedModifiers(Integer maxSelectedModifiers) {
        this.maxSelectedModifiers = maxSelectedModifiers;
    }

    public CatalogItemModifierListInfo enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="If `true`, enable this [CatalogModifierList](#type-catalogmodifierlist).")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogItemModifierListInfo catalogItemModifierListInfo = (CatalogItemModifierListInfo)o;
        return Objects.equals(this.modifierListId, catalogItemModifierListInfo.modifierListId) && Objects.equals(this.modifierOverrides, catalogItemModifierListInfo.modifierOverrides) && Objects.equals(this.minSelectedModifiers, catalogItemModifierListInfo.minSelectedModifiers) && Objects.equals(this.maxSelectedModifiers, catalogItemModifierListInfo.maxSelectedModifiers) && Objects.equals(this.enabled, catalogItemModifierListInfo.enabled);
    }

    public int hashCode() {
        return Objects.hash(this.modifierListId, this.modifierOverrides, this.minSelectedModifiers, this.maxSelectedModifiers, this.enabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogItemModifierListInfo {\n");
        sb.append("    modifierListId: ").append(this.toIndentedString(this.modifierListId)).append("\n");
        sb.append("    modifierOverrides: ").append(this.toIndentedString(this.modifierOverrides)).append("\n");
        sb.append("    minSelectedModifiers: ").append(this.toIndentedString(this.minSelectedModifiers)).append("\n");
        sb.append("    maxSelectedModifiers: ").append(this.toIndentedString(this.maxSelectedModifiers)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

