/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.ItemVariationLocationOverrides;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="An item variation (i.e., product) in the Catalog object model.")
public class CatalogItemVariation {
    @JsonProperty(value="item_id")
    private String itemId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="sku")
    private String sku = null;
    @JsonProperty(value="upc")
    private String upc = null;
    @JsonProperty(value="ordinal")
    private Integer ordinal = null;
    @JsonProperty(value="pricing_type")
    private PricingTypeEnum pricingType = null;
    @JsonProperty(value="price_money")
    private Money priceMoney = null;
    @JsonProperty(value="location_overrides")
    private List<ItemVariationLocationOverrides> locationOverrides = new ArrayList<ItemVariationLocationOverrides>();
    @JsonProperty(value="track_inventory")
    private Boolean trackInventory = null;
    @JsonProperty(value="inventory_alert_type")
    private InventoryAlertTypeEnum inventoryAlertType = null;
    @JsonProperty(value="inventory_alert_threshold")
    private Long inventoryAlertThreshold = null;
    @JsonProperty(value="user_data")
    private String userData = null;
    @JsonProperty(value="service_duration")
    private Long serviceDuration = null;

    public CatalogItemVariation itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(value="The ID of the [CatalogItem](#type-catalogitem) associated with this item variation. Searchable.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public CatalogItemVariation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The item variation's name. Searchable.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CatalogItemVariation sku(String sku) {
        this.sku = sku;
        return this;
    }

    @ApiModelProperty(value="The item variation's SKU, if any. Searchable.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public CatalogItemVariation upc(String upc) {
        this.upc = upc;
        return this;
    }

    @ApiModelProperty(value="The item variation's UPC, if any. Searchable in the Connect API. This field is only exposed in the Connect API. It is not exposed in Square's Dashboard, Square Point of Sale app or Retail Point of Sale app.")
    public String getUpc() {
        return this.upc;
    }

    public void setUpc(String upc) {
        this.upc = upc;
    }

    public CatalogItemVariation ordinal(Integer ordinal) {
        this.ordinal = ordinal;
        return this;
    }

    @ApiModelProperty(value="The order in which this item variation should be displayed. This value is read-only. On writes, the ordinal for each item variation within a parent [CatalogItem](#type-catalogitem) is set according to the item variations's position. On reads, the value is not guaranteed to be sequential or unique.")
    public Integer getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    public CatalogItemVariation pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the item variation's price is fixed or determined at the time of sale. See [CatalogPricingType](#type-catalogpricingtype) for all possible values.")
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public CatalogItemVariation priceMoney(Money priceMoney) {
        this.priceMoney = priceMoney;
        return this;
    }

    @ApiModelProperty(value="The item variation's price, if fixed pricing is used.")
    public Money getPriceMoney() {
        return this.priceMoney;
    }

    public void setPriceMoney(Money priceMoney) {
        this.priceMoney = priceMoney;
    }

    public CatalogItemVariation locationOverrides(List<ItemVariationLocationOverrides> locationOverrides) {
        this.locationOverrides = locationOverrides;
        return this;
    }

    public CatalogItemVariation addLocationOverridesItem(ItemVariationLocationOverrides locationOverridesItem) {
        this.locationOverrides.add(locationOverridesItem);
        return this;
    }

    @ApiModelProperty(value="Per-[location](#type-location) price and inventory overrides.")
    public List<ItemVariationLocationOverrides> getLocationOverrides() {
        return this.locationOverrides;
    }

    public void setLocationOverrides(List<ItemVariationLocationOverrides> locationOverrides) {
        this.locationOverrides = locationOverrides;
    }

    public CatalogItemVariation trackInventory(Boolean trackInventory) {
        this.trackInventory = trackInventory;
        return this;
    }

    @ApiModelProperty(value="If `true`, inventory tracking is active for the variation.")
    public Boolean getTrackInventory() {
        return this.trackInventory;
    }

    public void setTrackInventory(Boolean trackInventory) {
        this.trackInventory = trackInventory;
    }

    public CatalogItemVariation inventoryAlertType(InventoryAlertTypeEnum inventoryAlertType) {
        this.inventoryAlertType = inventoryAlertType;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the item variation displays an alert when its inventory quantity is less than or equal to its `inventory_alert_threshold`. See [InventoryAlertType](#type-inventoryalerttype) for all possible values.")
    public InventoryAlertTypeEnum getInventoryAlertType() {
        return this.inventoryAlertType;
    }

    public void setInventoryAlertType(InventoryAlertTypeEnum inventoryAlertType) {
        this.inventoryAlertType = inventoryAlertType;
    }

    public CatalogItemVariation inventoryAlertThreshold(Long inventoryAlertThreshold) {
        this.inventoryAlertThreshold = inventoryAlertThreshold;
        return this;
    }

    @ApiModelProperty(value="If the inventory quantity for the variation is less than or equal to this value and `inventory_alert_type` is `LOW_QUANTITY`, the variation displays an alert in the merchant dashboard.  This value is always an integer.")
    public Long getInventoryAlertThreshold() {
        return this.inventoryAlertThreshold;
    }

    public void setInventoryAlertThreshold(Long inventoryAlertThreshold) {
        this.inventoryAlertThreshold = inventoryAlertThreshold;
    }

    public CatalogItemVariation userData(String userData) {
        this.userData = userData;
        return this;
    }

    @ApiModelProperty(value="Arbitrary user metadata to associate with the item variation. Cannot exceed 255 characters. Searchable.")
    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public CatalogItemVariation serviceDuration(Long serviceDuration) {
        this.serviceDuration = serviceDuration;
        return this;
    }

    @ApiModelProperty(value="If the [CatalogItem](#type-catalogitem) that owns this item variation is of type `APPOINTMENTS_SERVICE`, then this is the duration of the service in milliseconds. For example, a 30 minute appointment would have the value `1800000`, which is equal to 30 (minutes) * 60 (seconds per minute) * 1000 (milliseconds per second).")
    public Long getServiceDuration() {
        return this.serviceDuration;
    }

    public void setServiceDuration(Long serviceDuration) {
        this.serviceDuration = serviceDuration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogItemVariation catalogItemVariation = (CatalogItemVariation)o;
        return Objects.equals(this.itemId, catalogItemVariation.itemId) && Objects.equals(this.name, catalogItemVariation.name) && Objects.equals(this.sku, catalogItemVariation.sku) && Objects.equals(this.upc, catalogItemVariation.upc) && Objects.equals(this.ordinal, catalogItemVariation.ordinal) && Objects.equals((Object)this.pricingType, (Object)catalogItemVariation.pricingType) && Objects.equals(this.priceMoney, catalogItemVariation.priceMoney) && Objects.equals(this.locationOverrides, catalogItemVariation.locationOverrides) && Objects.equals(this.trackInventory, catalogItemVariation.trackInventory) && Objects.equals((Object)this.inventoryAlertType, (Object)catalogItemVariation.inventoryAlertType) && Objects.equals(this.inventoryAlertThreshold, catalogItemVariation.inventoryAlertThreshold) && Objects.equals(this.userData, catalogItemVariation.userData) && Objects.equals(this.serviceDuration, catalogItemVariation.serviceDuration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.itemId, this.name, this.sku, this.upc, this.ordinal, this.pricingType, this.priceMoney, this.locationOverrides, this.trackInventory, this.inventoryAlertType, this.inventoryAlertThreshold, this.userData, this.serviceDuration});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogItemVariation {\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    upc: ").append(this.toIndentedString(this.upc)).append("\n");
        sb.append("    ordinal: ").append(this.toIndentedString(this.ordinal)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    priceMoney: ").append(this.toIndentedString(this.priceMoney)).append("\n");
        sb.append("    locationOverrides: ").append(this.toIndentedString(this.locationOverrides)).append("\n");
        sb.append("    trackInventory: ").append(this.toIndentedString(this.trackInventory)).append("\n");
        sb.append("    inventoryAlertType: ").append(this.toIndentedString((Object)this.inventoryAlertType)).append("\n");
        sb.append("    inventoryAlertThreshold: ").append(this.toIndentedString(this.inventoryAlertThreshold)).append("\n");
        sb.append("    userData: ").append(this.toIndentedString(this.userData)).append("\n");
        sb.append("    serviceDuration: ").append(this.toIndentedString(this.serviceDuration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InventoryAlertTypeEnum {
        NONE("NONE"),
        LOW_QUANTITY("LOW_QUANTITY");

        private String value;

        private InventoryAlertTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InventoryAlertTypeEnum fromValue(String text) {
            for (InventoryAlertTypeEnum b : InventoryAlertTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum PricingTypeEnum {
        FIXED_PRICING("FIXED_PRICING"),
        VARIABLE_PRICING("VARIABLE_PRICING");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String text) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

