/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.CatalogCategory;
import com.squareup.connect.models.CatalogDiscount;
import com.squareup.connect.models.CatalogItem;
import com.squareup.connect.models.CatalogItemVariation;
import com.squareup.connect.models.CatalogModifier;
import com.squareup.connect.models.CatalogModifierList;
import com.squareup.connect.models.CatalogTax;
import com.squareup.connect.models.CatalogV1Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The wrapper object for object types in the Catalog data model. The type of a particular `CatalogObject` is determined by the value of `type` and only the corresponding data field may be set.  - if type = `ITEM`, only `item_data` will be populated and it will contain a valid [CatalogItem](#type-catalogitem) object. - if type = `ITEM_VARIATION`, only `item_variation_data` will be populated and it will contain a valid [CatalogItemVariation](#type-catalogitemvariation) object. - if type = `MODIFIER`, only `modifier_data` will be populated and it will contain a valid [CatalogModifier](#type-catalogmodifier) object. - if type = `MODIFIER_LIST`, only `modifier_list_data` will be populated and it will contain a valid [CatalogModifierList](#type-catalogmodifierlist) object. - if type = `CATEGORY`, only `category_data` will be populated and it will contain a valid [CatalogCategory](#type-catalogcategory) object. - if type = `DISCOUNT`, only `discount_data` will be populated and it will contain a valid [CatalogDiscount](#type-catalogdiscount) object. - if type = `TAX`, only `tax_data` will be populated and it will contain a valid [CatalogTax](#type-catalogtax) object.  For a more detailed discussion of the Catalog data model, please see the [Catalog Overview](/products/catalog/overview).")
public class CatalogObject {
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="updated_at")
    private String updatedAt = null;
    @JsonProperty(value="version")
    private Long version = null;
    @JsonProperty(value="is_deleted")
    private Boolean isDeleted = null;
    @JsonProperty(value="catalog_v1_ids")
    private List<CatalogV1Id> catalogV1Ids = new ArrayList<CatalogV1Id>();
    @JsonProperty(value="present_at_all_locations")
    private Boolean presentAtAllLocations = null;
    @JsonProperty(value="present_at_location_ids")
    private List<String> presentAtLocationIds = new ArrayList<String>();
    @JsonProperty(value="absent_at_location_ids")
    private List<String> absentAtLocationIds = new ArrayList<String>();
    @JsonProperty(value="item_data")
    private CatalogItem itemData = null;
    @JsonProperty(value="category_data")
    private CatalogCategory categoryData = null;
    @JsonProperty(value="item_variation_data")
    private CatalogItemVariation itemVariationData = null;
    @JsonProperty(value="tax_data")
    private CatalogTax taxData = null;
    @JsonProperty(value="discount_data")
    private CatalogDiscount discountData = null;
    @JsonProperty(value="modifier_list_data")
    private CatalogModifierList modifierListData = null;
    @JsonProperty(value="modifier_data")
    private CatalogModifier modifierData = null;

    public CatalogObject type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of this object. Each object type has expected properties expressed in a structured format within its corresponding `*_data` field below.  See [CatalogObjectType](#type-catalogobjecttype) for all possible values.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CatalogObject id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="An identifier to reference this object in the catalog. When a new CatalogObject is inserted, the client should set the id to a temporary identifier starting with a `'#'` character. Other objects being inserted or updated within the same request may use this identifier to refer to the new object.  When the server receives the new object, it will supply a unique identifier that replaces the temporary identifier for all future references.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CatalogObject updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="Last modification [timestamp](#workingwithdates) in RFC 3339 format, e.g., `\"2016-08-15T23:59:33.123Z\"` would indicate the UTC time (denoted by `Z`) of August 15, 2016 at 23:59:33 and 123 milliseconds.")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public CatalogObject version(Long version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="The version of the object. When updating an object, the version supplied by the must match the version in the database, otherwise the write will be rejected as conflicting.")
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public CatalogObject isDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        return this;
    }

    @ApiModelProperty(value="If `true`, the object has been deleted from the database. Must be `false` for new objects being inserted. When deleted, the `updated_at` field will equal the deletion time.")
    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public CatalogObject catalogV1Ids(List<CatalogV1Id> catalogV1Ids) {
        this.catalogV1Ids = catalogV1Ids;
        return this;
    }

    public CatalogObject addCatalogV1IdsItem(CatalogV1Id catalogV1IdsItem) {
        this.catalogV1Ids.add(catalogV1IdsItem);
        return this;
    }

    @ApiModelProperty(value="The Connect V1 IDs for this object at each [location](#type-location) where it is present, where they differ from the object's Connect V2 ID. The field will only be present for objects that have been created or modified by legacy APIs.")
    public List<CatalogV1Id> getCatalogV1Ids() {
        return this.catalogV1Ids;
    }

    public void setCatalogV1Ids(List<CatalogV1Id> catalogV1Ids) {
        this.catalogV1Ids = catalogV1Ids;
    }

    public CatalogObject presentAtAllLocations(Boolean presentAtAllLocations) {
        this.presentAtAllLocations = presentAtAllLocations;
        return this;
    }

    @ApiModelProperty(value="If `true`, this object is present at all locations (including future locations), except where specified in the `absent_at_location_ids` field. If `false`, this object is not present at any locations (including future locations), except where specified in the `present_at_location_ids` field. If not specified, defaults to `true`.")
    public Boolean getPresentAtAllLocations() {
        return this.presentAtAllLocations;
    }

    public void setPresentAtAllLocations(Boolean presentAtAllLocations) {
        this.presentAtAllLocations = presentAtAllLocations;
    }

    public CatalogObject presentAtLocationIds(List<String> presentAtLocationIds) {
        this.presentAtLocationIds = presentAtLocationIds;
        return this;
    }

    public CatalogObject addPresentAtLocationIdsItem(String presentAtLocationIdsItem) {
        this.presentAtLocationIds.add(presentAtLocationIdsItem);
        return this;
    }

    @ApiModelProperty(value="A list of locations where the object is present, even if `present_at_all_locations` is `false`.")
    public List<String> getPresentAtLocationIds() {
        return this.presentAtLocationIds;
    }

    public void setPresentAtLocationIds(List<String> presentAtLocationIds) {
        this.presentAtLocationIds = presentAtLocationIds;
    }

    public CatalogObject absentAtLocationIds(List<String> absentAtLocationIds) {
        this.absentAtLocationIds = absentAtLocationIds;
        return this;
    }

    public CatalogObject addAbsentAtLocationIdsItem(String absentAtLocationIdsItem) {
        this.absentAtLocationIds.add(absentAtLocationIdsItem);
        return this;
    }

    @ApiModelProperty(value="A list of locations where the object is not present, even if `present_at_all_locations` is `true`.")
    public List<String> getAbsentAtLocationIds() {
        return this.absentAtLocationIds;
    }

    public void setAbsentAtLocationIds(List<String> absentAtLocationIds) {
        this.absentAtLocationIds = absentAtLocationIds;
    }

    public CatalogObject itemData(CatalogItem itemData) {
        this.itemData = itemData;
        return this;
    }

    @ApiModelProperty(value="Structured data for a [CatalogItem](#type-catalogitem), set for CatalogObjects of type `ITEM`.")
    public CatalogItem getItemData() {
        return this.itemData;
    }

    public void setItemData(CatalogItem itemData) {
        this.itemData = itemData;
    }

    public CatalogObject categoryData(CatalogCategory categoryData) {
        this.categoryData = categoryData;
        return this;
    }

    @ApiModelProperty(value="Structured data for a [CatalogCategory](#type-catalogcategory), set for CatalogObjects of type `CATEGORY`.")
    public CatalogCategory getCategoryData() {
        return this.categoryData;
    }

    public void setCategoryData(CatalogCategory categoryData) {
        this.categoryData = categoryData;
    }

    public CatalogObject itemVariationData(CatalogItemVariation itemVariationData) {
        this.itemVariationData = itemVariationData;
        return this;
    }

    @ApiModelProperty(value="Structured data for a [CatalogItemVariation](#type-catalogitemvariation), set for CatalogObjects of type `ITEM_VARIATION`.")
    public CatalogItemVariation getItemVariationData() {
        return this.itemVariationData;
    }

    public void setItemVariationData(CatalogItemVariation itemVariationData) {
        this.itemVariationData = itemVariationData;
    }

    public CatalogObject taxData(CatalogTax taxData) {
        this.taxData = taxData;
        return this;
    }

    @ApiModelProperty(value="Structured data for a [CatalogTax](#type-catalogtax), set for CatalogObjects of type `TAX`.")
    public CatalogTax getTaxData() {
        return this.taxData;
    }

    public void setTaxData(CatalogTax taxData) {
        this.taxData = taxData;
    }

    public CatalogObject discountData(CatalogDiscount discountData) {
        this.discountData = discountData;
        return this;
    }

    @ApiModelProperty(value="Structured data for a [CatalogDiscount](#type-catalogdiscount), set for CatalogObjects of type `DISCOUNT`.")
    public CatalogDiscount getDiscountData() {
        return this.discountData;
    }

    public void setDiscountData(CatalogDiscount discountData) {
        this.discountData = discountData;
    }

    public CatalogObject modifierListData(CatalogModifierList modifierListData) {
        this.modifierListData = modifierListData;
        return this;
    }

    @ApiModelProperty(value="Structured data for a [CatalogModifierList](#type-catalogmodifierlist), set for CatalogObjects of type `MODIFIER_LIST`.")
    public CatalogModifierList getModifierListData() {
        return this.modifierListData;
    }

    public void setModifierListData(CatalogModifierList modifierListData) {
        this.modifierListData = modifierListData;
    }

    public CatalogObject modifierData(CatalogModifier modifierData) {
        this.modifierData = modifierData;
        return this;
    }

    @ApiModelProperty(value="Structured data for a [CatalogModifier](#type-catalogmodifier), set for CatalogObjects of type `MODIFIER`.")
    public CatalogModifier getModifierData() {
        return this.modifierData;
    }

    public void setModifierData(CatalogModifier modifierData) {
        this.modifierData = modifierData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogObject catalogObject = (CatalogObject)o;
        return Objects.equals((Object)this.type, (Object)catalogObject.type) && Objects.equals(this.id, catalogObject.id) && Objects.equals(this.updatedAt, catalogObject.updatedAt) && Objects.equals(this.version, catalogObject.version) && Objects.equals(this.isDeleted, catalogObject.isDeleted) && Objects.equals(this.catalogV1Ids, catalogObject.catalogV1Ids) && Objects.equals(this.presentAtAllLocations, catalogObject.presentAtAllLocations) && Objects.equals(this.presentAtLocationIds, catalogObject.presentAtLocationIds) && Objects.equals(this.absentAtLocationIds, catalogObject.absentAtLocationIds) && Objects.equals(this.itemData, catalogObject.itemData) && Objects.equals(this.categoryData, catalogObject.categoryData) && Objects.equals(this.itemVariationData, catalogObject.itemVariationData) && Objects.equals(this.taxData, catalogObject.taxData) && Objects.equals(this.discountData, catalogObject.discountData) && Objects.equals(this.modifierListData, catalogObject.modifierListData) && Objects.equals(this.modifierData, catalogObject.modifierData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.updatedAt, this.version, this.isDeleted, this.catalogV1Ids, this.presentAtAllLocations, this.presentAtLocationIds, this.absentAtLocationIds, this.itemData, this.categoryData, this.itemVariationData, this.taxData, this.discountData, this.modifierListData, this.modifierData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogObject {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    isDeleted: ").append(this.toIndentedString(this.isDeleted)).append("\n");
        sb.append("    catalogV1Ids: ").append(this.toIndentedString(this.catalogV1Ids)).append("\n");
        sb.append("    presentAtAllLocations: ").append(this.toIndentedString(this.presentAtAllLocations)).append("\n");
        sb.append("    presentAtLocationIds: ").append(this.toIndentedString(this.presentAtLocationIds)).append("\n");
        sb.append("    absentAtLocationIds: ").append(this.toIndentedString(this.absentAtLocationIds)).append("\n");
        sb.append("    itemData: ").append(this.toIndentedString(this.itemData)).append("\n");
        sb.append("    categoryData: ").append(this.toIndentedString(this.categoryData)).append("\n");
        sb.append("    itemVariationData: ").append(this.toIndentedString(this.itemVariationData)).append("\n");
        sb.append("    taxData: ").append(this.toIndentedString(this.taxData)).append("\n");
        sb.append("    discountData: ").append(this.toIndentedString(this.discountData)).append("\n");
        sb.append("    modifierListData: ").append(this.toIndentedString(this.modifierListData)).append("\n");
        sb.append("    modifierData: ").append(this.toIndentedString(this.modifierData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ITEM("ITEM"),
        CATEGORY("CATEGORY"),
        ITEM_VARIATION("ITEM_VARIATION"),
        TAX("TAX"),
        DISCOUNT("DISCOUNT"),
        MODIFIER_LIST("MODIFIER_LIST"),
        MODIFIER("MODIFIER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

