/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="")
public class CatalogQuerySortedAttribute {
    @JsonProperty(value="attribute_name")
    private String attributeName = null;
    @JsonProperty(value="initial_attribute_value")
    private String initialAttributeValue = null;
    @JsonProperty(value="sort_order")
    private SortOrderEnum sortOrder = null;

    public CatalogQuerySortedAttribute attributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    @ApiModelProperty(required=true, value="The attribute whose value should be used as the sort key.")
    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public CatalogQuerySortedAttribute initialAttributeValue(String initialAttributeValue) {
        this.initialAttributeValue = initialAttributeValue;
        return this;
    }

    @ApiModelProperty(value="The first attribute value to be returned by the query. Ascending sorts will return only objects with this value or greater, while descending sorts will return only objects with this value or less. If unset, start at the beginning (for ascending sorts) or end (for descending sorts).")
    public String getInitialAttributeValue() {
        return this.initialAttributeValue;
    }

    public void setInitialAttributeValue(String initialAttributeValue) {
        this.initialAttributeValue = initialAttributeValue;
    }

    public CatalogQuerySortedAttribute sortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(value="The desired [SortOrder](#type-sortorder), `\"ASC\"` (ascending) or `\"DESC\"` (descending).")
    public SortOrderEnum getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogQuerySortedAttribute catalogQuerySortedAttribute = (CatalogQuerySortedAttribute)o;
        return Objects.equals(this.attributeName, catalogQuerySortedAttribute.attributeName) && Objects.equals(this.initialAttributeValue, catalogQuerySortedAttribute.initialAttributeValue) && Objects.equals((Object)this.sortOrder, (Object)catalogQuerySortedAttribute.sortOrder);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributeName, this.initialAttributeValue, this.sortOrder});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogQuerySortedAttribute {\n");
        sb.append("    attributeName: ").append(this.toIndentedString(this.attributeName)).append("\n");
        sb.append("    initialAttributeValue: ").append(this.toIndentedString(this.initialAttributeValue)).append("\n");
        sb.append("    sortOrder: ").append(this.toIndentedString((Object)this.sortOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SortOrderEnum {
        DESC("DESC"),
        ASC("ASC");

        private String value;

        private SortOrderEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SortOrderEnum fromValue(String text) {
            for (SortOrderEnum b : SortOrderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

