/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.AdditionalRecipient;
import com.squareup.connect.models.Address;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the parameters that can be included in the body of a request to the [Charge](#endpoint-charge) endpoint.")
public class ChargeRequest {
    @JsonProperty(value="idempotency_key")
    private String idempotencyKey = null;
    @JsonProperty(value="amount_money")
    private Money amountMoney = null;
    @JsonProperty(value="card_nonce")
    private String cardNonce = null;
    @JsonProperty(value="customer_card_id")
    private String customerCardId = null;
    @JsonProperty(value="delay_capture")
    private Boolean delayCapture = null;
    @JsonProperty(value="reference_id")
    private String referenceId = null;
    @JsonProperty(value="note")
    private String note = null;
    @JsonProperty(value="customer_id")
    private String customerId = null;
    @JsonProperty(value="billing_address")
    private Address billingAddress = null;
    @JsonProperty(value="shipping_address")
    private Address shippingAddress = null;
    @JsonProperty(value="buyer_email_address")
    private String buyerEmailAddress = null;
    @JsonProperty(value="order_id")
    private String orderId = null;
    @JsonProperty(value="additional_recipients")
    private List<AdditionalRecipient> additionalRecipients = new ArrayList<AdditionalRecipient>();

    public ChargeRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="A value you specify that uniquely identifies this transaction among transactions you've created.  If you're unsure whether a particular transaction succeeded, you can reattempt it with the same idempotency key without worrying about double-charging the buyer.  See [Idempotency keys](#idempotencykeys) for more information.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public ChargeRequest amountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of money to charge.  Note that you specify the amount in the __smallest denomination of the applicable currency__. For example, US dollar amounts are specified in cents. See [Working with monetary amounts](#workingwithmonetaryamounts) for details.  The value of `currency` must match the currency associated with the business that is charging the card.")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public ChargeRequest cardNonce(String cardNonce) {
        this.cardNonce = cardNonce;
        return this;
    }

    @ApiModelProperty(value="A nonce generated from the `SqPaymentForm` that represents the card to charge.  The application that provides a nonce to this endpoint must be the _same application_ that generated the nonce with the `SqPaymentForm`. Otherwise, the nonce is invalid.  Do not provide a value for this field if you provide a value for `customer_card_id`.")
    public String getCardNonce() {
        return this.cardNonce;
    }

    public void setCardNonce(String cardNonce) {
        this.cardNonce = cardNonce;
    }

    public ChargeRequest customerCardId(String customerCardId) {
        this.customerCardId = customerCardId;
        return this;
    }

    @ApiModelProperty(value="The ID of the customer card on file to charge. Do not provide a value for this field if you provide a value for `card_nonce`.  If you provide this value, you _must_ also provide a value for `customer_id`.")
    public String getCustomerCardId() {
        return this.customerCardId;
    }

    public void setCustomerCardId(String customerCardId) {
        this.customerCardId = customerCardId;
    }

    public ChargeRequest delayCapture(Boolean delayCapture) {
        this.delayCapture = delayCapture;
        return this;
    }

    @ApiModelProperty(value="If `true`, the request will only perform an Auth on the provided card. You can then later perform either a Capture (with the [CaptureTransaction](#endpoint-capturetransaction) endpoint) or a Void (with the [VoidTransaction](#endpoint-voidtransaction) endpoint).  Default value: `false`")
    public Boolean getDelayCapture() {
        return this.delayCapture;
    }

    public void setDelayCapture(Boolean delayCapture) {
        this.delayCapture = delayCapture;
    }

    public ChargeRequest referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @ApiModelProperty(value="An optional ID you can associate with the transaction for your own purposes (such as to associate the transaction with an entity ID in your own database).  This value cannot exceed 40 characters.")
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public ChargeRequest note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(value="")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public ChargeRequest customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @ApiModelProperty(value="The ID of the customer to associate this transaction with. This field is required if you provide a value for `customer_card_id`, and optional otherwise.")
    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public ChargeRequest billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="The buyer's billing address. This value is optional, but this transaction is ineligible for chargeback protection if neither this parameter nor `shipping_address` is provided.")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public ChargeRequest shippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    @ApiModelProperty(value="The buyer's shipping address, if available. This value is optional, but this transaction is ineligible for chargeback protection if neither this parameter nor `billing_address` is provided.")
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public ChargeRequest buyerEmailAddress(String buyerEmailAddress) {
        this.buyerEmailAddress = buyerEmailAddress;
        return this;
    }

    @ApiModelProperty(value="The buyer's email address, if available. This value is optional, but this transaction is ineligible for chargeback protection if it is not provided.")
    public String getBuyerEmailAddress() {
        return this.buyerEmailAddress;
    }

    public void setBuyerEmailAddress(String buyerEmailAddress) {
        this.buyerEmailAddress = buyerEmailAddress;
    }

    public ChargeRequest orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @ApiModelProperty(value="The ID of the order to associate with this transaction.  If you provide this value, the `amount_money` value of your request must __exactly match__ the value of the order's `total_money` field.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public ChargeRequest additionalRecipients(List<AdditionalRecipient> additionalRecipients) {
        this.additionalRecipients = additionalRecipients;
        return this;
    }

    public ChargeRequest addAdditionalRecipientsItem(AdditionalRecipient additionalRecipientsItem) {
        this.additionalRecipients.add(additionalRecipientsItem);
        return this;
    }

    @ApiModelProperty(value="The basic primitive of multi-party transaction. The value is optional. The transaction facilitated by you can be split from here.  If you provide this value, the `amount_money` value in your additional_recipients must not be more than 90% of the `amount_money` value in the charge request. The `location_id` must be the valid location of the app owner merchant.  This field requires the `PAYMENTS_WRITE_ADDITIONAL_RECIPIENTS` OAuth permission.  This field is currently not supported in sandbox.")
    public List<AdditionalRecipient> getAdditionalRecipients() {
        return this.additionalRecipients;
    }

    public void setAdditionalRecipients(List<AdditionalRecipient> additionalRecipients) {
        this.additionalRecipients = additionalRecipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChargeRequest chargeRequest = (ChargeRequest)o;
        return Objects.equals(this.idempotencyKey, chargeRequest.idempotencyKey) && Objects.equals(this.amountMoney, chargeRequest.amountMoney) && Objects.equals(this.cardNonce, chargeRequest.cardNonce) && Objects.equals(this.customerCardId, chargeRequest.customerCardId) && Objects.equals(this.delayCapture, chargeRequest.delayCapture) && Objects.equals(this.referenceId, chargeRequest.referenceId) && Objects.equals(this.note, chargeRequest.note) && Objects.equals(this.customerId, chargeRequest.customerId) && Objects.equals(this.billingAddress, chargeRequest.billingAddress) && Objects.equals(this.shippingAddress, chargeRequest.shippingAddress) && Objects.equals(this.buyerEmailAddress, chargeRequest.buyerEmailAddress) && Objects.equals(this.orderId, chargeRequest.orderId) && Objects.equals(this.additionalRecipients, chargeRequest.additionalRecipients);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.amountMoney, this.cardNonce, this.customerCardId, this.delayCapture, this.referenceId, this.note, this.customerId, this.billingAddress, this.shippingAddress, this.buyerEmailAddress, this.orderId, this.additionalRecipients);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChargeRequest {\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("    cardNonce: ").append(this.toIndentedString(this.cardNonce)).append("\n");
        sb.append("    customerCardId: ").append(this.toIndentedString(this.customerCardId)).append("\n");
        sb.append("    delayCapture: ").append(this.toIndentedString(this.delayCapture)).append("\n");
        sb.append("    referenceId: ").append(this.toIndentedString(this.referenceId)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    buyerEmailAddress: ").append(this.toIndentedString(this.buyerEmailAddress)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    additionalRecipients: ").append(this.toIndentedString(this.additionalRecipients)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

