/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents an additional recipient (other than the merchant) entitled to a portion of the tender. Support is currently limited to USD, CAD and GBP currencies")
public class ChargeRequestAdditionalRecipient {
    @JsonProperty(value="location_id")
    private String locationId = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="amount_money")
    private Money amountMoney = null;

    public ChargeRequestAdditionalRecipient locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The location ID for a recipient (other than the merchant) receiving a portion of the tender.")
    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public ChargeRequestAdditionalRecipient description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The description of the additional recipient.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ChargeRequestAdditionalRecipient amountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of money distributed to the recipient.")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChargeRequestAdditionalRecipient chargeRequestAdditionalRecipient = (ChargeRequestAdditionalRecipient)o;
        return Objects.equals(this.locationId, chargeRequestAdditionalRecipient.locationId) && Objects.equals(this.description, chargeRequestAdditionalRecipient.description) && Objects.equals(this.amountMoney, chargeRequestAdditionalRecipient.amountMoney);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.description, this.amountMoney);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChargeRequestAdditionalRecipient {\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

