/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Address;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines the fields that are included in the request body of a request to the [CreateCustomerCard](#endpoint-createcustomercard) endpoint.")
public class CreateCustomerCardRequest {
    @JsonProperty(value="card_nonce")
    private String cardNonce = null;
    @JsonProperty(value="billing_address")
    private Address billingAddress = null;
    @JsonProperty(value="cardholder_name")
    private String cardholderName = null;

    public CreateCustomerCardRequest cardNonce(String cardNonce) {
        this.cardNonce = cardNonce;
        return this;
    }

    @ApiModelProperty(required=true, value="A card nonce representing the credit card to link to the customer.  Card nonces are generated by the `SqPaymentForm` that buyers enter their card information into. See [Embedding the payment form](/payments/sqpaymentform/overview) for more information.  __Note:__ Card nonces generated by digital wallets (e.g., Apple Pay) cannot be used to create a customer card.")
    public String getCardNonce() {
        return this.cardNonce;
    }

    public void setCardNonce(String cardNonce) {
        this.cardNonce = cardNonce;
    }

    public CreateCustomerCardRequest billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="Address information for the card on file. Only the `postal_code` field is required for payments in the US and Canada.")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public CreateCustomerCardRequest cardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
        return this;
    }

    @ApiModelProperty(value="The cardholder's name.")
    public String getCardholderName() {
        return this.cardholderName;
    }

    public void setCardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCustomerCardRequest createCustomerCardRequest = (CreateCustomerCardRequest)o;
        return Objects.equals(this.cardNonce, createCustomerCardRequest.cardNonce) && Objects.equals(this.billingAddress, createCustomerCardRequest.billingAddress) && Objects.equals(this.cardholderName, createCustomerCardRequest.cardholderName);
    }

    public int hashCode() {
        return Objects.hash(this.cardNonce, this.billingAddress, this.cardholderName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCustomerCardRequest {\n");
        sb.append("    cardNonce: ").append(this.toIndentedString(this.cardNonce)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    cardholderName: ").append(this.toIndentedString(this.cardholderName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

