/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a tax that can apply to either a single line item or an entire order.")
public class CreateOrderRequestTax {
    @JsonProperty(value="catalog_object_id")
    private String catalogObjectId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="percentage")
    private String percentage = null;

    public CreateOrderRequestTax catalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
        return this;
    }

    @ApiModelProperty(value="Only used for catalog taxes. The catalog object ID of an existing [CatalogTax](#type-catalogtax).  Do not provide a value for this field if you provide values in other fields for an ad hoc tax.")
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    public void setCatalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
    }

    public CreateOrderRequestTax name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Only used for ad hoc taxes. The tax's name.  Do not provide a value for this field if you set `catalog_object_id`.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateOrderRequestTax type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Only used for ad hoc taxes. Indicates the calculation method used to apply the line item tax.  Default: `ADDITIVE`; See [OrderLineItemTaxType](#type-orderlineitemtaxtype) for possible values.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CreateOrderRequestTax percentage(String percentage) {
        this.percentage = percentage;
        return this;
    }

    @ApiModelProperty(value="Only used for ad hoc taxes. The percentage of the tax, as a string representation of a decimal number.  A value of `7.25` corresponds to a percentage of 7.25%. This value range between 0.0 up to 100.0")
    public String getPercentage() {
        return this.percentage;
    }

    public void setPercentage(String percentage) {
        this.percentage = percentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrderRequestTax createOrderRequestTax = (CreateOrderRequestTax)o;
        return Objects.equals(this.catalogObjectId, createOrderRequestTax.catalogObjectId) && Objects.equals(this.name, createOrderRequestTax.name) && Objects.equals((Object)this.type, (Object)createOrderRequestTax.type) && Objects.equals(this.percentage, createOrderRequestTax.percentage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.catalogObjectId, this.name, this.type, this.percentage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOrderRequestTax {\n");
        sb.append("    catalogObjectId: ").append(this.toIndentedString(this.catalogObjectId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        UNKNOWN_TAX("UNKNOWN_TAX"),
        ADDITIVE("ADDITIVE"),
        INCLUSIVE("INCLUSIVE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

