/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Creation source filter.  If one or more creation sources are set, customer profiles are included in, or excluded from, the result if they match at least one of the filter criteria.")
public class CustomerCreationSourceFilter {
    @JsonProperty(value="values")
    private List<ValuesEnum> values = new ArrayList<ValuesEnum>();
    @JsonProperty(value="rule")
    private RuleEnum rule = null;

    public CustomerCreationSourceFilter values(List<ValuesEnum> values) {
        this.values = values;
        return this;
    }

    public CustomerCreationSourceFilter addValuesItem(ValuesEnum valuesItem) {
        this.values.add(valuesItem);
        return this;
    }

    @ApiModelProperty(value="The list of creation sources used as filtering criteria. See [CustomerCreationSource](#type-customercreationsource) for possible values.")
    public List<ValuesEnum> getValues() {
        return this.values;
    }

    public void setValues(List<ValuesEnum> values) {
        this.values = values;
    }

    public CustomerCreationSourceFilter rule(RuleEnum rule) {
        this.rule = rule;
        return this;
    }

    @ApiModelProperty(value="Indicates whether a customer profile matching the filter criteria should be included in the result or excluded from the result. Default: `INCLUDE`. See [CustomerInclusionExclusion](#type-customerinclusionexclusion) for possible values.")
    public RuleEnum getRule() {
        return this.rule;
    }

    public void setRule(RuleEnum rule) {
        this.rule = rule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerCreationSourceFilter customerCreationSourceFilter = (CustomerCreationSourceFilter)o;
        return Objects.equals(this.values, customerCreationSourceFilter.values) && Objects.equals((Object)this.rule, (Object)customerCreationSourceFilter.rule);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.values, this.rule});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerCreationSourceFilter {\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("    rule: ").append(this.toIndentedString((Object)this.rule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RuleEnum {
        INCLUDE("INCLUDE"),
        EXCLUDE("EXCLUDE");

        private String value;

        private RuleEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RuleEnum fromValue(String text) {
            for (RuleEnum b : RuleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ValuesEnum {
        OTHER("OTHER"),
        APPOINTMENTS("APPOINTMENTS"),
        COUPON("COUPON"),
        DELETION_RECOVERY("DELETION_RECOVERY"),
        DIRECTORY("DIRECTORY"),
        EGIFTING("EGIFTING"),
        EMAIL_COLLECTION("EMAIL_COLLECTION"),
        FEEDBACK("FEEDBACK"),
        IMPORT("IMPORT"),
        INVOICES("INVOICES"),
        LOYALTY("LOYALTY"),
        MARKETING("MARKETING"),
        MERGE("MERGE"),
        ONLINE_STORE("ONLINE_STORE"),
        INSTANT_PROFILE("INSTANT_PROFILE"),
        TERMINAL("TERMINAL"),
        THIRD_PARTY("THIRD_PARTY"),
        THIRD_PARTY_IMPORT("THIRD_PARTY_IMPORT"),
        UNMERGE_RECOVERY("UNMERGE_RECOVERY");

        private String value;

        private ValuesEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ValuesEnum fromValue(String text) {
            for (ValuesEnum b : ValuesEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

