/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.CustomerCreationSourceFilter;
import com.squareup.connect.models.TimeRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a set of [`CustomerQuery`](#type-customerquery) filters used to limit the set of Customers returned by [`SearchCustomers`](#endpoint-seachcustomers).")
public class CustomerFilter {
    @JsonProperty(value="creation_source")
    private CustomerCreationSourceFilter creationSource = null;
    @JsonProperty(value="created_at")
    private TimeRange createdAt = null;
    @JsonProperty(value="updated_at")
    private TimeRange updatedAt = null;

    public CustomerFilter creationSource(CustomerCreationSourceFilter creationSource) {
        this.creationSource = creationSource;
        return this;
    }

    @ApiModelProperty(value="A filter to select customers based on their creation source.")
    public CustomerCreationSourceFilter getCreationSource() {
        return this.creationSource;
    }

    public void setCreationSource(CustomerCreationSourceFilter creationSource) {
        this.creationSource = creationSource;
    }

    public CustomerFilter createdAt(TimeRange createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="A filter to select customers based on when they were created.")
    public TimeRange getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(TimeRange createdAt) {
        this.createdAt = createdAt;
    }

    public CustomerFilter updatedAt(TimeRange updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="A filter to select customers based on when they were updated.")
    public TimeRange getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(TimeRange updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerFilter customerFilter = (CustomerFilter)o;
        return Objects.equals(this.creationSource, customerFilter.creationSource) && Objects.equals(this.createdAt, customerFilter.createdAt) && Objects.equals(this.updatedAt, customerFilter.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.creationSource, this.createdAt, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerFilter {\n");
        sb.append("    creationSource: ").append(this.toIndentedString(this.creationSource)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

