/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import com.squareup.connect.models.SourceApplication;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a change in state or quantity of product inventory at a particular time and location.")
public class InventoryAdjustment {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="reference_id")
    private String referenceId = null;
    @JsonProperty(value="from_state")
    private FromStateEnum fromState = null;
    @JsonProperty(value="to_state")
    private ToStateEnum toState = null;
    @JsonProperty(value="location_id")
    private String locationId = null;
    @JsonProperty(value="catalog_object_id")
    private String catalogObjectId = null;
    @JsonProperty(value="catalog_object_type")
    private String catalogObjectType = null;
    @JsonProperty(value="quantity")
    private String quantity = null;
    @JsonProperty(value="total_price_money")
    private Money totalPriceMoney = null;
    @JsonProperty(value="occurred_at")
    private String occurredAt = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="source")
    private SourceApplication source = null;
    @JsonProperty(value="employee_id")
    private String employeeId = null;
    @JsonProperty(value="transaction_id")
    private String transactionId = null;
    @JsonProperty(value="refund_id")
    private String refundId = null;
    @JsonProperty(value="purchase_order_id")
    private String purchaseOrderId = null;
    @JsonProperty(value="goods_receipt_id")
    private String goodsReceiptId = null;

    public InventoryAdjustment id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="A unique ID generated by Square for the [InventoryAdjustment](#type-inventoryadjustment).")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public InventoryAdjustment referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @ApiModelProperty(value="An optional ID provided by the application to tie the [InventoryAdjustment](#type-inventoryadjustment) to an external system.")
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public InventoryAdjustment fromState(FromStateEnum fromState) {
        this.fromState = fromState;
        return this;
    }

    @ApiModelProperty(value="The [InventoryState](#type-inventorystate) of the related quantity of items before the adjustment.")
    public FromStateEnum getFromState() {
        return this.fromState;
    }

    public void setFromState(FromStateEnum fromState) {
        this.fromState = fromState;
    }

    public InventoryAdjustment toState(ToStateEnum toState) {
        this.toState = toState;
        return this;
    }

    @ApiModelProperty(value="The [InventoryState](#type-inventorystate) of the related quantity of items after the adjustment.")
    public ToStateEnum getToState() {
        return this.toState;
    }

    public void setToState(ToStateEnum toState) {
        this.toState = toState;
    }

    public InventoryAdjustment locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(value="The Square ID of the [Location](#type-location) where the related quantity of items are being tracked.")
    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public InventoryAdjustment catalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
        return this;
    }

    @ApiModelProperty(value="The Square generated ID of the [CatalogObject](#type-catalogobject) being tracked.")
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    public void setCatalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
    }

    public InventoryAdjustment catalogObjectType(String catalogObjectType) {
        this.catalogObjectType = catalogObjectType;
        return this;
    }

    @ApiModelProperty(value="The [CatalogObjectType](#type-catalogobjecttype) of the [CatalogObject](#type-catalogobject) being tracked. Tracking is only supported for the `ITEM_VARIATION` type.")
    public String getCatalogObjectType() {
        return this.catalogObjectType;
    }

    public void setCatalogObjectType(String catalogObjectType) {
        this.catalogObjectType = catalogObjectType;
    }

    public InventoryAdjustment quantity(String quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="The number of items affected by the adjustment as a decimal string. Fractional quantities are not supported.")
    public String getQuantity() {
        return this.quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public InventoryAdjustment totalPriceMoney(Money totalPriceMoney) {
        this.totalPriceMoney = totalPriceMoney;
        return this;
    }

    @ApiModelProperty(value="The read-only total price paid for goods associated with the adjustment. Present if and only if `to_state` is `SOLD`. Always non-negative.")
    public Money getTotalPriceMoney() {
        return this.totalPriceMoney;
    }

    public void setTotalPriceMoney(Money totalPriceMoney) {
        this.totalPriceMoney = totalPriceMoney;
    }

    public InventoryAdjustment occurredAt(String occurredAt) {
        this.occurredAt = occurredAt;
        return this;
    }

    @ApiModelProperty(value="A client-generated timestamp in RFC 3339 format that indicates when the adjustment took place. For write actions, the `occurred_at` timestamp cannot be older than 24 hours or in the future relative to the time of the request.")
    public String getOccurredAt() {
        return this.occurredAt;
    }

    public void setOccurredAt(String occurredAt) {
        this.occurredAt = occurredAt;
    }

    public InventoryAdjustment createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="A read-only timestamp in RFC 3339 format that indicates when Square received the adjustment.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public InventoryAdjustment source(SourceApplication source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="Read-only information about the application that caused the inventory adjustment.")
    public SourceApplication getSource() {
        return this.source;
    }

    public void setSource(SourceApplication source) {
        this.source = source;
    }

    public InventoryAdjustment employeeId(String employeeId) {
        this.employeeId = employeeId;
        return this;
    }

    @ApiModelProperty(value="The Square ID of the [Employee](#type-employee) responsible for the inventory adjustment.")
    public String getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public InventoryAdjustment transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value="The read-only Square ID of the [Transaction][#type-transaction] that caused the adjustment. Only relevant for payment-related state transitions.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public InventoryAdjustment refundId(String refundId) {
        this.refundId = refundId;
        return this;
    }

    @ApiModelProperty(value="The read-only Square ID of the [Refund][#type-refund] that caused the adjustment. Only relevant for refund-related state transitions.")
    public String getRefundId() {
        return this.refundId;
    }

    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    public InventoryAdjustment purchaseOrderId(String purchaseOrderId) {
        this.purchaseOrderId = purchaseOrderId;
        return this;
    }

    @ApiModelProperty(value="The read-only Square ID of the purchase order that caused the adjustment. Only relevant for state transitions from the Square for Retail app.")
    public String getPurchaseOrderId() {
        return this.purchaseOrderId;
    }

    public void setPurchaseOrderId(String purchaseOrderId) {
        this.purchaseOrderId = purchaseOrderId;
    }

    public InventoryAdjustment goodsReceiptId(String goodsReceiptId) {
        this.goodsReceiptId = goodsReceiptId;
        return this;
    }

    @ApiModelProperty(value="The read-only Square ID of the Square goods receipt that caused the adjustment. Only relevant for state transitions from the Square for Retail app.")
    public String getGoodsReceiptId() {
        return this.goodsReceiptId;
    }

    public void setGoodsReceiptId(String goodsReceiptId) {
        this.goodsReceiptId = goodsReceiptId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryAdjustment inventoryAdjustment = (InventoryAdjustment)o;
        return Objects.equals(this.id, inventoryAdjustment.id) && Objects.equals(this.referenceId, inventoryAdjustment.referenceId) && Objects.equals((Object)this.fromState, (Object)inventoryAdjustment.fromState) && Objects.equals((Object)this.toState, (Object)inventoryAdjustment.toState) && Objects.equals(this.locationId, inventoryAdjustment.locationId) && Objects.equals(this.catalogObjectId, inventoryAdjustment.catalogObjectId) && Objects.equals(this.catalogObjectType, inventoryAdjustment.catalogObjectType) && Objects.equals(this.quantity, inventoryAdjustment.quantity) && Objects.equals(this.totalPriceMoney, inventoryAdjustment.totalPriceMoney) && Objects.equals(this.occurredAt, inventoryAdjustment.occurredAt) && Objects.equals(this.createdAt, inventoryAdjustment.createdAt) && Objects.equals(this.source, inventoryAdjustment.source) && Objects.equals(this.employeeId, inventoryAdjustment.employeeId) && Objects.equals(this.transactionId, inventoryAdjustment.transactionId) && Objects.equals(this.refundId, inventoryAdjustment.refundId) && Objects.equals(this.purchaseOrderId, inventoryAdjustment.purchaseOrderId) && Objects.equals(this.goodsReceiptId, inventoryAdjustment.goodsReceiptId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.referenceId, this.fromState, this.toState, this.locationId, this.catalogObjectId, this.catalogObjectType, this.quantity, this.totalPriceMoney, this.occurredAt, this.createdAt, this.source, this.employeeId, this.transactionId, this.refundId, this.purchaseOrderId, this.goodsReceiptId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InventoryAdjustment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    referenceId: ").append(this.toIndentedString(this.referenceId)).append("\n");
        sb.append("    fromState: ").append(this.toIndentedString((Object)this.fromState)).append("\n");
        sb.append("    toState: ").append(this.toIndentedString((Object)this.toState)).append("\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    catalogObjectId: ").append(this.toIndentedString(this.catalogObjectId)).append("\n");
        sb.append("    catalogObjectType: ").append(this.toIndentedString(this.catalogObjectType)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    totalPriceMoney: ").append(this.toIndentedString(this.totalPriceMoney)).append("\n");
        sb.append("    occurredAt: ").append(this.toIndentedString(this.occurredAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    employeeId: ").append(this.toIndentedString(this.employeeId)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    refundId: ").append(this.toIndentedString(this.refundId)).append("\n");
        sb.append("    purchaseOrderId: ").append(this.toIndentedString(this.purchaseOrderId)).append("\n");
        sb.append("    goodsReceiptId: ").append(this.toIndentedString(this.goodsReceiptId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ToStateEnum {
        CUSTOM("CUSTOM"),
        IN_STOCK("IN_STOCK"),
        SOLD("SOLD"),
        RETURNED_BY_CUSTOMER("RETURNED_BY_CUSTOMER"),
        RESERVED_FOR_SALE("RESERVED_FOR_SALE"),
        SOLD_ONLINE("SOLD_ONLINE"),
        ORDERED_FROM_VENDOR("ORDERED_FROM_VENDOR"),
        RECEIVED_FROM_VENDOR("RECEIVED_FROM_VENDOR"),
        IN_TRANSIT_TO("IN_TRANSIT_TO"),
        NONE("NONE"),
        WASTE("WASTE"),
        UNLINKED_RETURN("UNLINKED_RETURN");

        private String value;

        private ToStateEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ToStateEnum fromValue(String text) {
            for (ToStateEnum b : ToStateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum FromStateEnum {
        CUSTOM("CUSTOM"),
        IN_STOCK("IN_STOCK"),
        SOLD("SOLD"),
        RETURNED_BY_CUSTOMER("RETURNED_BY_CUSTOMER"),
        RESERVED_FOR_SALE("RESERVED_FOR_SALE"),
        SOLD_ONLINE("SOLD_ONLINE"),
        ORDERED_FROM_VENDOR("ORDERED_FROM_VENDOR"),
        RECEIVED_FROM_VENDOR("RECEIVED_FROM_VENDOR"),
        IN_TRANSIT_TO("IN_TRANSIT_TO"),
        NONE("NONE"),
        WASTE("WASTE"),
        UNLINKED_RETURN("UNLINKED_RETURN");

        private String value;

        private FromStateEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FromStateEnum fromValue(String text) {
            for (FromStateEnum b : FromStateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

