/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.InventoryAdjustment;
import com.squareup.connect.models.InventoryPhysicalCount;
import com.squareup.connect.models.InventoryTransfer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a single physical count, inventory, adjustment, or transfer that is part of the history of inventory changes for a particular [CatalogObject](#type-catalogobject).")
public class InventoryChange {
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="physical_count")
    private InventoryPhysicalCount physicalCount = null;
    @JsonProperty(value="adjustment")
    private InventoryAdjustment adjustment = null;
    @JsonProperty(value="transfer")
    private InventoryTransfer transfer = null;

    public InventoryChange type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Indicates how the inventory change was applied. See [InventoryChangeType](#type-inventorychangetype) for all possible values.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public InventoryChange physicalCount(InventoryPhysicalCount physicalCount) {
        this.physicalCount = physicalCount;
        return this;
    }

    @ApiModelProperty(value="Contains details about the physical count when `type` is `PHYSICAL_COUNT` and unset for all other types.")
    public InventoryPhysicalCount getPhysicalCount() {
        return this.physicalCount;
    }

    public void setPhysicalCount(InventoryPhysicalCount physicalCount) {
        this.physicalCount = physicalCount;
    }

    public InventoryChange adjustment(InventoryAdjustment adjustment) {
        this.adjustment = adjustment;
        return this;
    }

    @ApiModelProperty(value="Contains details about the inventory adjustment when `type` is `ADJUSTMENT` and unset for all other types.")
    public InventoryAdjustment getAdjustment() {
        return this.adjustment;
    }

    public void setAdjustment(InventoryAdjustment adjustment) {
        this.adjustment = adjustment;
    }

    public InventoryChange transfer(InventoryTransfer transfer) {
        this.transfer = transfer;
        return this;
    }

    @ApiModelProperty(value="Contains details about the inventory transfer when `type` is `TRANSFER` and unset for all other types.")
    public InventoryTransfer getTransfer() {
        return this.transfer;
    }

    public void setTransfer(InventoryTransfer transfer) {
        this.transfer = transfer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryChange inventoryChange = (InventoryChange)o;
        return Objects.equals((Object)this.type, (Object)inventoryChange.type) && Objects.equals(this.physicalCount, inventoryChange.physicalCount) && Objects.equals(this.adjustment, inventoryChange.adjustment) && Objects.equals(this.transfer, inventoryChange.transfer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.physicalCount, this.adjustment, this.transfer});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InventoryChange {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    physicalCount: ").append(this.toIndentedString(this.physicalCount)).append("\n");
        sb.append("    adjustment: ").append(this.toIndentedString(this.adjustment)).append("\n");
        sb.append("    transfer: ").append(this.toIndentedString(this.transfer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        PHYSICAL_COUNT("PHYSICAL_COUNT"),
        ADJUSTMENT("ADJUSTMENT"),
        TRANSFER("TRANSFER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

