/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.SourceApplication;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents the transfer of a quantity of product inventory at a particular time from one location to another.")
public class InventoryTransfer {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="reference_id")
    private String referenceId = null;
    @JsonProperty(value="state")
    private StateEnum state = null;
    @JsonProperty(value="from_location_id")
    private String fromLocationId = null;
    @JsonProperty(value="to_location_id")
    private String toLocationId = null;
    @JsonProperty(value="catalog_object_id")
    private String catalogObjectId = null;
    @JsonProperty(value="catalog_object_type")
    private String catalogObjectType = null;
    @JsonProperty(value="quantity")
    private String quantity = null;
    @JsonProperty(value="occurred_at")
    private String occurredAt = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="source")
    private SourceApplication source = null;
    @JsonProperty(value="employee_id")
    private String employeeId = null;

    public InventoryTransfer id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="A unique ID generated by Square for the [InventoryTransfer](#type-inventorytransfer).")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public InventoryTransfer referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @ApiModelProperty(value="An optional ID provided by the application to tie the [InventoryTransfer](#type-inventorytransfer) to an external system.")
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public InventoryTransfer state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="The [InventoryState](#type-inventorystate) for the quantity of items being transfered.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public InventoryTransfer fromLocationId(String fromLocationId) {
        this.fromLocationId = fromLocationId;
        return this;
    }

    @ApiModelProperty(value="The Square ID of the [Location](#type-location) where the related quantity of items were tracked before the transfer.")
    public String getFromLocationId() {
        return this.fromLocationId;
    }

    public void setFromLocationId(String fromLocationId) {
        this.fromLocationId = fromLocationId;
    }

    public InventoryTransfer toLocationId(String toLocationId) {
        this.toLocationId = toLocationId;
        return this;
    }

    @ApiModelProperty(value="The Square ID of the [Location](#type-location) where the related quantity of items were tracked after the transfer.")
    public String getToLocationId() {
        return this.toLocationId;
    }

    public void setToLocationId(String toLocationId) {
        this.toLocationId = toLocationId;
    }

    public InventoryTransfer catalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
        return this;
    }

    @ApiModelProperty(value="The Square generated ID of the [CatalogObject](#type-catalogobject) being tracked.")
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    public void setCatalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
    }

    public InventoryTransfer catalogObjectType(String catalogObjectType) {
        this.catalogObjectType = catalogObjectType;
        return this;
    }

    @ApiModelProperty(value="The [CatalogObjectType](#type-catalogobjecttype) of the [CatalogObject](#type-catalogobject) being tracked.Tracking is only supported for the `ITEM_VARIATION` type.")
    public String getCatalogObjectType() {
        return this.catalogObjectType;
    }

    public void setCatalogObjectType(String catalogObjectType) {
        this.catalogObjectType = catalogObjectType;
    }

    public InventoryTransfer quantity(String quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="The number of items affected by the transfer as a decimal string. Fractional quantities are not supported.")
    public String getQuantity() {
        return this.quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public InventoryTransfer occurredAt(String occurredAt) {
        this.occurredAt = occurredAt;
        return this;
    }

    @ApiModelProperty(value="A client-generated timestamp in RFC 3339 format that indicates when the transfer took place. For write actions, the `occurred_at` timestamp cannot be older than 24 hours or in the future relative to the time of the request.")
    public String getOccurredAt() {
        return this.occurredAt;
    }

    public void setOccurredAt(String occurredAt) {
        this.occurredAt = occurredAt;
    }

    public InventoryTransfer createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="A read-only timestamp in RFC 3339 format that indicates when Square received the transfer request.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public InventoryTransfer source(SourceApplication source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="Read-only information about the application that initiated the inventory transfer.")
    public SourceApplication getSource() {
        return this.source;
    }

    public void setSource(SourceApplication source) {
        this.source = source;
    }

    public InventoryTransfer employeeId(String employeeId) {
        this.employeeId = employeeId;
        return this;
    }

    @ApiModelProperty(value="The Square ID of the [Employee](#type-employee) responsible for the inventory transfer.")
    public String getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryTransfer inventoryTransfer = (InventoryTransfer)o;
        return Objects.equals(this.id, inventoryTransfer.id) && Objects.equals(this.referenceId, inventoryTransfer.referenceId) && Objects.equals((Object)this.state, (Object)inventoryTransfer.state) && Objects.equals(this.fromLocationId, inventoryTransfer.fromLocationId) && Objects.equals(this.toLocationId, inventoryTransfer.toLocationId) && Objects.equals(this.catalogObjectId, inventoryTransfer.catalogObjectId) && Objects.equals(this.catalogObjectType, inventoryTransfer.catalogObjectType) && Objects.equals(this.quantity, inventoryTransfer.quantity) && Objects.equals(this.occurredAt, inventoryTransfer.occurredAt) && Objects.equals(this.createdAt, inventoryTransfer.createdAt) && Objects.equals(this.source, inventoryTransfer.source) && Objects.equals(this.employeeId, inventoryTransfer.employeeId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.referenceId, this.state, this.fromLocationId, this.toLocationId, this.catalogObjectId, this.catalogObjectType, this.quantity, this.occurredAt, this.createdAt, this.source, this.employeeId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InventoryTransfer {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    referenceId: ").append(this.toIndentedString(this.referenceId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    fromLocationId: ").append(this.toIndentedString(this.fromLocationId)).append("\n");
        sb.append("    toLocationId: ").append(this.toIndentedString(this.toLocationId)).append("\n");
        sb.append("    catalogObjectId: ").append(this.toIndentedString(this.catalogObjectId)).append("\n");
        sb.append("    catalogObjectType: ").append(this.toIndentedString(this.catalogObjectType)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    occurredAt: ").append(this.toIndentedString(this.occurredAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    employeeId: ").append(this.toIndentedString(this.employeeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        CUSTOM("CUSTOM"),
        IN_STOCK("IN_STOCK"),
        SOLD("SOLD"),
        RETURNED_BY_CUSTOMER("RETURNED_BY_CUSTOMER"),
        RESERVED_FOR_SALE("RESERVED_FOR_SALE"),
        SOLD_ONLINE("SOLD_ONLINE"),
        ORDERED_FROM_VENDOR("ORDERED_FROM_VENDOR"),
        RECEIVED_FROM_VENDOR("RECEIVED_FROM_VENDOR"),
        IN_TRANSIT_TO("IN_TRANSIT_TO"),
        NONE("NONE"),
        WASTE("WASTE"),
        UNLINKED_RETURN("UNLINKED_RETURN");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

