/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines the query parameters that can be provided in a request to the [ListCustomers](#endpoint-listcustomers) endpoint.")
public class ListCustomersRequest {
    @JsonProperty(value="cursor")
    private String cursor = null;
    @JsonProperty(value="sort_field")
    private SortFieldEnum sortField = null;
    @JsonProperty(value="sort_order")
    private SortOrderEnum sortOrder = null;

    public ListCustomersRequest cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @ApiModelProperty(value="A pagination cursor returned by a previous call to this endpoint. Provide this to retrieve the next set of results for your original query.  See [Paginating results](#paginatingresults) for more information.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public ListCustomersRequest sortField(SortFieldEnum sortField) {
        this.sortField = sortField;
        return this;
    }

    @ApiModelProperty(value="Indicates how Customers should be sorted. Default: `DEFAULT`. See [CustomerSortField](#type-customersortfield) for possible values.")
    public SortFieldEnum getSortField() {
        return this.sortField;
    }

    public void setSortField(SortFieldEnum sortField) {
        this.sortField = sortField;
    }

    public ListCustomersRequest sortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(value="Indicates whether Customers should be sorted in ascending (`ASC`) or descending (`DESC`) order. Default: `ASC`. See [SortOrder](#type-sortorder) for possible values.")
    public SortOrderEnum getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListCustomersRequest listCustomersRequest = (ListCustomersRequest)o;
        return Objects.equals(this.cursor, listCustomersRequest.cursor) && Objects.equals((Object)this.sortField, (Object)listCustomersRequest.sortField) && Objects.equals((Object)this.sortOrder, (Object)listCustomersRequest.sortOrder);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cursor, this.sortField, this.sortOrder});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListCustomersRequest {\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    sortField: ").append(this.toIndentedString((Object)this.sortField)).append("\n");
        sb.append("    sortOrder: ").append(this.toIndentedString((Object)this.sortOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SortOrderEnum {
        DESC("DESC"),
        ASC("ASC");

        private String value;

        private SortOrderEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SortOrderEnum fromValue(String text) {
            for (SortOrderEnum b : SortOrderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum SortFieldEnum {
        DEFAULT("DEFAULT"),
        CREATED_AT("CREATED_AT");

        private String value;

        private SortFieldEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SortFieldEnum fromValue(String text) {
            for (SortFieldEnum b : SortFieldEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

