/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import com.squareup.connect.models.OrderLineItemDiscount;
import com.squareup.connect.models.OrderLineItemModifier;
import com.squareup.connect.models.OrderLineItemTax;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a line item in an order. Each line item describes a different product to purchase, with its own quantity and price details.")
public class OrderLineItem {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="quantity")
    private String quantity = null;
    @JsonProperty(value="note")
    private String note = null;
    @JsonProperty(value="catalog_object_id")
    private String catalogObjectId = null;
    @JsonProperty(value="variation_name")
    private String variationName = null;
    @JsonProperty(value="modifiers")
    private List<OrderLineItemModifier> modifiers = new ArrayList<OrderLineItemModifier>();
    @JsonProperty(value="taxes")
    private List<OrderLineItemTax> taxes = new ArrayList<OrderLineItemTax>();
    @JsonProperty(value="discounts")
    private List<OrderLineItemDiscount> discounts = new ArrayList<OrderLineItemDiscount>();
    @JsonProperty(value="base_price_money")
    private Money basePriceMoney = null;
    @JsonProperty(value="gross_sales_money")
    private Money grossSalesMoney = null;
    @JsonProperty(value="total_tax_money")
    private Money totalTaxMoney = null;
    @JsonProperty(value="total_discount_money")
    private Money totalDiscountMoney = null;
    @JsonProperty(value="total_money")
    private Money totalMoney = null;

    public OrderLineItem name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the line item.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OrderLineItem quantity(String quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="The quantity purchased, as a string representation of a number.  This string must have a positive integer value.")
    public String getQuantity() {
        return this.quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public OrderLineItem note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(value="The note of the line item.")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public OrderLineItem catalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
        return this;
    }

    @ApiModelProperty(value="The [CatalogItemVariation](#type-catalogitemvariation) id applied to this line item.")
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    public void setCatalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
    }

    public OrderLineItem variationName(String variationName) {
        this.variationName = variationName;
        return this;
    }

    @ApiModelProperty(value="The name of the variation applied to this line item.")
    public String getVariationName() {
        return this.variationName;
    }

    public void setVariationName(String variationName) {
        this.variationName = variationName;
    }

    public OrderLineItem modifiers(List<OrderLineItemModifier> modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public OrderLineItem addModifiersItem(OrderLineItemModifier modifiersItem) {
        this.modifiers.add(modifiersItem);
        return this;
    }

    @ApiModelProperty(value="The [CatalogModifier](#type-catalogmodifier)s applied to this line item.")
    public List<OrderLineItemModifier> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(List<OrderLineItemModifier> modifiers) {
        this.modifiers = modifiers;
    }

    public OrderLineItem taxes(List<OrderLineItemTax> taxes) {
        this.taxes = taxes;
        return this;
    }

    public OrderLineItem addTaxesItem(OrderLineItemTax taxesItem) {
        this.taxes.add(taxesItem);
        return this;
    }

    @ApiModelProperty(value="The taxes applied to this line item.")
    public List<OrderLineItemTax> getTaxes() {
        return this.taxes;
    }

    public void setTaxes(List<OrderLineItemTax> taxes) {
        this.taxes = taxes;
    }

    public OrderLineItem discounts(List<OrderLineItemDiscount> discounts) {
        this.discounts = discounts;
        return this;
    }

    public OrderLineItem addDiscountsItem(OrderLineItemDiscount discountsItem) {
        this.discounts.add(discountsItem);
        return this;
    }

    @ApiModelProperty(value="The discounts applied to this line item.")
    public List<OrderLineItemDiscount> getDiscounts() {
        return this.discounts;
    }

    public void setDiscounts(List<OrderLineItemDiscount> discounts) {
        this.discounts = discounts;
    }

    public OrderLineItem basePriceMoney(Money basePriceMoney) {
        this.basePriceMoney = basePriceMoney;
        return this;
    }

    @ApiModelProperty(value="The base price for a single unit of the line item.")
    public Money getBasePriceMoney() {
        return this.basePriceMoney;
    }

    public void setBasePriceMoney(Money basePriceMoney) {
        this.basePriceMoney = basePriceMoney;
    }

    public OrderLineItem grossSalesMoney(Money grossSalesMoney) {
        this.grossSalesMoney = grossSalesMoney;
        return this;
    }

    @ApiModelProperty(value="The gross sales amount of money calculated as (item base price + modifiers price) * quantity.")
    public Money getGrossSalesMoney() {
        return this.grossSalesMoney;
    }

    public void setGrossSalesMoney(Money grossSalesMoney) {
        this.grossSalesMoney = grossSalesMoney;
    }

    public OrderLineItem totalTaxMoney(Money totalTaxMoney) {
        this.totalTaxMoney = totalTaxMoney;
        return this;
    }

    @ApiModelProperty(value="The total tax amount of money to collect for the line item.")
    public Money getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    public void setTotalTaxMoney(Money totalTaxMoney) {
        this.totalTaxMoney = totalTaxMoney;
    }

    public OrderLineItem totalDiscountMoney(Money totalDiscountMoney) {
        this.totalDiscountMoney = totalDiscountMoney;
        return this;
    }

    @ApiModelProperty(value="The total discount amount of money to collect for the line item.")
    public Money getTotalDiscountMoney() {
        return this.totalDiscountMoney;
    }

    public void setTotalDiscountMoney(Money totalDiscountMoney) {
        this.totalDiscountMoney = totalDiscountMoney;
    }

    public OrderLineItem totalMoney(Money totalMoney) {
        this.totalMoney = totalMoney;
        return this;
    }

    @ApiModelProperty(value="The total amount of money to collect for this line item.")
    public Money getTotalMoney() {
        return this.totalMoney;
    }

    public void setTotalMoney(Money totalMoney) {
        this.totalMoney = totalMoney;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderLineItem orderLineItem = (OrderLineItem)o;
        return Objects.equals(this.name, orderLineItem.name) && Objects.equals(this.quantity, orderLineItem.quantity) && Objects.equals(this.note, orderLineItem.note) && Objects.equals(this.catalogObjectId, orderLineItem.catalogObjectId) && Objects.equals(this.variationName, orderLineItem.variationName) && Objects.equals(this.modifiers, orderLineItem.modifiers) && Objects.equals(this.taxes, orderLineItem.taxes) && Objects.equals(this.discounts, orderLineItem.discounts) && Objects.equals(this.basePriceMoney, orderLineItem.basePriceMoney) && Objects.equals(this.grossSalesMoney, orderLineItem.grossSalesMoney) && Objects.equals(this.totalTaxMoney, orderLineItem.totalTaxMoney) && Objects.equals(this.totalDiscountMoney, orderLineItem.totalDiscountMoney) && Objects.equals(this.totalMoney, orderLineItem.totalMoney);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.quantity, this.note, this.catalogObjectId, this.variationName, this.modifiers, this.taxes, this.discounts, this.basePriceMoney, this.grossSalesMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalMoney);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderLineItem {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    catalogObjectId: ").append(this.toIndentedString(this.catalogObjectId)).append("\n");
        sb.append("    variationName: ").append(this.toIndentedString(this.variationName)).append("\n");
        sb.append("    modifiers: ").append(this.toIndentedString(this.modifiers)).append("\n");
        sb.append("    taxes: ").append(this.toIndentedString(this.taxes)).append("\n");
        sb.append("    discounts: ").append(this.toIndentedString(this.discounts)).append("\n");
        sb.append("    basePriceMoney: ").append(this.toIndentedString(this.basePriceMoney)).append("\n");
        sb.append("    grossSalesMoney: ").append(this.toIndentedString(this.grossSalesMoney)).append("\n");
        sb.append("    totalTaxMoney: ").append(this.toIndentedString(this.totalTaxMoney)).append("\n");
        sb.append("    totalDiscountMoney: ").append(this.toIndentedString(this.totalDiscountMoney)).append("\n");
        sb.append("    totalMoney: ").append(this.toIndentedString(this.totalMoney)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

