/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.AdditionalRecipient;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a refund processed for a Square transaction.")
public class Refund {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="location_id")
    private String locationId = null;
    @JsonProperty(value="transaction_id")
    private String transactionId = null;
    @JsonProperty(value="tender_id")
    private String tenderId = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="reason")
    private String reason = null;
    @JsonProperty(value="amount_money")
    private Money amountMoney = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="processing_fee_money")
    private Money processingFeeMoney = null;
    @JsonProperty(value="additional_recipients")
    private List<AdditionalRecipient> additionalRecipients = new ArrayList<AdditionalRecipient>();

    public Refund id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The refund's unique ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Refund locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the refund's associated location.")
    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public Refund transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the transaction that the refunded tender is part of.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Refund tenderId(String tenderId) {
        this.tenderId = tenderId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the refunded tender.")
    public String getTenderId() {
        return this.tenderId;
    }

    public void setTenderId(String tenderId) {
        this.tenderId = tenderId;
    }

    public Refund createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the refund was created, in RFC 3339 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Refund reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(required=true, value="The reason for the refund being issued.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Refund amountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of money refunded to the buyer.")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public Refund status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The current status of the refund (`PENDING`, `APPROVED`, `REJECTED`, or `FAILED`).")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Refund processingFeeMoney(Money processingFeeMoney) {
        this.processingFeeMoney = processingFeeMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of Square processing fee money refunded to the *merchant*.")
    public Money getProcessingFeeMoney() {
        return this.processingFeeMoney;
    }

    public void setProcessingFeeMoney(Money processingFeeMoney) {
        this.processingFeeMoney = processingFeeMoney;
    }

    public Refund additionalRecipients(List<AdditionalRecipient> additionalRecipients) {
        this.additionalRecipients = additionalRecipients;
        return this;
    }

    public Refund addAdditionalRecipientsItem(AdditionalRecipient additionalRecipientsItem) {
        this.additionalRecipients.add(additionalRecipientsItem);
        return this;
    }

    @ApiModelProperty(value="Additional recipients (other than the merchant) receiving a portion of this refund. For example, fees assessed on a refund of a purchase by a third party integration.")
    public List<AdditionalRecipient> getAdditionalRecipients() {
        return this.additionalRecipients;
    }

    public void setAdditionalRecipients(List<AdditionalRecipient> additionalRecipients) {
        this.additionalRecipients = additionalRecipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Refund refund = (Refund)o;
        return Objects.equals(this.id, refund.id) && Objects.equals(this.locationId, refund.locationId) && Objects.equals(this.transactionId, refund.transactionId) && Objects.equals(this.tenderId, refund.tenderId) && Objects.equals(this.createdAt, refund.createdAt) && Objects.equals(this.reason, refund.reason) && Objects.equals(this.amountMoney, refund.amountMoney) && Objects.equals((Object)this.status, (Object)refund.status) && Objects.equals(this.processingFeeMoney, refund.processingFeeMoney) && Objects.equals(this.additionalRecipients, refund.additionalRecipients);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.locationId, this.transactionId, this.tenderId, this.createdAt, this.reason, this.amountMoney, this.status, this.processingFeeMoney, this.additionalRecipients});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Refund {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    tenderId: ").append(this.toIndentedString(this.tenderId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    processingFeeMoney: ").append(this.toIndentedString(this.processingFeeMoney)).append("\n");
        sb.append("    additionalRecipients: ").append(this.toIndentedString(this.additionalRecipients)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING("PENDING"),
        APPROVED("APPROVED"),
        REJECTED("REJECTED"),
        FAILED("FAILED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

