/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.CatalogQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class SearchCatalogObjectsRequest {
    @JsonProperty(value="cursor")
    private String cursor = null;
    @JsonProperty(value="object_types")
    private List<ObjectTypesEnum> objectTypes = new ArrayList<ObjectTypesEnum>();
    @JsonProperty(value="include_deleted_objects")
    private Boolean includeDeletedObjects = null;
    @JsonProperty(value="include_related_objects")
    private Boolean includeRelatedObjects = null;
    @JsonProperty(value="begin_time")
    private String beginTime = null;
    @JsonProperty(value="query")
    private CatalogQuery query = null;
    @JsonProperty(value="limit")
    private Integer limit = null;

    public SearchCatalogObjectsRequest cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @ApiModelProperty(value="The pagination cursor returned in the previous response. Leave unset for an initial request. See [Paginating results](#paginatingresults) for more information.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public SearchCatalogObjectsRequest objectTypes(List<ObjectTypesEnum> objectTypes) {
        this.objectTypes = objectTypes;
        return this;
    }

    public SearchCatalogObjectsRequest addObjectTypesItem(ObjectTypesEnum objectTypesItem) {
        this.objectTypes.add(objectTypesItem);
        return this;
    }

    @ApiModelProperty(value="The desired set of object types to appear in the search results. The legal values are taken from the [CatalogObjectType](#type-catalogobjecttype) enumeration, namely `\"ITEM\"`, `\"ITEM_VARIATION\"`, `\"CATEGORY\"`, `\"DISCOUNT\"`, `\"TAX\"`, `\"MODIFIER\"`, or `\"MODIFIER_LIST\"`.")
    public List<ObjectTypesEnum> getObjectTypes() {
        return this.objectTypes;
    }

    public void setObjectTypes(List<ObjectTypesEnum> objectTypes) {
        this.objectTypes = objectTypes;
    }

    public SearchCatalogObjectsRequest includeDeletedObjects(Boolean includeDeletedObjects) {
        this.includeDeletedObjects = includeDeletedObjects;
        return this;
    }

    @ApiModelProperty(value="If `true`, deleted objects will be included in the results. Deleted objects will have their `is_deleted` field set to `true`.")
    public Boolean getIncludeDeletedObjects() {
        return this.includeDeletedObjects;
    }

    public void setIncludeDeletedObjects(Boolean includeDeletedObjects) {
        this.includeDeletedObjects = includeDeletedObjects;
    }

    public SearchCatalogObjectsRequest includeRelatedObjects(Boolean includeRelatedObjects) {
        this.includeRelatedObjects = includeRelatedObjects;
        return this;
    }

    @ApiModelProperty(value="If `true`, the response will include additional objects that are related to the requested object, as follows:  If a [CatalogItem](#type-catalogitem) is returned in the object field of the response, its associated [CatalogCategory](#type-catalogcategory), [CatalogTax](#type-catalogtax)es, and [CatalogModifierList](#type-catalogmodifierlist)s will be included in the `related_objects` field of the response.  If a [CatalogItemVariation](#type-catalogitemvariation) is returned in the object field of the response, its parent [CatalogItem](#type-catalogitem) will be included in the `related_objects` field of the response.")
    public Boolean getIncludeRelatedObjects() {
        return this.includeRelatedObjects;
    }

    public void setIncludeRelatedObjects(Boolean includeRelatedObjects) {
        this.includeRelatedObjects = includeRelatedObjects;
    }

    public SearchCatalogObjectsRequest beginTime(String beginTime) {
        this.beginTime = beginTime;
        return this;
    }

    @ApiModelProperty(value="Return objects modified after this [timestamp](#workingwithdates), in RFC 3339 format, e.g., \"2016-09-04T23:59:33.123Z\". The timestamp is exclusive - objects with a timestamp equal to `begin_time` will not be included in the response.")
    public String getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public SearchCatalogObjectsRequest query(CatalogQuery query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(value="A query to be used to filter or sort the results. If no query is specified, the entire catalog will be returned.")
    public CatalogQuery getQuery() {
        return this.query;
    }

    public void setQuery(CatalogQuery query) {
        this.query = query;
    }

    public SearchCatalogObjectsRequest limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(value="A limit on the number of results to be returned in a single page. The limit is advisory - the implementation may return more or fewer results. If the supplied limit is negative, zero, or is higher than the maximum limit of 1,000, it will be ignored.")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchCatalogObjectsRequest searchCatalogObjectsRequest = (SearchCatalogObjectsRequest)o;
        return Objects.equals(this.cursor, searchCatalogObjectsRequest.cursor) && Objects.equals(this.objectTypes, searchCatalogObjectsRequest.objectTypes) && Objects.equals(this.includeDeletedObjects, searchCatalogObjectsRequest.includeDeletedObjects) && Objects.equals(this.includeRelatedObjects, searchCatalogObjectsRequest.includeRelatedObjects) && Objects.equals(this.beginTime, searchCatalogObjectsRequest.beginTime) && Objects.equals(this.query, searchCatalogObjectsRequest.query) && Objects.equals(this.limit, searchCatalogObjectsRequest.limit);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.objectTypes, this.includeDeletedObjects, this.includeRelatedObjects, this.beginTime, this.query, this.limit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchCatalogObjectsRequest {\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    objectTypes: ").append(this.toIndentedString(this.objectTypes)).append("\n");
        sb.append("    includeDeletedObjects: ").append(this.toIndentedString(this.includeDeletedObjects)).append("\n");
        sb.append("    includeRelatedObjects: ").append(this.toIndentedString(this.includeRelatedObjects)).append("\n");
        sb.append("    beginTime: ").append(this.toIndentedString(this.beginTime)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ObjectTypesEnum {
        ITEM("ITEM"),
        CATEGORY("CATEGORY"),
        ITEM_VARIATION("ITEM_VARIATION"),
        TAX("TAX"),
        DISCOUNT("DISCOUNT"),
        MODIFIER_LIST("MODIFIER_LIST"),
        MODIFIER("MODIFIER");

        private String value;

        private ObjectTypesEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ObjectTypesEnum fromValue(String text) {
            for (ObjectTypesEnum b : ObjectTypesEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

