/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.CustomerQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines the fields included in the request body for the [SearchCustomers](#endpoint-searchcustomer) endpoint.")
public class SearchCustomersRequest {
    @JsonProperty(value="cursor")
    private String cursor = null;
    @JsonProperty(value="limit")
    private Long limit = null;
    @JsonProperty(value="query")
    private CustomerQuery query = null;

    public SearchCustomersRequest cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @ApiModelProperty(value="Include the pagination cursor in subsequent calls to this endpoint to retrieve the next set of results associated with the original query.  See [Paginating results](#paginatingresults) for more information.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public SearchCustomersRequest limit(Long limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(value="A limit on the number of results to be returned in a single page. The limit is advisory - the implementation may return more or fewer results. If the supplied limit is negative, zero, or is higher than the maximum limit of 1,000, it will be ignored.")
    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public SearchCustomersRequest query(CustomerQuery query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(value="Query customers based on the given conditions and sort order. Calling SearchCustomers without an explicit query parameter will return all customers ordered alphabetically based on `given_name` and `family_name`.")
    public CustomerQuery getQuery() {
        return this.query;
    }

    public void setQuery(CustomerQuery query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchCustomersRequest searchCustomersRequest = (SearchCustomersRequest)o;
        return Objects.equals(this.cursor, searchCustomersRequest.cursor) && Objects.equals(this.limit, searchCustomersRequest.limit) && Objects.equals(this.query, searchCustomersRequest.query);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.limit, this.query);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchCustomersRequest {\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

