/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a generic time range. The start and end values are represented in RFC-3339 format. Time ranges are customized to be inclusive or exclusive based on the needs of a particular endpoint. Refer to the relevent endpoint-specific documentation to determine how time ranges are handled.")
public class TimeRange {
    @JsonProperty(value="start_at")
    private String startAt = null;
    @JsonProperty(value="end_at")
    private String endAt = null;

    public TimeRange startAt(String startAt) {
        this.startAt = startAt;
        return this;
    }

    @ApiModelProperty(value="A datetime value in RFC-3339 format indicating when the time range starts.")
    public String getStartAt() {
        return this.startAt;
    }

    public void setStartAt(String startAt) {
        this.startAt = startAt;
    }

    public TimeRange endAt(String endAt) {
        this.endAt = endAt;
        return this;
    }

    @ApiModelProperty(value="A datetime value in RFC-3339 format indicating when the time range ends.")
    public String getEndAt() {
        return this.endAt;
    }

    public void setEndAt(String endAt) {
        this.endAt = endAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeRange timeRange = (TimeRange)o;
        return Objects.equals(this.startAt, timeRange.startAt) && Objects.equals(this.endAt, timeRange.endAt);
    }

    public int hashCode() {
        return Objects.hash(this.startAt, this.endAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeRange {\n");
        sb.append("    startAt: ").append(this.toIndentedString(this.startAt)).append("\n");
        sb.append("    endAt: ").append(this.toIndentedString(this.endAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

