/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Address;
import com.squareup.connect.models.Refund;
import com.squareup.connect.models.Tender;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a transaction processed with Square, either with the Connect API or with Square Point of Sale.  The `tenders` field of this object lists all methods of payment used to pay in the transaction.")
public class Transaction {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="location_id")
    private String locationId = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="tenders")
    private List<Tender> tenders = new ArrayList<Tender>();
    @JsonProperty(value="refunds")
    private List<Refund> refunds = new ArrayList<Refund>();
    @JsonProperty(value="reference_id")
    private String referenceId = null;
    @JsonProperty(value="product")
    private ProductEnum product = null;
    @JsonProperty(value="client_id")
    private String clientId = null;
    @JsonProperty(value="shipping_address")
    private Address shippingAddress = null;
    @JsonProperty(value="order_id")
    private String orderId = null;

    public Transaction id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The transaction's unique ID, issued by Square payments servers.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Transaction locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(value="The ID of the transaction's associated location.")
    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public Transaction createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the transaction was created, in RFC 3339 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Transaction tenders(List<Tender> tenders) {
        this.tenders = tenders;
        return this;
    }

    public Transaction addTendersItem(Tender tendersItem) {
        this.tenders.add(tendersItem);
        return this;
    }

    @ApiModelProperty(value="The tenders used to pay in the transaction.")
    public List<Tender> getTenders() {
        return this.tenders;
    }

    public void setTenders(List<Tender> tenders) {
        this.tenders = tenders;
    }

    public Transaction refunds(List<Refund> refunds) {
        this.refunds = refunds;
        return this;
    }

    public Transaction addRefundsItem(Refund refundsItem) {
        this.refunds.add(refundsItem);
        return this;
    }

    @ApiModelProperty(value="Refunds that have been applied to any tender in the transaction.")
    public List<Refund> getRefunds() {
        return this.refunds;
    }

    public void setRefunds(List<Refund> refunds) {
        this.refunds = refunds;
    }

    public Transaction referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @ApiModelProperty(value="If the transaction was created with the [Charge](#endpoint-charge) endpoint, this value is the same as the value provided for the `reference_id` parameter in the request to that endpoint. Otherwise, it is not set.")
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public Transaction product(ProductEnum product) {
        this.product = product;
        return this;
    }

    @ApiModelProperty(value="The Square product that processed the transaction.")
    public ProductEnum getProduct() {
        return this.product;
    }

    public void setProduct(ProductEnum product) {
        this.product = product;
    }

    public Transaction clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @ApiModelProperty(value="If the transaction was created in the Square Point of Sale app, this value is the ID generated for the transaction by Square Point of Sale.  This ID has no relationship to the transaction's canonical `id`, which is generated by Square's backend servers. This value is generated for bookkeeping purposes, in case the transaction cannot immediately be completed (for example, if the transaction is processed in offline mode).  It is not currently possible with the Connect API to perform a transaction lookup by this value.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Transaction shippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    @ApiModelProperty(value="The shipping address provided in the request, if any.")
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public Transaction orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @ApiModelProperty(value="The order_id is an identifier for the order associated with this transaction, if any.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return Objects.equals(this.id, transaction.id) && Objects.equals(this.locationId, transaction.locationId) && Objects.equals(this.createdAt, transaction.createdAt) && Objects.equals(this.tenders, transaction.tenders) && Objects.equals(this.refunds, transaction.refunds) && Objects.equals(this.referenceId, transaction.referenceId) && Objects.equals((Object)this.product, (Object)transaction.product) && Objects.equals(this.clientId, transaction.clientId) && Objects.equals(this.shippingAddress, transaction.shippingAddress) && Objects.equals(this.orderId, transaction.orderId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.locationId, this.createdAt, this.tenders, this.refunds, this.referenceId, this.product, this.clientId, this.shippingAddress, this.orderId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    tenders: ").append(this.toIndentedString(this.tenders)).append("\n");
        sb.append("    refunds: ").append(this.toIndentedString(this.refunds)).append("\n");
        sb.append("    referenceId: ").append(this.toIndentedString(this.referenceId)).append("\n");
        sb.append("    product: ").append(this.toIndentedString((Object)this.product)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProductEnum {
        REGISTER("REGISTER"),
        EXTERNAL_API("EXTERNAL_API"),
        BILLING("BILLING"),
        APPOINTMENTS("APPOINTMENTS"),
        INVOICES("INVOICES"),
        ONLINE_STORE("ONLINE_STORE"),
        PAYROLL("PAYROLL"),
        OTHER("OTHER");

        private String value;

        private ProductEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProductEnum fromValue(String text) {
            for (ProductEnum b : ProductEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

