/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.V1Money;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class V1CreateRefundRequest {
    @JsonProperty(value="payment_id")
    private String paymentId = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="reason")
    private String reason = null;
    @JsonProperty(value="refunded_money")
    private V1Money refundedMoney = null;
    @JsonProperty(value="request_idempotence_key")
    private String requestIdempotenceKey = null;

    public V1CreateRefundRequest paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the payment to refund. If you're creating a PARTIAL refund for a split tender payment, instead provide the id of the particular tender you want to refund. See Split Tender Payments for details.")
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public V1CreateRefundRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="TThe type of refund (FULL or PARTIAL).")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public V1CreateRefundRequest reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(required=true, value="The reason for the refund.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1CreateRefundRequest refundedMoney(V1Money refundedMoney) {
        this.refundedMoney = refundedMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money to refund. Required only for PARTIAL refunds.")
    public V1Money getRefundedMoney() {
        return this.refundedMoney;
    }

    public void setRefundedMoney(V1Money refundedMoney) {
        this.refundedMoney = refundedMoney;
    }

    public V1CreateRefundRequest requestIdempotenceKey(String requestIdempotenceKey) {
        this.requestIdempotenceKey = requestIdempotenceKey;
        return this;
    }

    @ApiModelProperty(value="An optional key to ensure idempotence if you issue the same PARTIAL refund request more than once.")
    public String getRequestIdempotenceKey() {
        return this.requestIdempotenceKey;
    }

    public void setRequestIdempotenceKey(String requestIdempotenceKey) {
        this.requestIdempotenceKey = requestIdempotenceKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CreateRefundRequest v1CreateRefundRequest = (V1CreateRefundRequest)o;
        return Objects.equals(this.paymentId, v1CreateRefundRequest.paymentId) && Objects.equals((Object)this.type, (Object)v1CreateRefundRequest.type) && Objects.equals(this.reason, v1CreateRefundRequest.reason) && Objects.equals(this.refundedMoney, v1CreateRefundRequest.refundedMoney) && Objects.equals(this.requestIdempotenceKey, v1CreateRefundRequest.requestIdempotenceKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentId, this.type, this.reason, this.refundedMoney, this.requestIdempotenceKey});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CreateRefundRequest {\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    refundedMoney: ").append(this.toIndentedString(this.refundedMoney)).append("\n");
        sb.append("    requestIdempotenceKey: ").append(this.toIndentedString(this.requestIdempotenceKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FULL("FULL"),
        PARTIAL("PARTIAL");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

