/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.V1Money;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class V1Discount {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="rate")
    private String rate = null;
    @JsonProperty(value="amount_money")
    private V1Money amountMoney = null;
    @JsonProperty(value="discount_type")
    private DiscountTypeEnum discountType = null;
    @JsonProperty(value="pin_required")
    private Boolean pinRequired = null;
    @JsonProperty(value="color")
    private ColorEnum color = null;

    public V1Discount id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The discount's unique ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1Discount name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The discount's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1Discount rate(String rate) {
        this.rate = rate;
        return this;
    }

    @ApiModelProperty(value="The rate of the discount, as a string representation of a decimal number. A value of 0.07 corresponds to a rate of 7%. This rate is 0 if discount_type is VARIABLE_PERCENTAGE.")
    public String getRate() {
        return this.rate;
    }

    public void setRate(String rate) {
        this.rate = rate;
    }

    public V1Discount amountMoney(V1Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of the discount. This amount is 0 if discount_type is VARIABLE_AMOUNT. This field is not included for rate-based discounts.")
    public V1Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(V1Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public V1Discount discountType(DiscountTypeEnum discountType) {
        this.discountType = discountType;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the discount is a FIXED value or entered at the time of sale.")
    public DiscountTypeEnum getDiscountType() {
        return this.discountType;
    }

    public void setDiscountType(DiscountTypeEnum discountType) {
        this.discountType = discountType;
    }

    public V1Discount pinRequired(Boolean pinRequired) {
        this.pinRequired = pinRequired;
        return this;
    }

    @ApiModelProperty(value="Indicates whether a mobile staff member needs to enter their PIN to apply the discount to a payment.")
    public Boolean getPinRequired() {
        return this.pinRequired;
    }

    public void setPinRequired(Boolean pinRequired) {
        this.pinRequired = pinRequired;
    }

    public V1Discount color(ColorEnum color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(value="The color of the discount's display label in Square Register, if not the default color. The default color is 9da2a6.")
    public ColorEnum getColor() {
        return this.color;
    }

    public void setColor(ColorEnum color) {
        this.color = color;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Discount v1Discount = (V1Discount)o;
        return Objects.equals(this.id, v1Discount.id) && Objects.equals(this.name, v1Discount.name) && Objects.equals(this.rate, v1Discount.rate) && Objects.equals(this.amountMoney, v1Discount.amountMoney) && Objects.equals((Object)this.discountType, (Object)v1Discount.discountType) && Objects.equals(this.pinRequired, v1Discount.pinRequired) && Objects.equals((Object)this.color, (Object)v1Discount.color);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.rate, this.amountMoney, this.discountType, this.pinRequired, this.color});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Discount {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("    discountType: ").append(this.toIndentedString((Object)this.discountType)).append("\n");
        sb.append("    pinRequired: ").append(this.toIndentedString(this.pinRequired)).append("\n");
        sb.append("    color: ").append(this.toIndentedString((Object)this.color)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ColorEnum {
        _9DA2A6("9da2a6"),
        _4AB200("4ab200"),
        _0B8000("0b8000"),
        _2952CC("2952cc"),
        A82EE5("a82ee5"),
        E5457A("e5457a"),
        B21212("b21212"),
        _593C00("593c00"),
        E5BF00("e5BF00");

        private String value;

        private ColorEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ColorEnum fromValue(String text) {
            for (ColorEnum b : ColorEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum DiscountTypeEnum {
        FIXED("FIXED"),
        VARIABLE_PERCENTAGE("VARIABLE_PERCENTAGE"),
        VARIABLE_AMOUNT("VARIABLE_AMOUNT");

        private String value;

        private DiscountTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DiscountTypeEnum fromValue(String text) {
            for (DiscountTypeEnum b : DiscountTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

