/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class V1PageCell {
    @JsonProperty(value="page_id")
    private String pageId = null;
    @JsonProperty(value="row")
    private Integer row = null;
    @JsonProperty(value="column")
    private Integer column = null;
    @JsonProperty(value="object_type")
    private ObjectTypeEnum objectType = null;
    @JsonProperty(value="object_id")
    private String objectId = null;
    @JsonProperty(value="placeholder_type")
    private PlaceholderTypeEnum placeholderType = null;

    public V1PageCell pageId(String pageId) {
        this.pageId = pageId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the page the cell is included on.")
    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public V1PageCell row(Integer row) {
        this.row = row;
        return this;
    }

    @ApiModelProperty(value="The row of the cell. Always an integer between 0 and 4, inclusive.")
    public Integer getRow() {
        return this.row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    public V1PageCell column(Integer column) {
        this.column = column;
        return this;
    }

    @ApiModelProperty(value="The column of the cell. Always an integer between 0 and 4, inclusive.")
    public Integer getColumn() {
        return this.column;
    }

    public void setColumn(Integer column) {
        this.column = column;
    }

    public V1PageCell objectType(ObjectTypeEnum objectType) {
        this.objectType = objectType;
        return this;
    }

    @ApiModelProperty(value="The type of entity represented in the cell (ITEM, DISCOUNT, CATEGORY, or PLACEHOLDER).")
    public ObjectTypeEnum getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectTypeEnum objectType) {
        this.objectType = objectType;
    }

    public V1PageCell objectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the entity represented in the cell. Not present for cells with an object_type of PLACEHOLDER.")
    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public V1PageCell placeholderType(PlaceholderTypeEnum placeholderType) {
        this.placeholderType = placeholderType;
        return this;
    }

    @ApiModelProperty(value="For a cell with an object_type of PLACEHOLDER, this value indicates the cell's special behavior.")
    public PlaceholderTypeEnum getPlaceholderType() {
        return this.placeholderType;
    }

    public void setPlaceholderType(PlaceholderTypeEnum placeholderType) {
        this.placeholderType = placeholderType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PageCell v1PageCell = (V1PageCell)o;
        return Objects.equals(this.pageId, v1PageCell.pageId) && Objects.equals(this.row, v1PageCell.row) && Objects.equals(this.column, v1PageCell.column) && Objects.equals((Object)this.objectType, (Object)v1PageCell.objectType) && Objects.equals(this.objectId, v1PageCell.objectId) && Objects.equals((Object)this.placeholderType, (Object)v1PageCell.placeholderType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageId, this.row, this.column, this.objectType, this.objectId, this.placeholderType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PageCell {\n");
        sb.append("    pageId: ").append(this.toIndentedString(this.pageId)).append("\n");
        sb.append("    row: ").append(this.toIndentedString(this.row)).append("\n");
        sb.append("    column: ").append(this.toIndentedString(this.column)).append("\n");
        sb.append("    objectType: ").append(this.toIndentedString((Object)this.objectType)).append("\n");
        sb.append("    objectId: ").append(this.toIndentedString(this.objectId)).append("\n");
        sb.append("    placeholderType: ").append(this.toIndentedString((Object)this.placeholderType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PlaceholderTypeEnum {
        ALL_ITEMS("ALL_ITEMS"),
        DISCOUNTS_CATEGORY("DISCOUNTS_CATEGORY"),
        REWARDS_FINDER("REWARDS_FINDER");

        private String value;

        private PlaceholderTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PlaceholderTypeEnum fromValue(String text) {
            for (PlaceholderTypeEnum b : PlaceholderTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ObjectTypeEnum {
        ITEM("ITEM"),
        DISCOUNT("DISCOUNT"),
        CATEGORY("CATEGORY"),
        PLACEHOLDER("PLACEHOLDER");

        private String value;

        private ObjectTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ObjectTypeEnum fromValue(String text) {
            for (ObjectTypeEnum b : ObjectTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

