/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.V1Money;
import com.squareup.connect.models.V1PaymentDiscount;
import com.squareup.connect.models.V1PaymentItemDetail;
import com.squareup.connect.models.V1PaymentModifier;
import com.squareup.connect.models.V1PaymentTax;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class V1PaymentItemization {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="quantity")
    private BigDecimal quantity = null;
    @JsonProperty(value="itemization_type")
    private ItemizationTypeEnum itemizationType = null;
    @JsonProperty(value="item_detail")
    private V1PaymentItemDetail itemDetail = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="item_variation_name")
    private String itemVariationName = null;
    @JsonProperty(value="total_money")
    private V1Money totalMoney = null;
    @JsonProperty(value="single_quantity_money")
    private V1Money singleQuantityMoney = null;
    @JsonProperty(value="gross_sales_money")
    private V1Money grossSalesMoney = null;
    @JsonProperty(value="discount_money")
    private V1Money discountMoney = null;
    @JsonProperty(value="net_sales_money")
    private V1Money netSalesMoney = null;
    @JsonProperty(value="taxes")
    private List<V1PaymentTax> taxes = new ArrayList<V1PaymentTax>();
    @JsonProperty(value="discounts")
    private List<V1PaymentDiscount> discounts = new ArrayList<V1PaymentDiscount>();
    @JsonProperty(value="modifiers")
    private List<V1PaymentModifier> modifiers = new ArrayList<V1PaymentModifier>();

    public V1PaymentItemization name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The item's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1PaymentItemization quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="The quantity of the item purchased. This can be a decimal value.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public V1PaymentItemization itemizationType(ItemizationTypeEnum itemizationType) {
        this.itemizationType = itemizationType;
        return this;
    }

    @ApiModelProperty(value="The type of purchase that the itemization represents, such as an ITEM or CUSTOM_AMOUNT")
    public ItemizationTypeEnum getItemizationType() {
        return this.itemizationType;
    }

    public void setItemizationType(ItemizationTypeEnum itemizationType) {
        this.itemizationType = itemizationType;
    }

    public V1PaymentItemization itemDetail(V1PaymentItemDetail itemDetail) {
        this.itemDetail = itemDetail;
        return this;
    }

    @ApiModelProperty(value="Details of the item, including its unique identifier and the identifier of the item variation purchased.")
    public V1PaymentItemDetail getItemDetail() {
        return this.itemDetail;
    }

    public void setItemDetail(V1PaymentItemDetail itemDetail) {
        this.itemDetail = itemDetail;
    }

    public V1PaymentItemization notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(value="Notes entered by the merchant about the item at the time of payment, if any.")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public V1PaymentItemization itemVariationName(String itemVariationName) {
        this.itemVariationName = itemVariationName;
        return this;
    }

    @ApiModelProperty(value="The name of the item variation purchased, if any.")
    public String getItemVariationName() {
        return this.itemVariationName;
    }

    public void setItemVariationName(String itemVariationName) {
        this.itemVariationName = itemVariationName;
    }

    public V1PaymentItemization totalMoney(V1Money totalMoney) {
        this.totalMoney = totalMoney;
        return this;
    }

    @ApiModelProperty(value="The total cost of the item, including all taxes and discounts.")
    public V1Money getTotalMoney() {
        return this.totalMoney;
    }

    public void setTotalMoney(V1Money totalMoney) {
        this.totalMoney = totalMoney;
    }

    public V1PaymentItemization singleQuantityMoney(V1Money singleQuantityMoney) {
        this.singleQuantityMoney = singleQuantityMoney;
        return this;
    }

    @ApiModelProperty(value="The cost of a single unit of this item.")
    public V1Money getSingleQuantityMoney() {
        return this.singleQuantityMoney;
    }

    public void setSingleQuantityMoney(V1Money singleQuantityMoney) {
        this.singleQuantityMoney = singleQuantityMoney;
    }

    public V1PaymentItemization grossSalesMoney(V1Money grossSalesMoney) {
        this.grossSalesMoney = grossSalesMoney;
        return this;
    }

    @ApiModelProperty(value="The total cost of the itemization and its modifiers, not including taxes or discounts.")
    public V1Money getGrossSalesMoney() {
        return this.grossSalesMoney;
    }

    public void setGrossSalesMoney(V1Money grossSalesMoney) {
        this.grossSalesMoney = grossSalesMoney;
    }

    public V1PaymentItemization discountMoney(V1Money discountMoney) {
        this.discountMoney = discountMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all discounts applied to the itemization. This value is always negative or zero.")
    public V1Money getDiscountMoney() {
        return this.discountMoney;
    }

    public void setDiscountMoney(V1Money discountMoney) {
        this.discountMoney = discountMoney;
    }

    public V1PaymentItemization netSalesMoney(V1Money netSalesMoney) {
        this.netSalesMoney = netSalesMoney;
        return this;
    }

    @ApiModelProperty(value="The sum of gross_sales_money and discount_money.")
    public V1Money getNetSalesMoney() {
        return this.netSalesMoney;
    }

    public void setNetSalesMoney(V1Money netSalesMoney) {
        this.netSalesMoney = netSalesMoney;
    }

    public V1PaymentItemization taxes(List<V1PaymentTax> taxes) {
        this.taxes = taxes;
        return this;
    }

    public V1PaymentItemization addTaxesItem(V1PaymentTax taxesItem) {
        this.taxes.add(taxesItem);
        return this;
    }

    @ApiModelProperty(value="All taxes applied to this itemization.")
    public List<V1PaymentTax> getTaxes() {
        return this.taxes;
    }

    public void setTaxes(List<V1PaymentTax> taxes) {
        this.taxes = taxes;
    }

    public V1PaymentItemization discounts(List<V1PaymentDiscount> discounts) {
        this.discounts = discounts;
        return this;
    }

    public V1PaymentItemization addDiscountsItem(V1PaymentDiscount discountsItem) {
        this.discounts.add(discountsItem);
        return this;
    }

    @ApiModelProperty(value="All discounts applied to this itemization.")
    public List<V1PaymentDiscount> getDiscounts() {
        return this.discounts;
    }

    public void setDiscounts(List<V1PaymentDiscount> discounts) {
        this.discounts = discounts;
    }

    public V1PaymentItemization modifiers(List<V1PaymentModifier> modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public V1PaymentItemization addModifiersItem(V1PaymentModifier modifiersItem) {
        this.modifiers.add(modifiersItem);
        return this;
    }

    @ApiModelProperty(value="All modifier options applied to this itemization.")
    public List<V1PaymentModifier> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(List<V1PaymentModifier> modifiers) {
        this.modifiers = modifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PaymentItemization v1PaymentItemization = (V1PaymentItemization)o;
        return Objects.equals(this.name, v1PaymentItemization.name) && Objects.equals(this.quantity, v1PaymentItemization.quantity) && Objects.equals((Object)this.itemizationType, (Object)v1PaymentItemization.itemizationType) && Objects.equals(this.itemDetail, v1PaymentItemization.itemDetail) && Objects.equals(this.notes, v1PaymentItemization.notes) && Objects.equals(this.itemVariationName, v1PaymentItemization.itemVariationName) && Objects.equals(this.totalMoney, v1PaymentItemization.totalMoney) && Objects.equals(this.singleQuantityMoney, v1PaymentItemization.singleQuantityMoney) && Objects.equals(this.grossSalesMoney, v1PaymentItemization.grossSalesMoney) && Objects.equals(this.discountMoney, v1PaymentItemization.discountMoney) && Objects.equals(this.netSalesMoney, v1PaymentItemization.netSalesMoney) && Objects.equals(this.taxes, v1PaymentItemization.taxes) && Objects.equals(this.discounts, v1PaymentItemization.discounts) && Objects.equals(this.modifiers, v1PaymentItemization.modifiers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.quantity, this.itemizationType, this.itemDetail, this.notes, this.itemVariationName, this.totalMoney, this.singleQuantityMoney, this.grossSalesMoney, this.discountMoney, this.netSalesMoney, this.taxes, this.discounts, this.modifiers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PaymentItemization {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    itemizationType: ").append(this.toIndentedString((Object)this.itemizationType)).append("\n");
        sb.append("    itemDetail: ").append(this.toIndentedString(this.itemDetail)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    itemVariationName: ").append(this.toIndentedString(this.itemVariationName)).append("\n");
        sb.append("    totalMoney: ").append(this.toIndentedString(this.totalMoney)).append("\n");
        sb.append("    singleQuantityMoney: ").append(this.toIndentedString(this.singleQuantityMoney)).append("\n");
        sb.append("    grossSalesMoney: ").append(this.toIndentedString(this.grossSalesMoney)).append("\n");
        sb.append("    discountMoney: ").append(this.toIndentedString(this.discountMoney)).append("\n");
        sb.append("    netSalesMoney: ").append(this.toIndentedString(this.netSalesMoney)).append("\n");
        sb.append("    taxes: ").append(this.toIndentedString(this.taxes)).append("\n");
        sb.append("    discounts: ").append(this.toIndentedString(this.discounts)).append("\n");
        sb.append("    modifiers: ").append(this.toIndentedString(this.modifiers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ItemizationTypeEnum {
        ITEM("ITEM"),
        CUSTOM_AMOUNT("CUSTOM_AMOUNT"),
        GIFT_CARD_ACTIVATION("GIFT_CARD_ACTIVATION"),
        GIFT_CARD_RELOAD("GIFT_CARD_RELOAD"),
        GIFT_CARD_UNKNOWN("GIFT_CARD_UNKNOWN"),
        OTHER("OTHER");

        private String value;

        private ItemizationTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ItemizationTypeEnum fromValue(String text) {
            for (ItemizationTypeEnum b : ItemizationTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

