/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.V1Money;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class V1Refund {
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="reason")
    private String reason = null;
    @JsonProperty(value="refunded_money")
    private V1Money refundedMoney = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="processed_at")
    private String processedAt = null;
    @JsonProperty(value="payment_id")
    private String paymentId = null;
    @JsonProperty(value="merchant_id")
    private String merchantId = null;
    @JsonProperty(value="is_exchange")
    private Boolean isExchange = null;

    public V1Refund type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of refund ")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public V1Refund reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The merchant-specified reason for the refund.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1Refund refundedMoney(V1Money refundedMoney) {
        this.refundedMoney = refundedMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money refunded. This amount is always negative.")
    public V1Money getRefundedMoney() {
        return this.refundedMoney;
    }

    public void setRefundedMoney(V1Money refundedMoney) {
        this.refundedMoney = refundedMoney;
    }

    public V1Refund createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the merchant initiated the refund for Square to process, in ISO 8601 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public V1Refund processedAt(String processedAt) {
        this.processedAt = processedAt;
        return this;
    }

    @ApiModelProperty(value="The time when Square processed the refund on behalf of the merchant, in ISO 8601 format.")
    public String getProcessedAt() {
        return this.processedAt;
    }

    public void setProcessedAt(String processedAt) {
        this.processedAt = processedAt;
    }

    public V1Refund paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @ApiModelProperty(value="A Square-issued ID associated with the refund. For single-tender refunds, payment_id is the ID of the original payment ID. For split-tender refunds, payment_id is the ID of the original tender. For exchange-based refunds (is_exchange == true), payment_id is the ID of the original payment ID even if the payment includes other tenders.")
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public V1Refund merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public V1Refund isExchange(Boolean isExchange) {
        this.isExchange = isExchange;
        return this;
    }

    @ApiModelProperty(value="Indicates whether or not the refund is associated with an exchange. If is_exchange is true, the refund reflects the value of goods returned in the exchange not the total money refunded.")
    public Boolean getIsExchange() {
        return this.isExchange;
    }

    public void setIsExchange(Boolean isExchange) {
        this.isExchange = isExchange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Refund v1Refund = (V1Refund)o;
        return Objects.equals((Object)this.type, (Object)v1Refund.type) && Objects.equals(this.reason, v1Refund.reason) && Objects.equals(this.refundedMoney, v1Refund.refundedMoney) && Objects.equals(this.createdAt, v1Refund.createdAt) && Objects.equals(this.processedAt, v1Refund.processedAt) && Objects.equals(this.paymentId, v1Refund.paymentId) && Objects.equals(this.merchantId, v1Refund.merchantId) && Objects.equals(this.isExchange, v1Refund.isExchange);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.reason, this.refundedMoney, this.createdAt, this.processedAt, this.paymentId, this.merchantId, this.isExchange});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Refund {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    refundedMoney: ").append(this.toIndentedString(this.refundedMoney)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    processedAt: ").append(this.toIndentedString(this.processedAt)).append("\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    isExchange: ").append(this.toIndentedString(this.isExchange)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FULL("FULL"),
        PARTIAL("PARTIAL");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

