/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.V1Money;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class V1SettlementEntry {
    @JsonProperty(value="payment_id")
    private String paymentId = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="amount_money")
    private V1Money amountMoney = null;
    @JsonProperty(value="fee_money")
    private V1Money feeMoney = null;

    public V1SettlementEntry paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @ApiModelProperty(value="The settlement's unique identifier.")
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public V1SettlementEntry type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The settlement's current status.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public V1SettlementEntry amountMoney(V1Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(value="The total amount of money this entry contributes to the total settlement amount.")
    public V1Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(V1Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public V1SettlementEntry feeMoney(V1Money feeMoney) {
        this.feeMoney = feeMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of all Square fees associated with this settlement entry. This value is always negative or zero.")
    public V1Money getFeeMoney() {
        return this.feeMoney;
    }

    public void setFeeMoney(V1Money feeMoney) {
        this.feeMoney = feeMoney;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SettlementEntry v1SettlementEntry = (V1SettlementEntry)o;
        return Objects.equals(this.paymentId, v1SettlementEntry.paymentId) && Objects.equals((Object)this.type, (Object)v1SettlementEntry.type) && Objects.equals(this.amountMoney, v1SettlementEntry.amountMoney) && Objects.equals(this.feeMoney, v1SettlementEntry.feeMoney);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentId, this.type, this.amountMoney, this.feeMoney});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SettlementEntry {\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("    feeMoney: ").append(this.toIndentedString(this.feeMoney)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ADJUSTMENT("ADJUSTMENT"),
        BALANCE_CHARGE("BALANCE_CHARGE"),
        CHARGE("CHARGE"),
        FREE_PROCESSING("FREE_PROCESSING"),
        HOLD_ADJUSTMENT("HOLD_ADJUSTMENT"),
        PAID_SERVICE_FEE("PAID_SERVICE_FEE"),
        PAID_SERVICE_FEE_REFUND("PAID_SERVICE_FEE_REFUND"),
        REDEMPTION_CODE("REDEMPTION_CODE"),
        REFUND("REFUND"),
        RETURNED_PAYOUT("RETURNED_PAYOUT"),
        SQUARE_CAPITAL_ADVANCE("SQUARE_CAPITAL_ADVANCE"),
        SQUARE_CAPITAL_PAYMENT("SQUARE_CAPITAL_PAYMENT"),
        SQUARE_CAPITAL_REVERSED_PAYMENT("SQUARE_CAPITAL_REVERSED_PAYMENT"),
        SUBSCRIPTION_FEE("SUBSCRIPTION_FEE"),
        SUBSCRIPTION_FEE_REFUND("SUBSCRIPTION_FEE_REFUND"),
        OTHER("OTHER"),
        INCENTED_PAYMENT("INCENTED_PAYMENT"),
        RETURNED_ACH_ENTRY("RETURNED_ACH_ENTRY"),
        RETURNED_SQUARE_275("RETURNED_SQUARE_275"),
        SQUARE_275("SQUARE_275");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

