/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Represents a timecard for an employee.")
public class V1Timecard {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="employee_id")
    private String employeeId = null;
    @JsonProperty(value="deleted")
    private Boolean deleted = null;
    @JsonProperty(value="clockin_time")
    private String clockinTime = null;
    @JsonProperty(value="clockout_time")
    private String clockoutTime = null;
    @JsonProperty(value="clockin_location_id")
    private String clockinLocationId = null;
    @JsonProperty(value="clockout_location_id")
    private String clockoutLocationId = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="updated_at")
    private String updatedAt = null;
    @JsonProperty(value="regular_seconds_worked")
    private BigDecimal regularSecondsWorked = null;
    @JsonProperty(value="overtime_seconds_worked")
    private BigDecimal overtimeSecondsWorked = null;
    @JsonProperty(value="doubletime_seconds_worked")
    private BigDecimal doubletimeSecondsWorked = null;

    public V1Timecard id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The timecard's unique ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1Timecard employeeId(String employeeId) {
        this.employeeId = employeeId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the employee the timecard is associated with.")
    public String getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public V1Timecard deleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @ApiModelProperty(value="If true, the timecard was deleted by the merchant, and it is no longer valid.")
    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public V1Timecard clockinTime(String clockinTime) {
        this.clockinTime = clockinTime;
        return this;
    }

    @ApiModelProperty(value="The clock-in time for the timecard, in ISO 8601 format.")
    public String getClockinTime() {
        return this.clockinTime;
    }

    public void setClockinTime(String clockinTime) {
        this.clockinTime = clockinTime;
    }

    public V1Timecard clockoutTime(String clockoutTime) {
        this.clockoutTime = clockoutTime;
        return this;
    }

    @ApiModelProperty(value="The clock-out time for the timecard, in ISO 8601 format. Provide this value only if importing timecard information from another system.")
    public String getClockoutTime() {
        return this.clockoutTime;
    }

    public void setClockoutTime(String clockoutTime) {
        this.clockoutTime = clockoutTime;
    }

    public V1Timecard clockinLocationId(String clockinLocationId) {
        this.clockinLocationId = clockinLocationId;
        return this;
    }

    @ApiModelProperty(value="The ID of the location the employee clocked in from. We strongly reccomend providing a clockin_location_id. Square uses the clockin_location_id to determine a timecard\u2019s timezone and overtime rules.")
    public String getClockinLocationId() {
        return this.clockinLocationId;
    }

    public void setClockinLocationId(String clockinLocationId) {
        this.clockinLocationId = clockinLocationId;
    }

    public V1Timecard clockoutLocationId(String clockoutLocationId) {
        this.clockoutLocationId = clockoutLocationId;
        return this;
    }

    @ApiModelProperty(value="The ID of the location the employee clocked out from. Provide this value only if importing timecard information from another system.")
    public String getClockoutLocationId() {
        return this.clockoutLocationId;
    }

    public void setClockoutLocationId(String clockoutLocationId) {
        this.clockoutLocationId = clockoutLocationId;
    }

    public V1Timecard createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the timecard was created, in ISO 8601 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public V1Timecard updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="The time when the timecard was most recently updated, in ISO 8601 format.")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public V1Timecard regularSecondsWorked(BigDecimal regularSecondsWorked) {
        this.regularSecondsWorked = regularSecondsWorked;
        return this;
    }

    @ApiModelProperty(value="The total number of regular (non-overtime) seconds worked in the timecard.")
    public BigDecimal getRegularSecondsWorked() {
        return this.regularSecondsWorked;
    }

    public void setRegularSecondsWorked(BigDecimal regularSecondsWorked) {
        this.regularSecondsWorked = regularSecondsWorked;
    }

    public V1Timecard overtimeSecondsWorked(BigDecimal overtimeSecondsWorked) {
        this.overtimeSecondsWorked = overtimeSecondsWorked;
        return this;
    }

    @ApiModelProperty(value="The total number of overtime seconds worked in the timecard.")
    public BigDecimal getOvertimeSecondsWorked() {
        return this.overtimeSecondsWorked;
    }

    public void setOvertimeSecondsWorked(BigDecimal overtimeSecondsWorked) {
        this.overtimeSecondsWorked = overtimeSecondsWorked;
    }

    public V1Timecard doubletimeSecondsWorked(BigDecimal doubletimeSecondsWorked) {
        this.doubletimeSecondsWorked = doubletimeSecondsWorked;
        return this;
    }

    @ApiModelProperty(value="The total number of doubletime seconds worked in the timecard.")
    public BigDecimal getDoubletimeSecondsWorked() {
        return this.doubletimeSecondsWorked;
    }

    public void setDoubletimeSecondsWorked(BigDecimal doubletimeSecondsWorked) {
        this.doubletimeSecondsWorked = doubletimeSecondsWorked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Timecard v1Timecard = (V1Timecard)o;
        return Objects.equals(this.id, v1Timecard.id) && Objects.equals(this.employeeId, v1Timecard.employeeId) && Objects.equals(this.deleted, v1Timecard.deleted) && Objects.equals(this.clockinTime, v1Timecard.clockinTime) && Objects.equals(this.clockoutTime, v1Timecard.clockoutTime) && Objects.equals(this.clockinLocationId, v1Timecard.clockinLocationId) && Objects.equals(this.clockoutLocationId, v1Timecard.clockoutLocationId) && Objects.equals(this.createdAt, v1Timecard.createdAt) && Objects.equals(this.updatedAt, v1Timecard.updatedAt) && Objects.equals(this.regularSecondsWorked, v1Timecard.regularSecondsWorked) && Objects.equals(this.overtimeSecondsWorked, v1Timecard.overtimeSecondsWorked) && Objects.equals(this.doubletimeSecondsWorked, v1Timecard.doubletimeSecondsWorked);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.employeeId, this.deleted, this.clockinTime, this.clockoutTime, this.clockinLocationId, this.clockoutLocationId, this.createdAt, this.updatedAt, this.regularSecondsWorked, this.overtimeSecondsWorked, this.doubletimeSecondsWorked);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Timecard {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    employeeId: ").append(this.toIndentedString(this.employeeId)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    clockinTime: ").append(this.toIndentedString(this.clockinTime)).append("\n");
        sb.append("    clockoutTime: ").append(this.toIndentedString(this.clockoutTime)).append("\n");
        sb.append("    clockinLocationId: ").append(this.toIndentedString(this.clockinLocationId)).append("\n");
        sb.append("    clockoutLocationId: ").append(this.toIndentedString(this.clockoutLocationId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    regularSecondsWorked: ").append(this.toIndentedString(this.regularSecondsWorked)).append("\n");
        sb.append("    overtimeSecondsWorked: ").append(this.toIndentedString(this.overtimeSecondsWorked)).append("\n");
        sb.append("    doubletimeSecondsWorked: ").append(this.toIndentedString(this.doubletimeSecondsWorked)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

