/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class V1UpdateOrderRequest {
    @JsonProperty(value="action")
    private ActionEnum action = null;
    @JsonProperty(value="shipped_tracking_number")
    private String shippedTrackingNumber = null;
    @JsonProperty(value="completed_note")
    private String completedNote = null;
    @JsonProperty(value="refunded_note")
    private String refundedNote = null;
    @JsonProperty(value="canceled_note")
    private String canceledNote = null;

    public V1UpdateOrderRequest action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(required=true, value="The action to perform on the order (COMPLETE, CANCEL, or REFUND).")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public V1UpdateOrderRequest shippedTrackingNumber(String shippedTrackingNumber) {
        this.shippedTrackingNumber = shippedTrackingNumber;
        return this;
    }

    @ApiModelProperty(value="The tracking number of the shipment associated with the order. Only valid if action is COMPLETE.")
    public String getShippedTrackingNumber() {
        return this.shippedTrackingNumber;
    }

    public void setShippedTrackingNumber(String shippedTrackingNumber) {
        this.shippedTrackingNumber = shippedTrackingNumber;
    }

    public V1UpdateOrderRequest completedNote(String completedNote) {
        this.completedNote = completedNote;
        return this;
    }

    @ApiModelProperty(value="A merchant-specified note about the completion of the order. Only valid if action is COMPLETE.")
    public String getCompletedNote() {
        return this.completedNote;
    }

    public void setCompletedNote(String completedNote) {
        this.completedNote = completedNote;
    }

    public V1UpdateOrderRequest refundedNote(String refundedNote) {
        this.refundedNote = refundedNote;
        return this;
    }

    @ApiModelProperty(value="A merchant-specified note about the refunding of the order. Only valid if action is REFUND.")
    public String getRefundedNote() {
        return this.refundedNote;
    }

    public void setRefundedNote(String refundedNote) {
        this.refundedNote = refundedNote;
    }

    public V1UpdateOrderRequest canceledNote(String canceledNote) {
        this.canceledNote = canceledNote;
        return this;
    }

    @ApiModelProperty(value="A merchant-specified note about the canceling of the order. Only valid if action is CANCEL.")
    public String getCanceledNote() {
        return this.canceledNote;
    }

    public void setCanceledNote(String canceledNote) {
        this.canceledNote = canceledNote;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1UpdateOrderRequest v1UpdateOrderRequest = (V1UpdateOrderRequest)o;
        return Objects.equals((Object)this.action, (Object)v1UpdateOrderRequest.action) && Objects.equals(this.shippedTrackingNumber, v1UpdateOrderRequest.shippedTrackingNumber) && Objects.equals(this.completedNote, v1UpdateOrderRequest.completedNote) && Objects.equals(this.refundedNote, v1UpdateOrderRequest.refundedNote) && Objects.equals(this.canceledNote, v1UpdateOrderRequest.canceledNote);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.shippedTrackingNumber, this.completedNote, this.refundedNote, this.canceledNote});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1UpdateOrderRequest {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    shippedTrackingNumber: ").append(this.toIndentedString(this.shippedTrackingNumber)).append("\n");
        sb.append("    completedNote: ").append(this.toIndentedString(this.completedNote)).append("\n");
        sb.append("    refundedNote: ").append(this.toIndentedString(this.refundedNote)).append("\n");
        sb.append("    canceledNote: ").append(this.toIndentedString(this.canceledNote)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ActionEnum {
        COMPLETE("COMPLETE"),
        CANCEL("CANCEL"),
        REFUND("REFUND");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String text) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

