/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.api;

import com.squareup.connect.ApiClient;
import com.squareup.connect.ApiException;
import com.squareup.connect.CompleteResponse;
import com.squareup.connect.Configuration;
import com.squareup.connect.Pair;
import com.squareup.connect.models.CreateCustomerCardRequest;
import com.squareup.connect.models.CreateCustomerCardResponse;
import com.squareup.connect.models.CreateCustomerRequest;
import com.squareup.connect.models.CreateCustomerResponse;
import com.squareup.connect.models.DeleteCustomerCardResponse;
import com.squareup.connect.models.DeleteCustomerResponse;
import com.squareup.connect.models.ListCustomersResponse;
import com.squareup.connect.models.RetrieveCustomerResponse;
import com.squareup.connect.models.SearchCustomersRequest;
import com.squareup.connect.models.SearchCustomersResponse;
import com.squareup.connect.models.UpdateCustomerRequest;
import com.squareup.connect.models.UpdateCustomerResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class CustomersApi {
    private ApiClient apiClient;

    public CustomersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CreateCustomerResponse createCustomer(CreateCustomerRequest body) throws ApiException {
        CreateCustomerRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCustomer");
        }
        String localVarPath = "/v2/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<CreateCustomerResponse> localVarReturnType = new GenericType<CreateCustomerResponse>(){};
        CompleteResponse<CreateCustomerResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<CreateCustomerResponse> createCustomerWithHttpInfo(CreateCustomerRequest body) throws ApiException {
        CreateCustomerRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCustomer");
        }
        String localVarPath = "/v2/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<CreateCustomerResponse> localVarReturnType = new GenericType<CreateCustomerResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreateCustomerCardResponse createCustomerCard(String customerId, CreateCustomerCardRequest body) throws ApiException {
        CreateCustomerCardRequest localVarPostBody = body;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling createCustomerCard");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCustomerCard");
        }
        String localVarPath = "/v2/customers/{customer_id}/cards".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<CreateCustomerCardResponse> localVarReturnType = new GenericType<CreateCustomerCardResponse>(){};
        CompleteResponse<CreateCustomerCardResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<CreateCustomerCardResponse> createCustomerCardWithHttpInfo(String customerId, CreateCustomerCardRequest body) throws ApiException {
        CreateCustomerCardRequest localVarPostBody = body;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling createCustomerCard");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCustomerCard");
        }
        String localVarPath = "/v2/customers/{customer_id}/cards".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<CreateCustomerCardResponse> localVarReturnType = new GenericType<CreateCustomerCardResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DeleteCustomerResponse deleteCustomer(String customerId) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling deleteCustomer");
        }
        String localVarPath = "/v2/customers/{customer_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<DeleteCustomerResponse> localVarReturnType = new GenericType<DeleteCustomerResponse>(){};
        CompleteResponse<DeleteCustomerResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<DeleteCustomerResponse> deleteCustomerWithHttpInfo(String customerId) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling deleteCustomer");
        }
        String localVarPath = "/v2/customers/{customer_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<DeleteCustomerResponse> localVarReturnType = new GenericType<DeleteCustomerResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DeleteCustomerCardResponse deleteCustomerCard(String customerId, String cardId) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling deleteCustomerCard");
        }
        if (cardId == null) {
            throw new ApiException(400, "Missing the required parameter 'cardId' when calling deleteCustomerCard");
        }
        String localVarPath = "/v2/customers/{customer_id}/cards/{card_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString())).replaceAll("\\{card_id\\}", this.apiClient.escapeString(cardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<DeleteCustomerCardResponse> localVarReturnType = new GenericType<DeleteCustomerCardResponse>(){};
        CompleteResponse<DeleteCustomerCardResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<DeleteCustomerCardResponse> deleteCustomerCardWithHttpInfo(String customerId, String cardId) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling deleteCustomerCard");
        }
        if (cardId == null) {
            throw new ApiException(400, "Missing the required parameter 'cardId' when calling deleteCustomerCard");
        }
        String localVarPath = "/v2/customers/{customer_id}/cards/{card_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString())).replaceAll("\\{card_id\\}", this.apiClient.escapeString(cardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<DeleteCustomerCardResponse> localVarReturnType = new GenericType<DeleteCustomerCardResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ListCustomersResponse listCustomers(String cursor, String sortField, String sortOrder) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_field", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_order", sortOrder));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<ListCustomersResponse> localVarReturnType = new GenericType<ListCustomersResponse>(){};
        CompleteResponse<ListCustomersResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<ListCustomersResponse> listCustomersWithHttpInfo(String cursor, String sortField, String sortOrder) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_field", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_order", sortOrder));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<ListCustomersResponse> localVarReturnType = new GenericType<ListCustomersResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RetrieveCustomerResponse retrieveCustomer(String customerId) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling retrieveCustomer");
        }
        String localVarPath = "/v2/customers/{customer_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveCustomerResponse> localVarReturnType = new GenericType<RetrieveCustomerResponse>(){};
        CompleteResponse<RetrieveCustomerResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<RetrieveCustomerResponse> retrieveCustomerWithHttpInfo(String customerId) throws ApiException {
        Object localVarPostBody = null;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling retrieveCustomer");
        }
        String localVarPath = "/v2/customers/{customer_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveCustomerResponse> localVarReturnType = new GenericType<RetrieveCustomerResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SearchCustomersResponse searchCustomers(SearchCustomersRequest body) throws ApiException {
        SearchCustomersRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling searchCustomers");
        }
        String localVarPath = "/v2/customers/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<SearchCustomersResponse> localVarReturnType = new GenericType<SearchCustomersResponse>(){};
        CompleteResponse<SearchCustomersResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<SearchCustomersResponse> searchCustomersWithHttpInfo(SearchCustomersRequest body) throws ApiException {
        SearchCustomersRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling searchCustomers");
        }
        String localVarPath = "/v2/customers/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<SearchCustomersResponse> localVarReturnType = new GenericType<SearchCustomersResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UpdateCustomerResponse updateCustomer(String customerId, UpdateCustomerRequest body) throws ApiException {
        UpdateCustomerRequest localVarPostBody = body;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling updateCustomer");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCustomer");
        }
        String localVarPath = "/v2/customers/{customer_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<UpdateCustomerResponse> localVarReturnType = new GenericType<UpdateCustomerResponse>(){};
        CompleteResponse<UpdateCustomerResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<UpdateCustomerResponse> updateCustomerWithHttpInfo(String customerId, UpdateCustomerRequest body) throws ApiException {
        UpdateCustomerRequest localVarPostBody = body;
        if (customerId == null) {
            throw new ApiException(400, "Missing the required parameter 'customerId' when calling updateCustomer");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCustomer");
        }
        String localVarPath = "/v2/customers/{customer_id}".replaceAll("\\{customer_id\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<UpdateCustomerResponse> localVarReturnType = new GenericType<UpdateCustomerResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

