/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.api;

import com.squareup.connect.ApiClient;
import com.squareup.connect.ApiException;
import com.squareup.connect.CompleteResponse;
import com.squareup.connect.Configuration;
import com.squareup.connect.Pair;
import com.squareup.connect.models.ObtainTokenRequest;
import com.squareup.connect.models.ObtainTokenResponse;
import com.squareup.connect.models.RenewTokenRequest;
import com.squareup.connect.models.RenewTokenResponse;
import com.squareup.connect.models.RevokeTokenRequest;
import com.squareup.connect.models.RevokeTokenResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class OAuthApi {
    private ApiClient apiClient;

    public OAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OAuthApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ObtainTokenResponse obtainToken(ObtainTokenRequest body) throws ApiException {
        ObtainTokenRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling obtainToken");
        }
        String localVarPath = "/oauth2/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ObtainTokenResponse> localVarReturnType = new GenericType<ObtainTokenResponse>(){};
        CompleteResponse<ObtainTokenResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<ObtainTokenResponse> obtainTokenWithHttpInfo(ObtainTokenRequest body) throws ApiException {
        ObtainTokenRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling obtainToken");
        }
        String localVarPath = "/oauth2/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ObtainTokenResponse> localVarReturnType = new GenericType<ObtainTokenResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RenewTokenResponse renewToken(String clientId, RenewTokenRequest body) throws ApiException {
        RenewTokenRequest localVarPostBody = body;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling renewToken");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling renewToken");
        }
        String localVarPath = "/oauth2/clients/{client_id}/access-token/renew".replaceAll("\\{client_id\\}", this.apiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientSecret"};
        GenericType<RenewTokenResponse> localVarReturnType = new GenericType<RenewTokenResponse>(){};
        CompleteResponse<RenewTokenResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<RenewTokenResponse> renewTokenWithHttpInfo(String clientId, RenewTokenRequest body) throws ApiException {
        RenewTokenRequest localVarPostBody = body;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling renewToken");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling renewToken");
        }
        String localVarPath = "/oauth2/clients/{client_id}/access-token/renew".replaceAll("\\{client_id\\}", this.apiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientSecret"};
        GenericType<RenewTokenResponse> localVarReturnType = new GenericType<RenewTokenResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RevokeTokenResponse revokeToken(RevokeTokenRequest body) throws ApiException {
        RevokeTokenRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling revokeToken");
        }
        String localVarPath = "/oauth2/revoke";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientSecret"};
        GenericType<RevokeTokenResponse> localVarReturnType = new GenericType<RevokeTokenResponse>(){};
        CompleteResponse<RevokeTokenResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<RevokeTokenResponse> revokeTokenWithHttpInfo(RevokeTokenRequest body) throws ApiException {
        RevokeTokenRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling revokeToken");
        }
        String localVarPath = "/oauth2/revoke";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientSecret"};
        GenericType<RevokeTokenResponse> localVarReturnType = new GenericType<RevokeTokenResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

