/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.api;

import com.squareup.connect.ApiClient;
import com.squareup.connect.ApiException;
import com.squareup.connect.CompleteResponse;
import com.squareup.connect.Configuration;
import com.squareup.connect.Pair;
import com.squareup.connect.models.V1BankAccount;
import com.squareup.connect.models.V1CreateRefundRequest;
import com.squareup.connect.models.V1Order;
import com.squareup.connect.models.V1Payment;
import com.squareup.connect.models.V1Refund;
import com.squareup.connect.models.V1Settlement;
import com.squareup.connect.models.V1UpdateOrderRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class V1TransactionsApi {
    private ApiClient apiClient;

    public V1TransactionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public V1TransactionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public V1Refund createRefund(String locationId, V1CreateRefundRequest body) throws ApiException {
        V1CreateRefundRequest localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createRefund");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRefund");
        }
        String localVarPath = "/v1/{location_id}/refunds".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Refund> localVarReturnType = new GenericType<V1Refund>(){};
        CompleteResponse<V1Refund> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Refund> createRefundWithHttpInfo(String locationId, V1CreateRefundRequest body) throws ApiException {
        V1CreateRefundRequest localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createRefund");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRefund");
        }
        String localVarPath = "/v1/{location_id}/refunds".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Refund> localVarReturnType = new GenericType<V1Refund>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1BankAccount> listBankAccounts(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listBankAccounts");
        }
        String localVarPath = "/v1/{location_id}/bank-accounts".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1BankAccount>> localVarReturnType = new GenericType<List<V1BankAccount>>(){};
        CompleteResponse<List<V1BankAccount>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1BankAccount>> listBankAccountsWithHttpInfo(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listBankAccounts");
        }
        String localVarPath = "/v1/{location_id}/bank-accounts".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1BankAccount>> localVarReturnType = new GenericType<List<V1BankAccount>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1Order> listOrders(String locationId, String order, Integer limit, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listOrders");
        }
        String localVarPath = "/v1/{location_id}/orders".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Order>> localVarReturnType = new GenericType<List<V1Order>>(){};
        CompleteResponse<List<V1Order>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1Order>> listOrdersWithHttpInfo(String locationId, String order, Integer limit, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listOrders");
        }
        String localVarPath = "/v1/{location_id}/orders".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Order>> localVarReturnType = new GenericType<List<V1Order>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1Payment> listPayments(String locationId, String order, String beginTime, String endTime, Integer limit, String batchToken, Boolean includePartial) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listPayments");
        }
        String localVarPath = "/v1/{location_id}/payments".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_time", beginTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_time", endTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_partial", includePartial));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Payment>> localVarReturnType = new GenericType<List<V1Payment>>(){};
        CompleteResponse<List<V1Payment>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1Payment>> listPaymentsWithHttpInfo(String locationId, String order, String beginTime, String endTime, Integer limit, String batchToken, Boolean includePartial) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listPayments");
        }
        String localVarPath = "/v1/{location_id}/payments".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_time", beginTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_time", endTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_partial", includePartial));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Payment>> localVarReturnType = new GenericType<List<V1Payment>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1Refund> listRefunds(String locationId, String order, String beginTime, String endTime, Integer limit, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listRefunds");
        }
        String localVarPath = "/v1/{location_id}/refunds".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_time", beginTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_time", endTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Refund>> localVarReturnType = new GenericType<List<V1Refund>>(){};
        CompleteResponse<List<V1Refund>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1Refund>> listRefundsWithHttpInfo(String locationId, String order, String beginTime, String endTime, Integer limit, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listRefunds");
        }
        String localVarPath = "/v1/{location_id}/refunds".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_time", beginTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_time", endTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Refund>> localVarReturnType = new GenericType<List<V1Refund>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<V1Settlement> listSettlements(String locationId, String order, String beginTime, String endTime, Integer limit, String status, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listSettlements");
        }
        String localVarPath = "/v1/{location_id}/settlements".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_time", beginTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_time", endTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Settlement>> localVarReturnType = new GenericType<List<V1Settlement>>(){};
        CompleteResponse<List<V1Settlement>> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<List<V1Settlement>> listSettlementsWithHttpInfo(String locationId, String order, String beginTime, String endTime, Integer limit, String status, String batchToken) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listSettlements");
        }
        String localVarPath = "/v1/{location_id}/settlements".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_time", beginTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_time", endTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "batch_token", batchToken));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<List<V1Settlement>> localVarReturnType = new GenericType<List<V1Settlement>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1BankAccount retrieveBankAccount(String locationId, String bankAccountId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveBankAccount");
        }
        if (bankAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'bankAccountId' when calling retrieveBankAccount");
        }
        String localVarPath = "/v1/{location_id}/bank-accounts/{bank_account_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{bank_account_id\\}", this.apiClient.escapeString(bankAccountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1BankAccount> localVarReturnType = new GenericType<V1BankAccount>(){};
        CompleteResponse<V1BankAccount> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1BankAccount> retrieveBankAccountWithHttpInfo(String locationId, String bankAccountId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveBankAccount");
        }
        if (bankAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'bankAccountId' when calling retrieveBankAccount");
        }
        String localVarPath = "/v1/{location_id}/bank-accounts/{bank_account_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{bank_account_id\\}", this.apiClient.escapeString(bankAccountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1BankAccount> localVarReturnType = new GenericType<V1BankAccount>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Order retrieveOrder(String locationId, String orderId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveOrder");
        }
        if (orderId == null) {
            throw new ApiException(400, "Missing the required parameter 'orderId' when calling retrieveOrder");
        }
        String localVarPath = "/v1/{location_id}/orders/{order_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Order> localVarReturnType = new GenericType<V1Order>(){};
        CompleteResponse<V1Order> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Order> retrieveOrderWithHttpInfo(String locationId, String orderId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveOrder");
        }
        if (orderId == null) {
            throw new ApiException(400, "Missing the required parameter 'orderId' when calling retrieveOrder");
        }
        String localVarPath = "/v1/{location_id}/orders/{order_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Order> localVarReturnType = new GenericType<V1Order>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Payment retrievePayment(String locationId, String paymentId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrievePayment");
        }
        if (paymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'paymentId' when calling retrievePayment");
        }
        String localVarPath = "/v1/{location_id}/payments/{payment_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{payment_id\\}", this.apiClient.escapeString(paymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Payment> localVarReturnType = new GenericType<V1Payment>(){};
        CompleteResponse<V1Payment> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Payment> retrievePaymentWithHttpInfo(String locationId, String paymentId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrievePayment");
        }
        if (paymentId == null) {
            throw new ApiException(400, "Missing the required parameter 'paymentId' when calling retrievePayment");
        }
        String localVarPath = "/v1/{location_id}/payments/{payment_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{payment_id\\}", this.apiClient.escapeString(paymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Payment> localVarReturnType = new GenericType<V1Payment>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Settlement retrieveSettlement(String locationId, String settlementId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveSettlement");
        }
        if (settlementId == null) {
            throw new ApiException(400, "Missing the required parameter 'settlementId' when calling retrieveSettlement");
        }
        String localVarPath = "/v1/{location_id}/settlements/{settlement_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{settlement_id\\}", this.apiClient.escapeString(settlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Settlement> localVarReturnType = new GenericType<V1Settlement>(){};
        CompleteResponse<V1Settlement> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Settlement> retrieveSettlementWithHttpInfo(String locationId, String settlementId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveSettlement");
        }
        if (settlementId == null) {
            throw new ApiException(400, "Missing the required parameter 'settlementId' when calling retrieveSettlement");
        }
        String localVarPath = "/v1/{location_id}/settlements/{settlement_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{settlement_id\\}", this.apiClient.escapeString(settlementId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Settlement> localVarReturnType = new GenericType<V1Settlement>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public V1Order updateOrder(String locationId, String orderId, V1UpdateOrderRequest body) throws ApiException {
        V1UpdateOrderRequest localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateOrder");
        }
        if (orderId == null) {
            throw new ApiException(400, "Missing the required parameter 'orderId' when calling updateOrder");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOrder");
        }
        String localVarPath = "/v1/{location_id}/orders/{order_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("Square-Version", "2019-03-27");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Order> localVarReturnType = new GenericType<V1Order>(){};
        CompleteResponse<V1Order> completeResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<V1Order> updateOrderWithHttpInfo(String locationId, String orderId, V1UpdateOrderRequest body) throws ApiException {
        V1UpdateOrderRequest localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updateOrder");
        }
        if (orderId == null) {
            throw new ApiException(400, "Missing the required parameter 'orderId' when calling updateOrder");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOrder");
        }
        String localVarPath = "/v1/{location_id}/orders/{order_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<V1Order> localVarReturnType = new GenericType<V1Order>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

